/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.network;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.core.network.TeslaNetworkStream;

public class TeslaNetworkPlayer
extends UIPlayer {
    private TeslaNetworkStream qStream = null;

    public TeslaNetworkPlayer(Socket socket) throws UnknownHostException, IOException {
        this.qStream = new TeslaNetworkStream(socket);
    }

    @Override
    public Response executeCommand(Command command) throws IOException {
        this.qStream.writeCommand(command);
        return this.qStream.readResponse();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.qStream.terminate();
    }

    public void updateSocket(Socket communicationSocket) throws UnknownHostException, IOException {
        Socket old;
        if (this.qStream != null && (old = this.qStream.getSocket()) != null) {
            try {
                old.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.qStream = new TeslaNetworkStream(communicationSocket);
    }

    @Override
    protected void handleFailure(Throwable e) {
        if (this.qStream != null) {
            try {
                Socket s = this.qStream.getSocket();
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

