/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MaxScoreCache;

public final class ImpactsDISI
extends DocIdSetIterator {
    private final DocIdSetIterator in;
    private final MaxScoreCache maxScoreCache;
    private float minCompetitiveScore = 0.0f;
    private int upTo = Integer.MAX_VALUE;
    private float maxScore = Float.MAX_VALUE;

    public ImpactsDISI(DocIdSetIterator in, MaxScoreCache maxScoreCache) {
        this.in = in;
        this.maxScoreCache = maxScoreCache;
    }

    public MaxScoreCache getMaxScoreCache() {
        return this.maxScoreCache;
    }

    public void setMinCompetitiveScore(float minCompetitiveScore) {
        assert (minCompetitiveScore >= this.minCompetitiveScore);
        if (minCompetitiveScore > this.minCompetitiveScore) {
            this.minCompetitiveScore = minCompetitiveScore;
            this.upTo = -1;
        }
    }

    private int advanceTarget(int target) throws IOException {
        if (target <= this.upTo) {
            return target;
        }
        this.upTo = this.maxScoreCache.advanceShallow(target);
        this.maxScore = this.maxScoreCache.getMaxScoreForLevelZero();
        while (true) {
            assert (this.upTo >= target);
            if (this.maxScore >= this.minCompetitiveScore) {
                return target;
            }
            if (this.upTo == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int skipUpTo = this.maxScoreCache.getSkipUpTo(this.minCompetitiveScore);
            if (skipUpTo == -1) {
                target = this.upTo + 1;
            } else {
                if (skipUpTo == Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                target = skipUpTo + 1;
            }
            this.upTo = this.maxScoreCache.advanceShallow(target);
            this.maxScore = this.maxScoreCache.getMaxScoreForLevelZero();
        }
    }

    @Override
    public int advance(int target) throws IOException {
        return this.in.advance(this.advanceTarget(target));
    }

    @Override
    public int nextDoc() throws IOException {
        DocIdSetIterator in = this.in;
        if (in.docID() < this.upTo) {
            return in.nextDoc();
        }
        return this.advance(in.docID() + 1);
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public long cost() {
        return this.in.cost();
    }
}

