/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.Color;

public class SimpleCommandPrinter {
    public static String toString(Command command) {
        if (command == null) {
            return "NULL COMMAND";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(command.eClass().getName());
        EClass eClass = command.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature f : features) {
            Object eGet = command.eGet(f);
            if (eGet == null) continue;
            StringBuilder temp = new StringBuilder();
            if (eGet instanceof Element) {
                temp.append(SimpleCommandPrinter.toString((Element)eGet));
            } else if (eGet instanceof EObject) {
                String content = SimpleCommandPrinter.toString((EObject)eGet, false, new String[0]);
                if (content.length() > 0) {
                    temp.append('{').append(content).append('}');
                }
            } else if (eGet instanceof Character) {
                temp.append('{').append(Integer.toHexString(((Character)eGet).charValue())).append('}');
            } else if (eGet instanceof List) {
                List l = (List)eGet;
                if (l.size() > 0) {
                    temp.append(eGet);
                }
            } else {
                temp.append('{').append(eGet).append('}');
            }
            if (temp.length() <= 0) continue;
            builder.append(" -").append(f.getName()).append(' ').append(temp.toString());
        }
        return builder.toString();
    }

    public static String toString(EObject obj, boolean alwaysNeedArgs, String ... ignores) {
        if (obj instanceof Color) {
            Color color = (Color)obj;
            return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        }
        StringBuilder builder = new StringBuilder();
        EClass eClass = obj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature f : features) {
            Object eGet = obj.eGet(f);
            boolean needArg = true;
            Object defaultValue = f.getDefaultValue();
            boolean bl = needArg = defaultValue == null || !defaultValue.equals(eGet);
            if (alwaysNeedArgs) {
                needArg = true;
            }
            if (eGet instanceof List && ((List)eGet).size() == 0) {
                needArg = false;
            }
            String[] stringArray = ignores;
            int n = ignores.length;
            int n2 = 0;
            while (n2 < n) {
                String ignore = stringArray[n2];
                if (ignore.equals(f.getName())) {
                    needArg = false;
                    break;
                }
                ++n2;
            }
            if (eGet == null || !needArg) continue;
            builder.append(' ').append(f.getName()).append('=');
            if (eGet instanceof Element) {
                builder.append(SimpleCommandPrinter.toString((Element)eGet));
                continue;
            }
            if (eGet instanceof EObject) {
                builder.append('{').append(SimpleCommandPrinter.toString((EObject)eGet, alwaysNeedArgs, "eFactoryInstance")).append('}');
                continue;
            }
            builder.append('{').append(eGet).append('}');
        }
        return builder.toString();
    }

    public static String toString(Element e) {
        return e.getId();
    }

    public static String toString(List<Element> e) {
        if (e.size() == 1) {
            return SimpleCommandPrinter.toString(e.get(0));
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int index = 0;
        for (Element element : e) {
            builder.append(++index > 0 ? " " : "").append(SimpleCommandPrinter.toString(element));
        }
        builder.append(']');
        return builder.toString();
    }
}

