/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.commands.GetLog;
import org.eclipse.rcptt.ecl.platform.internal.commands.LogService;
import org.eclipse.rcptt.ecl.platform.internal.log.LogEntry;
import org.eclipse.rcptt.ecl.platform.internal.log.LogReader;
import org.eclipse.rcptt.ecl.platform.util.EclPlatformUtil;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class GetLogService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof GetLog)) {
            return Status.CANCEL_STATUS;
        }
        GetLog getLog = (GetLog)command;
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        ArrayList<Integer> severitiesToLog = new ArrayList<Integer>();
        if (getLog.getLevels().isEmpty()) {
            severitiesToLog.addAll(Arrays.asList(4, 2, 0, 8, 1));
        } else {
            for (String level : getLog.getLevels()) {
                if (!LogService.severities.containsKey(level.toLowerCase())) {
                    return new Status(4, "org.eclipse.rcptt.ecl.platform", String.format("Unknown log entry level '%s'", level));
                }
                severitiesToLog.add(LogService.severities.get(level.toLowerCase()));
            }
        }
        LogReader.parseLogFile(Platform.getLogFileLocation().toFile(), entries, getLog.getLimit(), false, severitiesToLog);
        for (LogEntry entry : entries) {
            context.getOutput().write((Object)EclPlatformUtil.createMessage(entry));
        }
        context.getOutput().close(Status.OK_STATUS);
        return Status.OK_STATUS;
    }
}

