/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AssertKind implements Enumerator
{
    EQUALS(0, "Equals", "equals"),
    NOT_EQUALS(1, "NotEquals", "doesn't equal"),
    NOT_NULL(2, "NotNull", "NotNull"),
    ASSERT_TRUE(3, "AssertTrue", "is true"),
    ASSERT_FALSE(4, "AssertFalse", "is false"),
    CONTAINS(5, "Contains", "contains"),
    REGEXP(6, "Regexp", "matches"),
    CONTAINS_IMAGE(7, "ContainsImage", "ContainsImage"),
    IMAGE_CONTAINS_TEXT(8, "ImageContainsText", "ImageContainsText"),
    NOT_CONTAINS(9, "NotContains", "doesn't contain"),
    NOT_REGEXP(10, "NotRegexp", "doesn't match"),
    IS_EMPTY(11, "IsEmpty", "is empty"),
    NOT_EMPTY(12, "NotEmpty", "isn't empty");

    public static final int EQUALS_VALUE = 0;
    public static final int NOT_EQUALS_VALUE = 1;
    public static final int NOT_NULL_VALUE = 2;
    public static final int ASSERT_TRUE_VALUE = 3;
    public static final int ASSERT_FALSE_VALUE = 4;
    public static final int CONTAINS_VALUE = 5;
    public static final int REGEXP_VALUE = 6;
    public static final int CONTAINS_IMAGE_VALUE = 7;
    public static final int IMAGE_CONTAINS_TEXT_VALUE = 8;
    public static final int NOT_CONTAINS_VALUE = 9;
    public static final int NOT_REGEXP_VALUE = 10;
    public static final int IS_EMPTY_VALUE = 11;
    public static final int NOT_EMPTY_VALUE = 12;
    private static final AssertKind[] VALUES_ARRAY;
    public static final List<AssertKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssertKind[]{EQUALS, NOT_EQUALS, NOT_NULL, ASSERT_TRUE, ASSERT_FALSE, CONTAINS, REGEXP, CONTAINS_IMAGE, IMAGE_CONTAINS_TEXT, NOT_CONTAINS, NOT_REGEXP, IS_EMPTY, NOT_EMPTY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssertKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssertKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssertKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssertKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssertKind get(int value) {
        switch (value) {
            case 0: {
                return EQUALS;
            }
            case 1: {
                return NOT_EQUALS;
            }
            case 2: {
                return NOT_NULL;
            }
            case 3: {
                return ASSERT_TRUE;
            }
            case 4: {
                return ASSERT_FALSE;
            }
            case 5: {
                return CONTAINS;
            }
            case 6: {
                return REGEXP;
            }
            case 7: {
                return CONTAINS_IMAGE;
            }
            case 8: {
                return IMAGE_CONTAINS_TEXT;
            }
            case 9: {
                return NOT_CONTAINS;
            }
            case 10: {
                return NOT_REGEXP;
            }
            case 11: {
                return IS_EMPTY;
            }
            case 12: {
                return NOT_EMPTY;
            }
        }
        return null;
    }

    private AssertKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

