/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IPrototypeAttributesLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab2;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab2,
IPrototypeAttributesLabelProvider {
    private Control fControl;
    private ILaunchConfigurationDialog fLaunchConfigurationDialog;
    private String fErrorMessage;
    private String fWarningMessage;
    private String fMessage;
    private boolean fDirty = true;
    private Job fRereshJob;
    private String fHelpContextId = null;
    private final Map<String, String> fAttributesLabelsForPrototype = new HashMap<String, String>();

    public AbstractLaunchConfigurationTab() {
        this.initializeAttributes();
    }

    protected void initializeAttributes() {
    }

    public String getAttributeLabel(String attribute) {
        String label = this.fAttributesLabelsForPrototype.get(attribute);
        if (label != null) {
            return label;
        }
        return null;
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            this.getLaunchConfigurationDialog().updateButtons();
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    @Override
    public Control getControl() {
        return this.fControl;
    }

    protected void setControl(Control control) {
        this.fControl = control;
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public String getWarningMessage() {
        return this.fWarningMessage;
    }

    @Override
    public String getMessage() {
        return this.fMessage;
    }

    @Override
    @Deprecated
    public void launched(ILaunch launch) {
    }

    @Override
    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.fLaunchConfigurationDialog = dialog;
    }

    protected void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    protected void setWarningMessage(String warningMessage) {
        this.fWarningMessage = warningMessage;
    }

    protected void setMessage(String message) {
        this.fMessage = message;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    @Override
    public void dispose() {
    }

    protected Shell getShell() {
        Control control = this.getControl();
        if (control != null) {
            return control.getShell();
        }
        return null;
    }

    protected Button createPushButton(Composite parent, String label, Image image) {
        return SWTFactory.createPushButton(parent, label, image);
    }

    protected Button createRadioButton(Composite parent, String label) {
        return SWTFactory.createRadioButton(parent, label);
    }

    protected Button createCheckButton(Composite parent, String label) {
        return SWTFactory.createCheckButton(parent, label, null, false, 1);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        SWTFactory.createVerticalSpacer(comp, colSpan);
    }

    protected void createSeparator(Composite comp, int colSpan) {
        Label label = new Label(comp, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    @Override
    public Image getImage() {
        return null;
    }

    public String getId() {
        return null;
    }

    protected void setAttribute(String attribute, ILaunchConfigurationWorkingCopy configuration, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            configuration.setAttribute(attribute, null);
        } else {
            configuration.setAttribute(attribute, value);
        }
    }

    protected boolean isDirty() {
        return this.fDirty;
    }

    protected void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    @Override
    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    @Override
    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.performApply(workingCopy);
    }

    private Job getUpdateJob() {
        if (this.fRereshJob == null) {
            this.fRereshJob = this.createUpdateJob();
            this.fRereshJob.setSystem(true);
        }
        return this.fRereshJob;
    }

    protected void scheduleUpdateJob() {
        Job job = this.getUpdateJob();
        job.cancel();
        job.schedule(this.getUpdateJobDelay());
    }

    protected Job createUpdateJob() {
        return new WorkbenchJob(this.getControl().getDisplay(), "Update LCD"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!AbstractLaunchConfigurationTab.this.getControl().isDisposed()) {
                    AbstractLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !AbstractLaunchConfigurationTab.this.getControl().isDisposed();
            }
        };
    }

    protected long getUpdateJobDelay() {
        return 200L;
    }

    public void setHelpContextId(String id) {
        this.fHelpContextId = id;
    }

    public String getHelpContextId() {
        return this.fHelpContextId;
    }

    protected Map<String, String> getAttributesLabelsForPrototype() {
        return this.fAttributesLabelsForPrototype;
    }
}

