/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListDialog;

public class RefactoringSaveHelper {
    private static final String RefactoringStarter_save_all_resources = Messages.RefactoringSaveHelper_SaveAllResourcesMsg;
    private static final String RefactoringStarter_must_save = Messages.RefactoringSaveHelper_MustSaveMsg;

    public static boolean checkDirtyEditors(Shell parentShell) {
        IEditorPart[] dirtyEditors = RefactoringSaveHelper.getDirtyEditors();
        if (dirtyEditors.length > 0) {
            if (RefactoringSaveHelper.askSaveAllDirtyEditors(parentShell, dirtyEditors)) {
                RefactoringSaveHelper.saveDirtyEditors(dirtyEditors);
                return true;
            }
            return false;
        }
        return true;
    }

    public static void saveDirtyEditors(final IEditorPart[] dirtyEditors) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart[] iEditorPartArray = dirtyEditors;
                int n = dirtyEditors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart part = iEditorPartArray[n2];
                    part.doSave((IProgressMonitor)new NullProgressMonitor());
                    ++n2;
                }
            }
        });
    }

    public static IEditorPart[] getDirtyEditors() {
        final ArrayList dirtyEditors = new ArrayList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] references;
                IWorkbenchWindow window = Q7UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart part = reference.getEditor(false);
                    if (part != null && part.isDirty()) {
                        dirtyEditors.add(part);
                    }
                    ++n2;
                }
            }
        });
        return dirtyEditors.toArray(new IEditorPart[dirtyEditors.size()]);
    }

    public static boolean askSaveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        ListDialog dialog = new ListDialog(shell){
            {
                this.setShellStyle(this.getShellStyle() | 0x10000);
            }
        };
        dialog.setTitle(RefactoringStarter_save_all_resources);
        dialog.setLabelProvider(RefactoringSaveHelper.createDialogLabelProvider());
        dialog.setMessage(RefactoringStarter_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        dialog.setHelpAvailable(false);
        return dialog.open() == 0;
    }

    private static ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

