/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;

public final class FQName {
    public final String ns;
    public final String name;

    public FQName(String ns, String name) {
        this.ns = ns;
        this.name = name;
    }

    public static FQName fromCommand(Command command) {
        EClass eClass = command.eClass();
        return new FQName(eClass.getEPackage().getNsURI(), eClass.getName());
    }

    public static FQName fromAttributes(String ns, String name) throws CoreException {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ns);
        if (ePackage == null) {
            throw new CoreException(CorePlugin.err(String.format("Unknown package %s", ns)));
        }
        if (ePackage.getEClassifier(name) == null) {
            throw new CoreException(CorePlugin.err(String.format("Unknown class %s in package %s", name, ns)));
        }
        return new FQName(ns, name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ns == null ? 0 : this.ns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FQName other = (FQName)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.ns == null ? other.ns != null : !this.ns.equals(other.ns));
    }

    public String toString() {
        if (this.ns == null || this.ns.length() == 0) {
            return this.name;
        }
        return String.valueOf(this.ns) + "::" + this.name;
    }
}

