/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.search.XmlReferenceDescriptorWriter;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceLookupVisitor
extends UseScanVisitor {
    private final IApiBaseline baseline;
    private IComponentDescriptor targetComponent;
    private IComponentDescriptor referencingComponent;
    private IApiComponent currComponent;
    private boolean skipped = false;
    private IMemberDescriptor targetMember;
    private IReferenceTypeDescriptor targetType;
    private IApiType currType;
    private final List<IComponentDescriptor> missingComponents = new ArrayList<IComponentDescriptor>();
    private final List<IComponentDescriptor> skippedComponents = new ArrayList<IComponentDescriptor>();
    private final String location;
    private List<IReferenceDescriptor> unresolved = null;
    private String analysisScope = null;
    private String targetScope = null;
    private FilteredElements excludedElements = null;
    private FilteredElements includedElements = null;

    public ReferenceLookupVisitor(IApiBaseline base, String xmlLocation) {
        this.baseline = base;
        this.location = xmlLocation;
    }

    @Override
    public boolean visitComponent(IComponentDescriptor target) {
        this.unresolved = new ArrayList<IReferenceDescriptor>();
        this.targetComponent = target;
        this.skipped = false;
        String id = this.targetComponent.getId();
        if (!(this.includedElements == null || this.includedElements.isEmpty() || this.includedElements.containsExactMatch(id) || this.includedElements.containsPartialMatch(id))) {
            this.skipped = true;
            return false;
        }
        if (this.excludedElements != null && (this.excludedElements.containsExactMatch(id) || this.excludedElements.containsPartialMatch(id))) {
            this.skipped = true;
            return false;
        }
        if (this.targetScope == null || id.matches(this.targetScope)) {
            this.currComponent = this.baseline.getApiComponent(id);
            return true;
        }
        this.skipped = true;
        return false;
    }

    @Override
    public boolean visitReferencingComponent(IComponentDescriptor component) {
        this.referencingComponent = component;
        if (this.currComponent == null) {
            return false;
        }
        return this.analysisScope == null || component.getId().matches(this.analysisScope);
    }

    @Override
    public boolean visitMember(IMemberDescriptor referencedMember) {
        this.targetMember = referencedMember;
        this.targetType = switch (this.targetMember.getElementType()) {
            case 2 -> (IReferenceTypeDescriptor)this.targetMember;
            case 5, 6 -> this.targetMember.getEnclosingType();
            default -> null;
        };
        this.currType = null;
        try {
            IApiComponent[] comps;
            IApiTypeRoot typeRoot = null;
            IApiComponent[] iApiComponentArray = comps = this.currComponent.getBaseline().resolvePackage(this.currComponent, this.targetType.getPackage().getName());
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                IApiComponent comp = iApiComponentArray[n2];
                typeRoot = comp.findTypeRoot(this.targetType.getQualifiedName());
                if (typeRoot != null) break;
                ++n2;
            }
            if (typeRoot != null) {
                this.currType = typeRoot.getStructure();
            }
            return true;
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
            return false;
        }
    }

    @Override
    public void visitReference(IReferenceDescriptor reference) {
        Reference ref = null;
        IApiMember resolved = null;
        int refKind = reference.getReferenceKind();
        int lineNumber = reference.getLineNumber();
        IMemberDescriptor origin = reference.getMember();
        if (this.currType != null) {
            switch (this.targetMember.getElementType()) {
                case 2: {
                    Reference reference2 = Reference.typeReference(this.currType, this.targetType.getQualifiedName(), refKind);
                    break;
                }
                case 6: {
                    Reference reference2 = Reference.methodReference(this.currType, this.targetType.getQualifiedName(), this.targetMember.getName(), ((IMethodDescriptor)this.targetMember).getSignature(), refKind);
                    break;
                }
                case 5: {
                    Reference reference2 = Reference.fieldReference(this.currType, this.targetType.getQualifiedName(), this.targetMember.getName(), refKind);
                    break;
                }
                default: {
                    Reference reference2 = ref = null;
                }
            }
        }
        if (ref != null) {
            try {
                ref.resolve();
                resolved = ref.getResolvedReference();
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
        }
        if (resolved == null) {
            this.addError(Factory.referenceDescriptor(this.referencingComponent, origin, lineNumber, this.targetComponent, this.targetMember, refKind, reference.getReferenceFlags(), reference.getVisibility(), null));
        }
    }

    private void addError(IReferenceDescriptor error) {
        this.unresolved.add(error);
    }

    @Override
    public void endVisitComponent(IComponentDescriptor target) {
        if (this.skipped) {
            this.skippedComponents.add(target);
        } else if (this.currComponent == null) {
            this.missingComponents.add(target);
        } else if (!this.unresolved.isEmpty()) {
            XmlReferenceDescriptorWriter writer = new XmlReferenceDescriptorWriter(this.location);
            writer.setAlternate((IComponentDescriptor)this.currComponent.getHandle());
            writer.writeReferences(this.unresolved.toArray(new IReferenceDescriptor[this.unresolved.size()]));
        }
    }

    @Override
    public void endVisitScan() {
        File rootfile = new File(this.location);
        File file = new File(rootfile, "not_searched.xml");
        try {
            if (!rootfile.exists()) {
                rootfile.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            Document doc = Util.newDocument();
            Element root = doc.createElement("components");
            doc.appendChild(root);
            this.addMissingComponents(this.missingComponents, SearchMessages.ReferenceLookupVisitor_0, doc, root);
            this.addMissingComponents(this.skippedComponents, SearchMessages.SkippedComponent_component_was_excluded, doc, root);
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ApiPlugin.log("Failed to report missing bundles into " + String.valueOf(file), e);
        }
    }

    private void addMissingComponents(List<IComponentDescriptor> missing, String details, Document doc, Element root) {
        for (IComponentDescriptor component : missing) {
            Element comp = doc.createElement("component");
            comp.setAttribute("id", component.getId());
            comp.setAttribute("version", component.getVersion());
            comp.setAttribute("details", details);
            root.appendChild(comp);
        }
    }

    public void setAnalysisScope(String regex) {
        this.analysisScope = regex;
    }

    public void setTargetScope(String regex) {
        this.targetScope = regex;
    }

    public void setExcludedElements(FilteredElements excludedElements) {
        this.excludedElements = excludedElements;
    }

    public void setIncludedElements(FilteredElements includedElements) {
        this.includedElements = includedElements;
    }
}

