/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class StatusBarComposite {
    private String message;
    private Label messageLabel;
    private ProgressIndicator progressIndicator;
    private Composite parent;
    private Composite composite;
    private Shell shell;
    private static String DEFAULT_TASKNAME = "Operation in progress...";

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        this.parent = parent;
        this.composite = new Composite(parent, 0);
        this.messageLabel = new Label(this.composite, 0);
        this.progressIndicator = new ProgressIndicator(this.composite);
        this.composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (StatusBarComposite.this.messageLabel != null && StatusBarComposite.this.messageLabel.isVisible() && StatusBarComposite.this.message != null) {
                    StatusBarComposite.this.messageLabel.setText(Dialog.shortenText((String)StatusBarComposite.this.message, (Control)StatusBarComposite.this.messageLabel));
                }
            }
        });
        this.setMessageLayout();
        this.hide();
    }

    public Control getControl() {
        return this.composite;
    }

    public void showMessage(final String message) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (message != null) {
                    StatusBarComposite.this.setMessageLayout();
                    StatusBarComposite.this.show();
                    StatusBarComposite.this.layout();
                    StatusBarComposite.this.setMessage(message, true);
                } else {
                    StatusBarComposite.this.hide();
                    StatusBarComposite.this.layout();
                }
            }
        });
    }

    private void setMessage(String messageString, boolean force) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        if (force || this.messageLabel.isVisible()) {
            this.messageLabel.setToolTipText(this.message);
            this.messageLabel.setText(Dialog.shortenText((String)this.message, (Control)this.messageLabel));
            this.layout();
        }
    }

    private void update() {
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.update();
        this.layout();
    }

    public void runWithProgress(String name, IRunnableWithProgress runnable, boolean fork) {
        if (name == null || name.length() <= 0) {
            name = DEFAULT_TASKNAME;
        }
        final String message = name;
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                StatusBarComposite.this.setProgressBarLayout();
                StatusBarComposite.this.show();
                StatusBarComposite.this.layout();
                StatusBarComposite.this.setMessage(message, false);
            }
        });
        ProgressMonitor monitor = new ProgressMonitor();
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)monitor, (Display)this.shell.getDisplay());
        }
        catch (InvocationTargetException e) {
            this.handleError(message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void handleError(final String taskMessage, final Throwable e) {
        Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IStatus status = e instanceof CoreException ? ((CoreException)e).getStatus() : Q7UIPlugin.createStatus(e);
                ErrorDialog.openError((Shell)StatusBarComposite.this.shell, (String)Messages.StatusBarComposite_ErrorDialogTitle, (String)Messages.bind((String)Messages.StatusBarComposite_ErrorDialogMsg, (Object)taskMessage), (IStatus)status);
            }
        });
    }

    private void setMessageLayout() {
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.messageLabel);
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)this.progressIndicator);
    }

    private void setProgressBarLayout() {
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(true).margins(2, 2).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.messageLabel);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.progressIndicator);
    }

    private void show() {
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.composite);
    }

    private void hide() {
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)this.composite);
    }

    protected void layout() {
        this.composite.layout(true);
        this.parent.layout(true);
    }

    private void asyncExec(Runnable runnable) {
        if (Display.getDefault().getThread() != Thread.currentThread()) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private class ProgressMonitor
    implements IProgressMonitor {
        private volatile boolean canceled;
        protected boolean forked = false;

        private ProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            if (StatusBarComposite.this.progressIndicator.isDisposed()) {
                return;
            }
            if (name == null || name.length() <= 0) {
                name = DEFAULT_TASKNAME;
            }
            StatusBarComposite.this.setMessage(name, false);
            if (!this.forked) {
                StatusBarComposite.this.update();
            }
            if (totalWork == -1) {
                StatusBarComposite.this.progressIndicator.beginAnimatedTask();
            } else {
                StatusBarComposite.this.progressIndicator.beginTask(totalWork);
            }
        }

        public void done() {
            if (!StatusBarComposite.this.progressIndicator.isDisposed()) {
                StatusBarComposite.this.progressIndicator.sendRemainingWork();
                StatusBarComposite.this.progressIndicator.done();
            }
            if (StatusBarComposite.this.composite != null && !StatusBarComposite.this.composite.isDisposed()) {
                StatusBarComposite.this.hide();
                StatusBarComposite.this.layout();
            }
        }

        public void setTaskName(String name) {
            if (name == null || name.length() <= 0) {
                name = DEFAULT_TASKNAME;
            }
            StatusBarComposite.this.setMessage(name, false);
            if (!this.forked) {
                StatusBarComposite.this.update();
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean b) {
            this.canceled = b;
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void internalWorked(double work) {
            if (!StatusBarComposite.this.progressIndicator.isDisposed()) {
                StatusBarComposite.this.progressIndicator.worked(work);
            }
        }
    }
}

