/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rcptt.core.ecl.highlighter.EclHighlighter;
import org.eclipse.rcptt.ui.editors.ecl.ColorManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class EclStyledTextHighlighter {
    private static final Map<EclHighlighter.RunType, RGB> FOREGROUND_COLORS = new HashMap<EclHighlighter.RunType, RGB>();
    private static final RGB INVALID_UNDERLINE_COLOR;
    private static final ColorManager COLOR_MANAGER;

    static {
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Invalid, new RGB(0, 0, 0));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Spacing, new RGB(0, 0, 0));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Comment, new RGB(63, 127, 95));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Punctuation, new RGB(0, 0, 0));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Command, new RGB(127, 0, 85));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Option, new RGB(100, 100, 100));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Literal, new RGB(42, 0, 255));
        FOREGROUND_COLORS.put(EclHighlighter.RunType.Variable, new RGB(100, 100, 100));
        INVALID_UNDERLINE_COLOR = new RGB(255, 0, 0);
        COLOR_MANAGER = new ColorManager();
    }

    public void install(final StyledText styledText) {
        styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EclHighlighter highlighter = new EclHighlighter();
                highlighter.highlight(styledText.getText(), new EclHighlighter.Strategy(){

                    public void highlight(EclHighlighter.RunType type, int start, int end) {
                        StyleRange styleRange = EclStyledTextHighlighter.getStyleRange(type);
                        styleRange.start = start;
                        styleRange.length = end - start;
                        styleRange.fontStyle = EclStyledTextHighlighter.getFontStyle(type);
                        styledText.setStyleRange(styleRange);
                    }
                });
            }
        });
    }

    private static StyleRange getStyleRange(EclHighlighter.RunType type) {
        StyleRange styleRange = new StyleRange();
        styleRange.foreground = EclStyledTextHighlighter.getForegroundColor(type);
        switch (type) {
            case Invalid: {
                styleRange.underline = true;
                styleRange.underlineStyle = 2;
                styleRange.underlineColor = COLOR_MANAGER.getColor(INVALID_UNDERLINE_COLOR);
            }
        }
        return styleRange;
    }

    private static int getFontStyle(EclHighlighter.RunType run) {
        switch (run) {
            case Command: {
                return 1;
            }
        }
        return 0;
    }

    private static Color getForegroundColor(EclHighlighter.RunType type) {
        return COLOR_MANAGER.getColor(FOREGROUND_COLORS.get(type));
    }
}

