/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class ResourceApiTypeRoot
extends AbstractApiTypeRoot {
    private final IFile fFile;
    byte[] fContents = null;
    private long modifiedTimeStamp = -1L;

    public ResourceApiTypeRoot(IApiElement parent, IFile file, String typeName) {
        super(parent, typeName);
        this.fFile = file;
    }

    @Override
    public byte[] getContents() throws CoreException {
        if (this.fContents != null && this.fFile.getModificationStamp() == this.modifiedTimeStamp && this.modifiedTimeStamp != -1L) {
            return this.fContents;
        }
        this.modifiedTimeStamp = this.fFile.getModificationStamp();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = this.fFile.getContents(true);){
                this.fContents = stream.readAllBytes();
                return this.fContents;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            this.abort("Unable to read class file: " + this.getTypeName(), ioe);
            return null;
        }
    }

    @Override
    public String getTypeName() {
        return this.getName();
    }

    public String toString() {
        return this.getTypeName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiTypeRoot) {
            IApiTypeRoot file = (IApiTypeRoot)obj;
            return this.getName().equals(file.getTypeName());
        }
        return super.equals(obj);
    }
}

