/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.reporting;

import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingData;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportBuilderStore;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.EventProviderManager;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.Procedure1;

public class ReportBuilder
implements IReportBuilder {
    private static final String NODE_INDEX_PROPERTY = "rcptt.watson.node.index";
    private static final String NODE_LASTSTARTTIME_PROPERTY = "rcptt.watson.node.last-start-time";
    private final Report report;
    private NodeBuilder currentNode;

    private static Report createReport() {
        Report report = ReportFactory.eINSTANCE.createReport();
        Node root = ReportFactory.eINSTANCE.createNode();
        report.setRoot(root);
        root.setName("root");
        root.setStartTime(ReportBuilder.getTime());
        return report;
    }

    private ReportBuilder(Report report, Node currentNode) {
        this.report = report;
        this.currentNode = new NodeBuilder(null, currentNode);
        if (report.getRoot() == null) {
            throw new NullPointerException();
        }
        if (currentNode == null) {
            throw new NullPointerException();
        }
        Node root = currentNode;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (root != report.getRoot()) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventSource registerEventSource(String name) {
        EventSource source = ReportFactory.eINSTANCE.createEventSource();
        source.setName(name);
        Report report = this.report;
        synchronized (report) {
            this.report.getSources().add((Object)source);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReportCopy() {
        Report report = this.report;
        synchronized (report) {
            Report reportCopy = (Report)EcoreUtil.copy((EObject)this.report);
            Node root = reportCopy.getRoot();
            root.setEndTime(ReportBuilder.getTime());
            root.setDuration(root.getEndTime() - root.getStartTime());
            return reportCopy;
        }
    }

    @Override
    public INodeBuilder getCurrent() {
        return this.currentNode;
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public void registerProviders(String ... id) {
        if (id.length == 0) {
            EventProviderManager.getInstance().register(this, null);
        } else {
            String[] stringArray = id;
            int n = id.length;
            int n2 = 0;
            while (n2 < n) {
                String lid = stringArray[n2];
                EventProviderManager.getInstance().register(this, lid);
                ++n2;
            }
        }
    }

    public void unregisterProviders(String ... id) {
        if (id.length == 0) {
            EventProviderManager.getInstance().unregister(this, null);
        } else {
            String[] stringArray = id;
            int n = id.length;
            int n2 = 0;
            while (n2 < n) {
                String lid = stringArray[n2];
                EventProviderManager.getInstance().unregister(this, lid);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventSource findSource(String attr, EObject info) {
        Report report = this.report;
        synchronized (report) {
            EList<EventSource> sources = this.report.getSources();
            for (EventSource eventSource : sources) {
                EObject object = (EObject)eventSource.getProperties().get((Object)attr);
                if (object == null || !EcoreUtil.equals((EObject)object, (EObject)info)) continue;
                return eventSource;
            }
        }
        return null;
    }

    private static String getLogCategoryKey(LoggingCategory category) {
        return "log_" + category.name();
    }

    public static String getLogs(Node node) {
        StringBuilder result = new StringBuilder();
        String logs = null;
        for (LoggingCategory cat : LoggingCategory.VALUES) {
            logs = ReportBuilder.getLogs(node, cat);
            if (logs == null) continue;
            result.append(logs);
        }
        return result.toString();
    }

    public static String getLogs(Node node, LoggingCategory cat) {
        EObject object = (EObject)node.getProperties().get((Object)ReportBuilder.getLogCategoryKey(cat));
        if (object != null && object instanceof LoggingData) {
            return ((LoggingData)object).getText();
        }
        return null;
    }

    public static ReportBuilder create(String title) {
        Report report = ReportBuilder.createReport();
        report.getRoot().setName(title);
        return new ReportBuilder(report, report.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportBuilderStore save() {
        ReportBuilderStore store = ReportFactory.eINSTANCE.createReportBuilderStore();
        Report report = this.report;
        synchronized (report) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            store.setReport((Report)copier.copy((EObject)this.report));
            store.setCurrentNode((Node)copier.get((Object)this.currentNode.node));
        }
        assert (store.getCurrentNode() != null);
        assert (store.getCurrentNode().eContainer() != null);
        Node root = store.getReport().getRoot();
        root.setEndTime(ReportBuilder.getTime());
        root.setDuration(root.getEndTime() - root.getStartTime());
        return store;
    }

    public static ReportBuilder load(ReportBuilderStore store) {
        return new ReportBuilder(store.getReport(), store.getCurrentNode());
    }

    public static Snaphot createSnapshot(EObject data, Map<String, EObject> properties) {
        Snaphot snapshot = ReportFactory.eINSTANCE.createSnaphot();
        snapshot.setTime(ReportBuilder.getTime());
        snapshot.setData(Objects.requireNonNull(data));
        if (properties != null) {
            snapshot.getProperties().addAll(properties.entrySet());
        }
        return snapshot;
    }

    private static int getNodeIndex(Node node) {
        Object index = BoxedValues.unbox((Object)node.getProperties().get((Object)NODE_INDEX_PROPERTY));
        assert (index != null);
        assert (index instanceof Integer);
        return (Integer)index;
    }

    private static void setNodeIndex(Node node, int index) {
        node.getProperties().put((Object)NODE_INDEX_PROPERTY, (Object)BoxedValues.box((int)index));
    }

    private static long getNodeLastStartTime(Node node) {
        Object index = BoxedValues.unbox((Object)node.getProperties().get((Object)NODE_LASTSTARTTIME_PROPERTY));
        assert (index != null);
        assert (index instanceof Long);
        return (Long)index;
    }

    private static void setNodeLastStartTime(Node node, long startTime) {
        node.getProperties().put((Object)NODE_LASTSTARTTIME_PROPERTY, (Object)BoxedValues.box((long)startTime));
    }

    private class NodeBuilder
    implements INodeBuilder {
        private final Node node;
        private NodeBuilder parent;
        private int currentChildIndex = 0;

        private NodeBuilder(NodeBuilder parent, Node node) {
            EObject container;
            if (parent == null && (container = node.eContainer()) instanceof Node) {
                parent = new NodeBuilder(null, (Node)container);
            }
            this.parent = parent;
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public INodeBuilder beginTask(String name) {
            NodeBuilder childNode = this.findChildNode(name);
            if (childNode != null) {
                return childNode;
            }
            Node child = ReportFactory.eINSTANCE.createNode();
            child.setName(name);
            child.setStartTime(ReportBuilder.getTime());
            ReportBuilder.setNodeIndex(child, this.currentChildIndex);
            ReportBuilder.setNodeLastStartTime(child, child.getStartTime());
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.getChildren().add(this.getChildPosition(name), (Object)child);
                ReportBuilder.this.currentNode = new NodeBuilder(this, child);
            }
            ++this.currentChildIndex;
            return ReportBuilder.this.currentNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeBuilder findChildNode(String name) {
            for (Node child : this.node.getChildren()) {
                if (!name.equals(child.getName()) || this.currentChildIndex != ReportBuilder.getNodeIndex(child)) continue;
                ReportBuilder.setNodeLastStartTime(child, ReportBuilder.getTime());
                Report report = ReportBuilder.this.report;
                synchronized (report) {
                    ReportBuilder.this.currentNode = new NodeBuilder(this, child);
                }
                ++this.currentChildIndex;
                return ReportBuilder.this.currentNode;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public INodeBuilder appendTask(String name) {
            for (Node child : this.node.getChildren()) {
                if (!name.equals(child.getName())) continue;
                ReportBuilder.setNodeLastStartTime(child, ReportBuilder.getTime());
                Report report = ReportBuilder.this.report;
                synchronized (report) {
                    ReportBuilder.this.currentNode = new NodeBuilder(this, child);
                }
                return ReportBuilder.this.currentNode;
            }
            return this.beginTask(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endTask() {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.setEndTime(ReportBuilder.getTime());
                long duration = this.node.getEndTime() - ReportBuilder.getNodeLastStartTime(this.node);
                this.node.setDuration(this.node.getDuration() + duration);
                if (this.parent == null) {
                    throw new IllegalStateException("Root report node can't be closed.");
                }
                ReportBuilder.this.currentNode = this.parent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createEvent(Event event) {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                Event childEvent = this.findChildEvent(event);
                if (childEvent != null) {
                    childEvent.setCount(childEvent.getCount() + 1);
                    return;
                }
                Event copy = (Event)EcoreUtil.copy((EObject)event);
                copy.setTime(ReportBuilder.getTime());
                this.node.getEvents().add((Object)copy);
            }
        }

        private Event findChildEvent(Event event) {
            for (Event childEvent : this.node.getEvents()) {
                if (!EcoreUtil.equals((EObject)event.getData(), (EObject)childEvent.getData())) continue;
                return childEvent;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendLog(LoggingCategory category, String text) {
            String log_key = ReportBuilder.getLogCategoryKey(category);
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                EMap<String, EObject> properties = this.node.getProperties();
                LoggingData data = (LoggingData)properties.get((Object)log_key);
                if (data == null) {
                    data = ReportFactory.eINSTANCE.createLoggingData();
                    properties.put((Object)log_key, (Object)data);
                }
                StringBuilder sb = new StringBuilder(data.getText());
                sb.append(text);
                sb.append("\n");
                data.setText(sb.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProperty(String key, EObject value) {
            EObject copy = EcoreUtil.copy((EObject)value);
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.getProperties().put((Object)key, (Object)copy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EObject getProperty(String key) {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                return (EObject)this.node.getProperties().get((Object)key);
            }
        }

        @Override
        public NodeBuilder getParent() {
            return this.parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSnapshot(Snaphot snapshot) {
            Snaphot copy = (Snaphot)EcoreUtil.copy((EObject)snapshot);
            copy.setTime(ReportBuilder.getTime());
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.getSnapshots().add((Object)copy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Procedure1<Node> runnable) {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                runnable.apply(this.node);
            }
        }

        @Override
        public String getName() {
            return this.node.getName();
        }

        public String toString() {
            return this.node.getName();
        }

        private int getChildPosition(String name) {
            int position = -1;
            int size = this.node.getChildren().size();
            int i = 0;
            while (i < size) {
                Node child = (Node)this.node.getChildren().get(i);
                if (this.currentChildIndex == ReportBuilder.getNodeIndex(child)) {
                    position = i;
                }
                ++i;
            }
            return position == -1 ? size : position + 1;
        }
    }
}

