/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class RemoteTargetHandle
implements ITargetHandle {
    private static final String FILE_SCHEMA = "file:";
    private static final Map<URI, RemoteTargetHandle> REMOTE_HANDLES = new ConcurrentHashMap<URI, RemoteTargetHandle>();
    static final String SCHEME = "remote";
    private final URI uri;
    private RemoteState state;

    private RemoteTargetHandle(URI uri) {
        this.uri = uri;
    }

    @Override
    public String getMemento() throws CoreException {
        return "remote:" + this.uri.toASCIIString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        RemoteTargetHandle remoteTargetHandle = this;
        synchronized (remoteTargetHandle) {
            block11: {
                if (this.state == RemoteState.UNKNWON) {
                    try {
                        if ("file".equalsIgnoreCase(this.uri.getScheme())) {
                            File file = new File(this.uri);
                            this.state = file.isFile() ? RemoteState.EXISTS : RemoteState.NOT_FOUND;
                            break block11;
                        }
                        URLConnection connection = this.uri.toURL().openConnection();
                        if (connection instanceof HttpURLConnection) {
                            HttpURLConnection http = (HttpURLConnection)connection;
                            try {
                                http.setInstanceFollowRedirects(true);
                                http.setRequestMethod("HEAD");
                                int code = http.getResponseCode() / 100;
                                this.state = code == 2 ? RemoteState.EXISTS : RemoteState.NOT_FOUND;
                                break block11;
                            }
                            finally {
                                http.disconnect();
                            }
                        }
                        connection.getInputStream().close();
                        this.state = RemoteState.EXISTS;
                    }
                    catch (IOException iOException) {
                        this.state = RemoteState.FAILED;
                    }
                }
            }
            return this.state == RemoteState.EXISTS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITargetDefinition getTargetDefinition() throws CoreException {
        TargetDefinition definition = new TargetDefinition(this);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream stream = this.uri.toURL().openStream();){
                RemoteTargetHandle remoteTargetHandle = this;
                synchronized (remoteTargetHandle) {
                    this.state = RemoteState.EXISTS;
                }
                definition.setContents(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MalformedURLException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.RemoteTargetHandle_malformed_URL, (Object)this.uri, (Object)e.getMessage()), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.RemoteTargetHandle_ioproblem, (Object)this.uri, (Object)e.getMessage()), (Throwable)e));
        }
        return definition;
    }

    public static URI getEffectiveUri(String uri) throws CoreException, URISyntaxException {
        Objects.requireNonNull(uri);
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        URI resolvedUri = new URI(RemoteTargetHandle.convertRawToUri(manager.performStringSubstitution(uri)));
        return resolvedUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteTargetHandle get(String uri) throws CoreException {
        Objects.requireNonNull(uri);
        try {
            RemoteTargetHandle handle;
            URI resolvedUri = RemoteTargetHandle.getEffectiveUri(uri);
            RemoteTargetHandle remoteTargetHandle = handle = REMOTE_HANDLES.computeIfAbsent(resolvedUri, RemoteTargetHandle::new);
            synchronized (remoteTargetHandle) {
                if (handle.state != RemoteState.EXISTS) {
                    handle.state = RemoteState.UNKNWON;
                }
            }
            return handle;
        }
        catch (URISyntaxException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.RemoteTargetHandle_invalid_URI, (Object)e.getMessage()), (Throwable)e));
        }
    }

    static String convertRawToUri(String resolvePath) {
        String lc = (resolvePath = resolvePath.replace('\\', '/')).toLowerCase();
        if (lc.startsWith(FILE_SCHEMA) && lc.charAt(FILE_SCHEMA.length()) != '/') {
            resolvePath = "file:/" + resolvePath.substring(FILE_SCHEMA.length());
        }
        return resolvePath;
    }

    private static enum RemoteState {
        UNKNWON,
        EXISTS,
        NOT_FOUND,
        FAILED;

    }
}

