/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.ExecutableDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.core.dom.IMethodBinding;

public class ConstructorDeclarationImpl
extends ExecutableDeclarationImpl
implements ConstructorDeclaration {
    public ConstructorDeclarationImpl(IMethodBinding binding, BaseProcessorEnv env) {
        super(binding, env);
        assert (binding.isConstructor()) : "binding does not represent a constructor";
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitConstructorDeclaration(this);
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.CONSTRUCTOR;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        IMethodBinding methodBinding = this.getDeclarationBinding();
        buffer.append(methodBinding.getName());
        buffer.append('(');
        int i = 0;
        for (ParameterDeclaration param : this.getParameters()) {
            if (i++ != 0) {
                buffer.append(", ");
            }
            buffer.append(param);
        }
        buffer.append(')');
        return buffer.toString();
    }
}

