/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Files;
import org.apache.tools.ant.types.resources.Union;

public class CompileErrorTask
extends Task {
    private static final Object LOCK = new Object();
    private static final String NEW_LINE = System.lineSeparator();
    private static final String ANT_PREFIX = "${";
    private final Files problemFiles = new Files();
    private String logFile = null;
    private String bundle = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.logFile == null || this.logFile.startsWith(ANT_PREFIX) || this.problemFiles.size() == 0) {
            return;
        }
        Union union = new Union((ResourceCollection)this.problemFiles);
        String[] prereqFiles = union.list();
        ArrayList<String> problems = new ArrayList<String>();
        String[] stringArray = prereqFiles;
        int n = prereqFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String prereqFile = stringArray[n2];
            File file = new File(prereqFile);
            try {
                Throwable throwable = null;
                Iterator iterator = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line = reader.readLine();
                    if (line != null) {
                        problems.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ++n2;
        }
        if (problems.size() > 0) {
            File log = new File(this.logFile);
            if (!log.getParentFile().exists()) {
                log.getParentFile().mkdirs();
            }
            Object object = LOCK;
            synchronized (object) {
                try {
                    Throwable throwable = null;
                    stringArray = null;
                    try (FileWriter writer = new FileWriter(log, true);){
                        writer.write(String.valueOf(this.bundle) + ": the following prerequisites contain compile errors" + NEW_LINE);
                        for (String problem : problems) {
                            writer.write("\t");
                            writer.write(problem);
                            writer.write(NEW_LINE);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setLog(String logFile) {
        this.logFile = logFile;
    }

    public PatternSet.NameEntry createInclude() {
        return this.problemFiles.createInclude();
    }
}

