/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclTextNavigationAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public class LineEndAction
extends EclTextNavigationAction {
    protected boolean fDoSelect;

    public LineEndAction(EclEditor editor, StyledText textWidget, boolean doSelect) {
        super(editor, textWidget, 0x1000008);
        this.fDoSelect = doSelect;
    }

    protected int getLineEndPosition(IDocument document, String line, int length, int offset) {
        LinkedPosition linkedPosition;
        int index = length - 1;
        while (index > -1 && Character.isWhitespace(line.charAt(index))) {
            --index;
        }
        ++index;
        LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)offset);
        if (model != null && (linkedPosition = model.findPosition(new LinkedPosition(document, offset, 0))) != null) {
            int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
            try {
                int lineOffset = document.getLineInformationOfOffset(offset).getOffset();
                if (offset != linkedPositionEnd && linkedPositionEnd - lineOffset < index) {
                    index = linkedPositionEnd - lineOffset;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return index;
    }

    @Override
    public void internalRun(TextViewer viewer) {
        int lineLength;
        int caretOffsetInDocument;
        StyledText st;
        boolean isSmartHomeEndEnabled = false;
        IPreferenceStore store = this.eclEditor.doGetPreferenceStore();
        if (store != null) {
            isSmartHomeEndEnabled = store.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        }
        if ((st = viewer.getTextWidget()) == null || st.isDisposed()) {
            return;
        }
        int caretOffset = st.getCaretOffset();
        int lineNumber = st.getLineAtOffset(caretOffset);
        int lineOffset = st.getOffsetAtLine(lineNumber);
        IDocument document = viewer.getDocument();
        try {
            caretOffsetInDocument = this.eclEditor.doWidgetOffset2ModelOffset(viewer, caretOffset);
            lineLength = document.getLineInformationOfOffset(caretOffsetInDocument).getLength();
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int lineEndOffset = lineOffset + lineLength;
        int delta = lineEndOffset - st.getCharCount();
        if (delta > 0) {
            lineEndOffset -= delta;
            lineLength -= delta;
        }
        String line = "";
        if (lineLength > 0) {
            line = st.getText(lineOffset, lineEndOffset - 1);
        }
        Point oldSelection = st.getSelection();
        int newCaretOffset = -1;
        if (isSmartHomeEndEnabled) {
            int i = this.getLineEndPosition(document, line, lineLength, caretOffsetInDocument);
            newCaretOffset = caretOffset - lineOffset == i ? lineEndOffset : lineOffset + i;
        } else if (caretOffset < lineEndOffset) {
            newCaretOffset = lineEndOffset;
        }
        if (newCaretOffset == -1) {
            newCaretOffset = caretOffset;
        } else {
            st.setCaretOffset(newCaretOffset);
        }
        st.setCaretOffset(newCaretOffset);
        if (this.fDoSelect) {
            if (caretOffset < oldSelection.y) {
                st.setSelection(oldSelection.y, newCaretOffset);
            } else {
                st.setSelection(oldSelection.x, newCaretOffset);
            }
        } else {
            st.setSelection(newCaretOffset);
        }
        this.fireSelectionChanged(oldSelection);
    }
}

