/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormOutlinePage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaInputContext;
import org.eclipse.pde.internal.ui.editor.schema.SchemaInputContextManager;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOverviewPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSourcePage;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SchemaEditor
extends MultiSourceEditor {
    private ShowDescriptionAction fPreviewAction;

    @Override
    protected String getEditorID() {
        return "org.eclipse.pde.ui.schemaEditor";
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public String getContextIDForSaveAs() {
        return "schema-context";
    }

    @Override
    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        FileEditorInput in = new FileEditorInput(file);
        manager.putContext((IEditorInput)in, new SchemaInputContext(this, (IEditorInput)in, true));
        manager.monitorFile(file);
    }

    @Override
    protected InputContextManager createInputContextManager() {
        SchemaInputContextManager contextManager = new SchemaInputContextManager(this);
        return contextManager;
    }

    @Override
    public void monitoredFileAdded(IFile file) {
    }

    @Override
    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    @Override
    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    @Override
    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    @Override
    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        manager.putContext((IEditorInput)input, new SchemaInputContext(this, (IEditorInput)input, true));
    }

    @Override
    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new SchemaInputContext(this, (IEditorInput)input, true));
    }

    void previewReferenceDocument() {
        ISchema schema = (ISchema)this.getAggregateModel();
        if (this.fPreviewAction == null) {
            this.fPreviewAction = new ShowDescriptionAction(schema);
        } else {
            this.fPreviewAction.setSchema(schema);
        }
        this.fPreviewAction.run();
    }

    @Override
    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new SchemaOverviewPage(this));
            this.addPage((IFormPage)new SchemaFormPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("schema-context");
    }

    @Override
    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            firstPageId = "overview";
        }
        return firstPageId;
    }

    @Override
    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SchemaSourcePage(editor, title, name);
    }

    @Override
    protected ISortableContentOutlinePage createContentOutline() {
        return new SchemaFormOutlinePage(this);
    }

    @Override
    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof ISchemaObject) {
            context = this.fInputContextManager.findContext("schema-context");
        }
        return context;
    }

    public static boolean openSchema(IFile file) {
        if (file != null && file.exists()) {
            FileEditorInput input = new FileEditorInput(file);
            try {
                return PDEPlugin.getActivePage().openEditor((IEditorInput)input, "org.eclipse.pde.ui.schemaEditor") != null;
            }
            catch (PartInitException partInitException) {}
        }
        return false;
    }

    public static boolean openSchema(IPath path) {
        String pluginId = path.segment(0);
        IPluginModelBase model = PluginRegistry.findModel((String)pluginId);
        if (model != null && model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            IFile file = project.getFile(path.removeFirstSegments(1));
            return SchemaEditor.openSchema(file);
        }
        return false;
    }

    public static boolean openSchema(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        FileStoreEditorInput input = null;
        try {
            IFileStore store = EFS.getStore((URI)file.toURI());
            input = new FileStoreEditorInput(store);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return SchemaEditor.openEditor(input);
    }

    private static boolean openEditor(IEditorInput input) {
        IEditorPart part = null;
        try {
            part = PDEPlugin.getActivePage().openEditor(input, "org.eclipse.pde.ui.schemaEditor");
        }
        catch (PartInitException e) {
            PDEPlugin.log(e);
            return false;
        }
        return part != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean openSchema(File jarFile, String schemaJarFileEntry) {
        if (jarFile == null) return false;
        if (!jarFile.exists()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(jarFile);){
                if (schemaJarFileEntry == null) return false;
                if (zipFile.getEntry(schemaJarFileEntry) == null) {
                    return false;
                }
                JarEntryFile storage = new JarEntryFile(zipFile, schemaJarFileEntry);
                JarEntryEditorInput input = new JarEntryEditorInput(storage);
                return SchemaEditor.openEditor((IEditorInput)input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            PDEPlugin.log(e);
            return false;
        }
    }

    public static void openToElement(IPath path, ISchemaElement element) {
        if (SchemaEditor.openSchema(path)) {
            IEditorPart editorPart = PDEPlugin.getActivePage().getActiveEditor();
            if (!(editorPart instanceof SchemaEditor)) {
                return;
            }
            SchemaEditor schemaEditor = (SchemaEditor)editorPart;
            schemaEditor.selectReveal(element);
        }
    }

    @Override
    public boolean canCut(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof ISchemaRootElement) {
                return false;
            }
            if (selected instanceof ISchemaAttribute && ((ISchemaAttribute)selected).getParent() instanceof ISchemaRootElement) {
                return false;
            }
        }
        return super.canCut(selection);
    }
}

