/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.category.IUDetailsSection;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Version;

public class FeatureDetailsSection
extends IUDetailsSection<ISiteFeature> {
    private FormEntry fUrlText;
    private Button fIncludeUrlCheckbox;
    private SelectionListener fRecomputeAdapter;

    public FeatureDetailsSection(PDEFormPage page, Composite parent) {
        super(page, parent, PDEUIMessages.FeatureDetails_title, PDEUIMessages.FeatureDetails_sectionDescription, FeatureDetailsSection::extractFromSelection);
    }

    private static ISiteFeature extractFromSelection(Object o) {
        if (o instanceof ISiteFeature) {
            return (ISiteFeature)o;
        }
        if (o instanceof SiteFeatureAdapter) {
            return ((SiteFeatureAdapter)o).feature;
        }
        return null;
    }

    @Override
    protected void clearFields() {
        super.clearFields();
        this.fUrlText.setValue(null, true);
        this.fIncludeUrlCheckbox.setSelection(false);
    }

    @Override
    protected void onCreateClient(Composite container, FormToolkit toolkit) {
        this.fUrlText = new FormEntry(container, toolkit, PDEUIMessages.FeatureDetails_url, null, false);
        this.limitTextWidth(this.fUrlText);
        this.fUrlText.setEditable(false);
        toolkit.createLabel(container, "");
        this.fIncludeUrlCheckbox = toolkit.createButton(container, PDEUIMessages.FeatureDetails_include_url, 32);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 3;
        this.fIncludeUrlCheckbox.setLayoutData((Object)gd);
        this.fRecomputeAdapter = SelectionListener.widgetSelectedAdapter(e -> {
            try {
                this.applyUrl(this.fIncludeUrlCheckbox.getSelection());
            }
            catch (CoreException ex) {
                PDEPlugin.logException(ex);
            }
        });
        this.fIncludeUrlCheckbox.addSelectionListener(this.fRecomputeAdapter);
        this.fIncludeUrlCheckbox.setEnabled(this.isEditable());
    }

    @Override
    protected void applyId(String value) throws CoreException {
        super.applyId(value);
        this.onUrlDependencyChanged(value);
    }

    @Override
    protected void applyVersion(String value) throws CoreException {
        super.applyVersion(value);
        this.onUrlDependencyChanged(value);
    }

    private void onUrlDependencyChanged(String dependencyValue) throws CoreException {
        boolean includeUrl = dependencyValue != null && this.fIncludeUrlCheckbox.getSelection();
        this.applyUrl(includeUrl);
        this.updateUrlEnablement();
    }

    private void applyUrl(boolean include) throws CoreException {
        ISiteFeature feature = (ISiteFeature)this.getCurrentItem();
        if (feature != null) {
            String value = include ? this.recomputeUrl() : null;
            feature.setURL(value);
        }
    }

    private String recomputeUrl() {
        ISiteFeature feature = (ISiteFeature)this.getCurrentItem();
        if (feature == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("features/").append(feature.getId()).append("_");
        try {
            sb.append(new Version(feature.getVersion()));
        }
        catch (Exception exception) {
            sb.append("0.0.0");
        }
        sb.append(".jar");
        return sb.toString();
    }

    private void updateUrlEnablement() {
        ISiteFeature feature = (ISiteFeature)this.getCurrentItem();
        boolean hasVersionAndId = feature != null && feature.getId() != null && feature.getVersion() != null;
        this.fIncludeUrlCheckbox.setEnabled(this.isEditable() && hasVersionAndId);
    }

    @Override
    protected void fillControls(ISiteFeature currentItem) {
        super.fillControls(currentItem);
        this.fIncludeUrlCheckbox.removeSelectionListener(this.fRecomputeAdapter);
        String url = currentItem.getURL();
        this.fIncludeUrlCheckbox.setSelection(url != null);
        this.fUrlText.setValue(url, true);
        this.fIncludeUrlCheckbox.addSelectionListener(this.fRecomputeAdapter);
        this.updateUrlEnablement();
    }
}

