/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class DiffRegionFormatter
extends DiffFormatter {
    private DocumentOutputStream stream;
    private List<DiffRegion> regions = new ArrayList<DiffRegion>();
    private List<FileDiffRegion> fileRegions = new ArrayList<FileDiffRegion>();
    private final int maxLines;
    private int linesWritten;
    private int lastNewLine;
    private int[] maximumLineNumbers = new int[]{-1, -1};

    public DiffRegionFormatter(IDocument document, int offset) {
        this(document, offset, -1);
    }

    public DiffRegionFormatter(IDocument document) {
        this(document, document.getLength(), -1);
    }

    public DiffRegionFormatter(IDocument document, int offset, int maxLines) {
        super((OutputStream)new DocumentOutputStream(document, offset));
        this.stream = (DocumentOutputStream)this.getOutputStream();
        this.maxLines = maxLines;
        this.lastNewLine = -1;
    }

    public DiffRegionFormatter write(FileDiff diff) throws IOException {
        Repository repository = diff.getRepository();
        this.stream.charset = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)diff.getPath());
        int start = this.stream.offset;
        diff.outputDiff(null, repository, this, true);
        this.flush();
        this.fileRegions.add(new FileDiffRegion(diff, start, this.stream.offset - start));
        return this;
    }

    public DiffRegion[] getRegions() {
        return this.regions.toArray(new DiffRegion[0]);
    }

    public FileDiffRegion[] getFileRegions() {
        return this.fileRegions.toArray(new FileDiffRegion[0]);
    }

    public int[] getMaximumLineNumbers() {
        return (int[])this.maximumLineNumbers.clone();
    }

    protected DiffRegion addRegion(@NonNull DiffRegion.Type type, int start, int end) {
        return this.addRegion(type, start, end, -1, -1);
    }

    protected DiffRegion addRegion(@NonNull DiffRegion.Type type, int start, int end, int aLine, int bLine) {
        DiffRegion last;
        this.maximumLineNumbers[0] = Math.max(aLine, this.maximumLineNumbers[0]);
        this.maximumLineNumbers[1] = Math.max(bLine, this.maximumLineNumbers[1]);
        if (bLine != -1) {
            this.lastNewLine = bLine;
        }
        if (!this.regions.isEmpty() && (last = this.regions.get(this.regions.size() - 1)).getType().equals((Object)type) && start == last.getOffset() + last.getLength()) {
            this.regions.remove(this.regions.size() - 1);
            start = last.getOffset();
            aLine = last.getLine(DiffEntry.Side.OLD);
            bLine = last.getLine(DiffEntry.Side.NEW);
        }
        DiffRegion range = new DiffRegion(start, end - start, aLine, bLine, type);
        this.regions.add(range);
        return range;
    }

    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        int start = this.stream.offset;
        if (!this.regions.isEmpty()) {
            DiffRegion last = this.regions.get(this.regions.size() - 1);
            int lastEnd = last.getOffset() + last.getLength();
            if (last.getType().equals((Object)DiffRegion.Type.HEADLINE) && lastEnd < start) {
                this.addRegion(DiffRegion.Type.HEADER, lastEnd, start);
            }
        }
        super.writeHunkHeader(aStartLine, aEndLine, bStartLine, bEndLine);
        this.stream.flushLine();
        this.addRegion(DiffRegion.Type.HUNK, start, this.stream.offset);
        this.lastNewLine = bStartLine - 1;
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        if (this.maxLines > 0 && this.linesWritten > this.maxLines) {
            if (this.linesWritten == this.maxLines + 1) {
                int start = this.stream.offset;
                this.stream.flushLine();
                this.stream.write(NLS.bind((String)UIText.DiffStyleRangeFormatter_diffTruncated, (Object)this.maxLines));
                this.stream.write("\n");
                this.addRegion(DiffRegion.Type.HEADLINE, start, this.stream.offset);
                ++this.linesWritten;
            }
            return;
        }
        int start = this.stream.offset;
        super.writeLine(prefix, text, cur);
        this.stream.flushLine();
        if (prefix == ' ') {
            this.addRegion(DiffRegion.Type.CONTEXT, start, this.stream.offset, cur, ++this.lastNewLine);
        } else if (prefix == '+') {
            this.addRegion(DiffRegion.Type.ADD, start, this.stream.offset, -1, cur);
        } else {
            this.addRegion(DiffRegion.Type.REMOVE, start, this.stream.offset, cur, -1);
        }
        ++this.linesWritten;
    }

    protected void formatGitDiffFirstHeaderLine(ByteArrayOutputStream o, DiffEntry.ChangeType type, String oldPath, String newPath) throws IOException {
        this.stream.flushLine();
        int offset = this.stream.offset;
        int start = o.size();
        super.formatGitDiffFirstHeaderLine(o, type, oldPath, newPath);
        int end = o.size();
        this.addRegion(DiffRegion.Type.HEADLINE, offset + start, offset + end);
    }

    public void format(EditList edits, RawText a, RawText b) throws IOException {
        this.stream.flushLine();
        super.format(edits, a, b);
    }

    public static class DiffRegion
    extends Region {
        public static final int NO_LINE = -1;
        @NonNull
        private final Type type;
        private final int aLine;
        private final int bLine;

        public DiffRegion(int offset, int length) {
            this(offset, length, -1, -1, Type.OTHER);
        }

        public DiffRegion(int offset, int length, int aLine, int bLine, @NonNull Type type) {
            super(offset, length);
            this.type = type;
            this.aLine = aLine;
            this.bLine = bLine;
        }

        @NonNull
        public Type getType() {
            return this.type;
        }

        public int getLine(@NonNull DiffEntry.Side side) {
            if (DiffEntry.Side.NEW.equals((Object)side)) {
                return this.bLine;
            }
            return this.aLine;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public static enum Type {
            ADD,
            REMOVE,
            HUNK,
            HEADLINE,
            HEADER,
            CONTEXT,
            OTHER;

        }
    }

    private static class DocumentOutputStream
    extends OutputStream {
        private String charset;
        private IDocument document;
        private int offset;
        private StringBuilder lineBuffer = new StringBuilder();

        public DocumentOutputStream(IDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        private void write(String content) throws IOException {
            try {
                this.document.replace(this.offset, 0, content);
                this.offset += content.length();
            }
            catch (BadLocationException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.charset == null) {
                this.lineBuffer.append(new String(b, off, len, "UTF-8"));
            } else {
                this.lineBuffer.append(new String(b, off, len, this.charset));
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void flush() throws IOException {
            this.flushLine();
        }

        protected void flushLine() throws IOException {
            if (this.lineBuffer.length() > 0) {
                this.write(this.lineBuffer.toString());
                this.lineBuffer.setLength(0);
            }
        }
    }

    public static class FileDiffRegion
    extends Region
    implements IAdaptable {
        @NonNull
        private final FileDiff diff;

        public FileDiffRegion(@NonNull FileDiff fileDiff, int start, int length) {
            super(start, length);
            this.diff = fileDiff;
        }

        @NonNull
        public FileDiff getDiff() {
            return this.diff;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "[FileDiffRange " + this.diff.getPath() + ' ' + super.toString() + ']';
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (FileDiff.class.equals(adapter)) {
                return adapter.cast(this.diff);
            }
            return null;
        }
    }
}

