/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class VariableDeclarationCleanUpCore
extends AbstractCleanUpCore {
    public VariableDeclarationCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public VariableDeclarationCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    private boolean requireAST() {
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return false;
        }
        return this.isEnabled("cleanup.make_private_fields_final") || this.isEnabled("cleanup.make_parameters_final") || this.isEnabled("cleanup.make_local_variable_final");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return null;
        }
        return VariableDeclarationFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.make_private_fields_final"), this.isEnabled("cleanup.make_parameters_final"), this.isEnabled("cleanup.make_local_variable_final"));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalField_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalParameters_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalLocals_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            buf.append("private final int i= 0;\n");
        } else {
            buf.append("private int i= 0;\n");
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            buf.append("public void foo(final int j) {\n");
        } else {
            buf.append("public void foo(int j) {\n");
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            buf.append("    final int k;\n");
            buf.append("    int h;\n");
            buf.append("    h= 0;\n");
        } else {
            buf.append("    int k, h;\n");
            buf.append("    h= 0;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }
}

