/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.reconciler.presentation;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.genericeditor.target.extension.reconciler.presentation.GeneralTagRule;
import org.eclipse.pde.internal.genericeditor.target.extension.reconciler.presentation.TargetPlatformAttributeRule;
import org.eclipse.pde.internal.genericeditor.target.extension.reconciler.presentation.TargetPlatformTagRule;
import org.eclipse.pde.internal.genericeditor.target.extension.reconciler.presentation.UpdatableDefaultDamagerRepairer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TargetPlatformPresentationReconciler
extends PresentationReconciler {
    private UpdatableDefaultDamagerRepairer dr = new UpdatableDefaultDamagerRepairer((ITokenScanner)new RuleBasedScanner());
    private InvalidatingListener listener;

    public TargetPlatformPresentationReconciler() {
        this.setDamager((IPresentationDamager)this.dr, "__dftl_partition_content_type");
        this.setRepairer((IPresentationRepairer)this.dr, "__dftl_partition_content_type");
        this.setDamageRepairerScanner();
        this.listener = new InvalidatingListener();
    }

    public void install(ITextViewer viewer) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.workbench");
        store.addPropertyChangeListener((IPropertyChangeListener)this.listener);
        this.listener.setViewer(viewer);
        super.install(viewer);
    }

    public void uninstall() {
        super.uninstall();
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.workbench");
        store.removePropertyChangeListener((IPropertyChangeListener)this.listener);
    }

    private void setDamageRepairerScanner() {
        if (this.dr == null) {
            return;
        }
        RuleBasedScanner scanner = new RuleBasedScanner();
        ColorRegistry manager = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        IRule[] rules = new IRule[]{new SingleLineRule("<?", "?>", (IToken)new Token((Object)new TextAttribute(manager.get("org.eclipse.pde.genericeditor.extension.editor.color.header")))), new SingleLineRule("\"", "\"", (IToken)new Token((Object)new TextAttribute(manager.get("org.eclipse.pde.genericeditor.extension.editor.color.quote")))), new MultiLineRule("<!--", "-->", (IToken)new Token((Object)new TextAttribute(manager.get("org.eclipse.pde.genericeditor.extension.editor.color.comment")))), new TargetPlatformTagRule(), new TargetPlatformAttributeRule(), new GeneralTagRule()};
        scanner.setRules(rules);
        this.dr.updateTokenScanner((ITokenScanner)scanner);
    }

    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        TextPresentation presentation = new TextPresentation(damage, 1000);
        IPresentationRepairer repairer = this.getRepairer("__dftl_partition_content_type");
        if (repairer != null) {
            try {
                ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)0, (int)document.getLength(), (boolean)false);
                if (regions.length > 0) {
                    repairer.createPresentation(presentation, regions[0]);
                    return presentation;
                }
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return presentation;
    }

    private final class InvalidatingListener
    implements IPropertyChangeListener {
        ITextViewer viewer;

        private InvalidatingListener() {
        }

        public void setViewer(ITextViewer newViewer) {
            this.viewer = newViewer;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("overriddenByCSS".equals(event.getProperty())) {
                return;
            }
            TargetPlatformPresentationReconciler.this.setDamageRepairerScanner();
            Display.getDefault().asyncExec(() -> this.viewer.invalidateTextPresentation());
        }
    }
}

