/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.util.StringTokenizer;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.ui.internal.views.AllTopicsPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;

public class ShowInTocAction
implements ILiveHelpAction {
    private String path;

    public void setInitializationString(String data) {
        this.path = data;
    }

    public void run() {
        IHelpResource res = this.getHelpResource();
        ReusableHelpPart helpPart = ReusableHelpPart.getLastActiveInstance();
        if (helpPart != null) {
            helpPart.getControl().getDisplay().syncExec(() -> {
                helpPart.showPage("all-topics-page");
                AllTopicsPart part = (AllTopicsPart)helpPart.findPart("topic-tree");
                if (part != null) {
                    part.selectReveal(res);
                }
            });
        }
    }

    private IHelpResource getHelpResource() {
        StringTokenizer tok = new StringTokenizer(this.path, "_");
        int index = Integer.parseInt(tok.nextToken());
        IToc[] tocs = HelpSystem.getTocs();
        IToc toc = tocs[index];
        if (tok.hasMoreTokens()) {
            ITopic topic = toc.getTopic(null);
            while (tok.hasMoreTokens()) {
                index = Integer.parseInt(tok.nextToken());
                topic = topic.getSubtopics()[index];
            }
            return topic;
        }
        return toc;
    }
}

