/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.autdetails;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.autdetails.IAutDetailsProcessor;
import org.osgi.framework.Version;

public class AutDetailsCollector {
    private IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();

    public void collectInformation(Aut aut, IAutDetailsProcessor processor) {
        ILaunchConfiguration configuration = aut.getConfig();
        try {
            this.collectEclipseInfo(processor, configuration);
            this.collectBundlesInfo(processor, configuration);
            this.collectMetadataLog(processor, configuration);
            this.collectConsoleLog(processor, configuration);
            this.collectBundlesInfoRuntime(processor, configuration);
            this.collectConfigIniRuntime(processor, configuration);
            this.collectQ7Properties(processor);
            this.collectPlatformInfo(processor);
            Properties configuration_props = this.mapToProperties(configuration.getAttributes());
            processor.addFile("configuration.properties", configuration_props);
            processor.closeStream();
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log((Throwable)e);
        }
    }

    private void collectConfigIniRuntime(IAutDetailsProcessor processor, ILaunchConfiguration configuration) throws FileNotFoundException {
        File bundles_info_file = new Path(LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)configuration).getAbsolutePath()).append("config.ini").toFile();
        this.passFile("config_ini_runtime.ini", bundles_info_file, processor);
    }

    private void collectBundlesInfoRuntime(IAutDetailsProcessor processor, ILaunchConfiguration configuration) throws FileNotFoundException {
        File bundles_info_file = new Path(LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)configuration).getAbsolutePath()).append("org.eclipse.equinox.simpleconfigurator").append("bundles.info").toFile();
        this.passFile("bundles_info_runtime.info", bundles_info_file, processor);
    }

    private void collectQ7Properties(IAutDetailsProcessor processor) {
        Properties q7props = new Properties();
        Version runtimeBundle = Platform.getBundle((String)"org.eclipse.rcptt.updates.runtime.e4x").getVersion();
        q7props.put("runtime.version", runtimeBundle.toString());
        processor.addFile("Q7 version.properties", q7props);
    }

    private void collectPlatformInfo(IAutDetailsProcessor processor) {
        Properties platform_info = new Properties();
        platform_info.put("os.arch", System.getProperty("os.arch"));
        platform_info.put("os.name", System.getProperty("os.name"));
        platform_info.put("os.version", System.getProperty("os.version"));
        platform_info.put("java.runtime.name", System.getProperty("java.runtime.name"));
        platform_info.put("java.runtime.version", System.getProperty("java.runtime.version"));
        processor.addFile("platform.properties", platform_info);
    }

    private void collectConsoleLog(IAutDetailsProcessor processor, ILaunchConfiguration configuration) throws CoreException, FileNotFoundException {
        File console_log_file = new Path(configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", "")).toFile();
        this.passFile("console.log", console_log_file, processor);
    }

    private void collectMetadataLog(IAutDetailsProcessor processor, ILaunchConfiguration configuration) throws CoreException, FileNotFoundException {
        File metadata_log_file = new Path(LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)configuration)).append(".metadata").append(".log").toFile();
        this.passFile("metadata.log", metadata_log_file, processor);
    }

    private void collectBundlesInfo(IAutDetailsProcessor processor, ILaunchConfiguration configuration) throws CoreException, FileNotFoundException {
        File bundles_info_file = new Path(configuration.getAttribute("aut-location", "")).append("configuration").append("org.eclipse.equinox.simpleconfigurator").append("bundles.info").toFile();
        this.passFile("bundles.info", bundles_info_file, processor);
    }

    private void collectEclipseInfo(IAutDetailsProcessor processor, ILaunchConfiguration configuration) throws CoreException, FileNotFoundException {
        File eclipse_ini_file = new Path(configuration.getAttribute("aut-location", "")).append("eclipse.ini").toFile();
        this.passFile("eclipse.ini", eclipse_ini_file, processor);
    }

    private void passFile(String file_name, File file, IAutDetailsProcessor processor) throws FileNotFoundException {
        if (file.exists()) {
            processor.addFile(file_name, new BufferedInputStream(new FileInputStream(file)));
        }
    }

    private Properties mapToProperties(Map map) {
        Properties p = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            String value = entry.getValue().toString();
            String substituted = "";
            try {
                substituted = this.mgr.performStringSubstitution(value);
            }
            catch (CoreException coreException) {}
            if (!value.equals(substituted)) {
                p.put(entry.getKey() + "_substituted", substituted);
            }
            p.put(entry.getKey(), value);
        }
        return p;
    }
}

