/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSHelpObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSRun;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleCSCommandDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleCSHelpDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleDetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.pde.internal.ui.parts.PDESourceViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class SimpleCSItemDetails
extends CSAbstractDetails {
    private ISimpleCSItem fItem = null;
    private FormEntry fTitle = null;
    private Button fSkip = null;
    private PDESourceViewer fContentViewer = null;
    private Section fMainSection = null;
    private SimpleCSHelpDetails fHelpSection;
    private SimpleCSCommandDetails fCommandSection;
    private ControlDecoration fSkipInfoDecoration = null;
    private boolean fBlockEvents = false;

    public SimpleCSItemDetails(ICSMaster section) {
        super(section, "simplecs-context");
        this.fHelpSection = new SimpleCSHelpDetails(section);
        this.fCommandSection = new SimpleCSCommandDetails(section);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.fHelpSection.initialize(form);
        this.fCommandSection.initialize(form);
    }

    @Override
    public void createDetails(Composite parent) {
        Color foreground = this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
        GridData data = null;
        this.fMainSection = this.getToolkit().createSection(parent, 384);
        this.fMainSection.clientVerticalSpacing = 6;
        this.fMainSection.setText(SimpleDetailsMessages.SimpleCSItemDetails_mainSectionText);
        this.fMainSection.setDescription(SimpleDetailsMessages.SimpleCSItemDetails_mainSectionDesc);
        this.fMainSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        data = new GridData(768);
        this.fMainSection.setLayoutData((Object)data);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite mainSectionClient = this.getToolkit().createComposite((Composite)this.fMainSection);
        mainSectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        this.fTitle = new FormEntry(mainSectionClient, this.getToolkit(), SimpleDetailsMessages.SimpleCSItemDetails_attrTitle, 0);
        this.createUIFieldContent(mainSectionClient);
        this.fSkip = this.getToolkit().createButton(mainSectionClient, SimpleDetailsMessages.SimpleCSItemDetails_attrSkip, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.fSkip.setLayoutData((Object)data);
        this.fSkip.setForeground(foreground);
        this.createSkipInfoDecoration();
        this.getToolkit().paintBordersFor(mainSectionClient);
        this.fMainSection.setClient((Control)mainSectionClient);
        this.markDetailsPart((Control)this.fMainSection);
        this.fCommandSection.createDetails(parent);
        this.fHelpSection.createDetails(parent);
    }

    public boolean doGlobalAction(String actionId) {
        return this.fContentViewer.doGlobalAction(actionId);
    }

    private void createUIFieldContent(Composite parent) {
        GridData data = null;
        Color foreground = this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
        Label label = this.getToolkit().createLabel(parent, SimpleDetailsMessages.SimpleCSItemDetails_label, 64);
        label.setForeground(foreground);
        int style = 130;
        data = new GridData(style);
        label.setLayoutData((Object)data);
        this.fContentViewer = new PDESourceViewer(this.getPage());
        this.fContentViewer.createUI(parent, 90, 60);
        ((GridData)this.fContentViewer.getViewer().getTextWidget().getLayoutData()).horizontalIndent = 3;
    }

    private void createSkipInfoDecoration() {
        int bits = 16512;
        this.fSkipInfoDecoration = new ControlDecoration((Control)this.fSkip, bits);
        this.fSkipInfoDecoration.setMarginWidth(1);
        this.fSkipInfoDecoration.setDescriptionText(SimpleDetailsMessages.SimpleCSItemDetails_disabled);
        this.updateSkipInfoDecoration(false);
        this.fSkipInfoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
    }

    @Override
    public void hookListeners() {
        this.createUIListenersContentViewer();
        this.fTitle.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (SimpleCSItemDetails.this.fItem == null) {
                    return;
                }
                SimpleCSItemDetails.this.fItem.setTitle(SimpleCSItemDetails.this.fTitle.getValue());
            }
        });
        this.fSkip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSItemDetails.this.fItem == null) {
                    return;
                }
                SimpleCSItemDetails.this.fItem.setSkip(SimpleCSItemDetails.this.fSkip.getSelection());
                SimpleCSItemDetails.this.getMasterSection().updateButtons();
            }
        });
        this.fHelpSection.hookListeners();
        this.fCommandSection.hookListeners();
    }

    private void createUIListenersContentViewer() {
        this.fContentViewer.createUIListeners();
        this.fContentViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (SimpleCSItemDetails.this.fBlockEvents) {
                    return;
                }
                if (SimpleCSItemDetails.this.fItem == null) {
                    return;
                }
                IDocument document = event.getDocument();
                if (document == null) {
                    return;
                }
                String text = document.get().trim();
                if (SimpleCSItemDetails.this.fItem.getDescription() != null) {
                    SimpleCSItemDetails.this.fItem.getDescription().setContent(text);
                }
            }
        });
    }

    @Override
    public void updateFields() {
        boolean editable = this.isEditableElement();
        if (this.fItem == null) {
            return;
        }
        this.fTitle.setValue(this.fItem.getTitle(), true);
        this.fTitle.setEditable(editable);
        this.fSkip.setSelection(this.fItem.getSkip());
        this.updateSkipEnablement();
        this.fHelpSection.updateFields();
        this.fCommandSection.updateFields();
        if (this.fItem.getDescription() == null) {
            return;
        }
        this.fBlockEvents = true;
        String content = this.fItem.getDescription().getContent();
        this.fContentViewer.getDocument().set(content == null ? "" : content);
        this.fBlockEvents = false;
        this.fContentViewer.getViewer().setEditable(editable);
    }

    public void dispose() {
        if (this.fContentViewer != null) {
            this.fContentViewer.unsetMenu();
            this.fContentViewer = null;
        }
        super.dispose();
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.fContentViewer.canPaste();
    }

    private void updateSkipEnablement() {
        if (this.fItem == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        if (this.fItem.hasSubItems()) {
            editable = false;
            this.updateSkipInfoDecoration(true);
        } else {
            this.updateSkipInfoDecoration(false);
        }
        this.fSkip.setEnabled(editable);
    }

    private void updateSkipInfoDecoration(boolean show) {
        if (show) {
            this.fSkipInfoDecoration.show();
        } else {
            this.fSkipInfoDecoration.hide();
        }
        this.fSkipInfoDecoration.setShowHover(show);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fTitle.commit();
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object == null || !(object instanceof ISimpleCSItem)) {
            return;
        }
        this.setData((ISimpleCSItem)object);
        this.updateFields();
    }

    public void setData(ISimpleCSItem object) {
        this.fItem = object;
        this.fCommandSection.setData((ISimpleCSRun)object);
        this.fHelpSection.setData((ISimpleCSHelpObject)object);
    }
}

