/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.revision;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;

public class LocationEditableRevision
extends EditableRevision {
    private final IPath location;
    private final IRunnableContext runnableContext;

    public LocationEditableRevision(IFileRevision fileRevision, @NonNull IPath location, @NonNull IRunnableContext runnableContext) {
        super(fileRevision, null);
        this.location = location;
        this.runnableContext = runnableContext;
    }

    @Override
    public void setContent(byte[] newContent) {
        try {
            IFile ourFile;
            ISchedulingRule rule = Job.getJobManager().currentRule();
            boolean fork = true;
            if (rule instanceof IResource && (ourFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.location)).exists() && ((IResource)rule).isConflicting((ISchedulingRule)ourFile)) {
                fork = false;
            }
            this.runnableContext.run(fork, false, monitor -> {
                IFileStore store = EFS.getLocalFileSystem().getStore(this.location);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(store.openOutputStream(0, monitor));){
                        out.write(newContent);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getTargetException().getMessage(), e.getTargetException(), true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected <T> T adaptEditorInput(IEditorInput editorInput, Class<T> adapter) {
        if (adapter == IFile.class) {
            return adapter.cast(ResourcesPlugin.getWorkspace().getRoot().getFile(this.location));
        }
        return super.adaptEditorInput(editorInput, adapter);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.location, this.runnableContext);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationEditableRevision other = (LocationEditableRevision)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.runnableContext, other.runnableContext);
    }
}

