/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.AntAutoEditStrategy;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormattingStrategy;
import org.eclipse.ant.internal.ui.editor.formatter.XmlElementFormattingStrategy;
import org.eclipse.ant.internal.ui.editor.text.AntInformationProvider;
import org.eclipse.ant.internal.ui.editor.text.NotifyingReconciler;
import org.eclipse.ant.internal.ui.editor.text.XMLAnnotationHover;
import org.eclipse.ant.internal.ui.editor.text.XMLReconcilingStrategy;
import org.eclipse.ant.internal.ui.editor.text.XMLTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;

public class AntEditorSourceViewerConfiguration
extends AntSourceViewerConfiguration {
    private AntEditor fEditor;
    private XMLTextHover fTextHover;
    private ContentAssistant fContentAssistant;
    private AntAutoEditStrategy[] fAutoEditorStategies;

    public AntEditorSourceViewerConfiguration(AntEditor editor) {
        this.fEditor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.fContentAssistant = new ContentAssistant();
        AntEditorCompletionProcessor processor = new AntEditorCompletionProcessor(this.fEditor.getAntModel());
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_tag");
        this.fContentAssistant.setDocumentPartitioning("org.eclipse.ant.ui.antPartitioning");
        String triggers = this.fPreferenceStore.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            processor.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        this.fContentAssistant.enableAutoInsert(this.fPreferenceStore.getBoolean("content_assist_autoinsert"));
        this.fContentAssistant.enableAutoActivation(this.fPreferenceStore.getBoolean("content_assist_autoactivation"));
        this.fContentAssistant.setAutoActivationDelay(this.fPreferenceStore.getInt("content_assist_autoactivation_delay"));
        this.fContentAssistant.setProposalPopupOrientation(10);
        this.fContentAssistant.setContextInformationPopupOrientation(20);
        this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        Color background = JFaceResources.getColorRegistry().get("CONTENT_ASSIST_BACKGROUND_COLOR");
        this.fContentAssistant.setContextInformationPopupBackground(background);
        this.fContentAssistant.setContextSelectorBackground(background);
        Color foreground = JFaceResources.getColorRegistry().get("CONTENT_ASSIST_FOREGROUND_COLOR");
        this.fContentAssistant.setContextInformationPopupForeground(foreground);
        this.fContentAssistant.setContextSelectorForeground(foreground);
        IInformationControlCreator creator = this.getInformationControlCreator(sourceViewer);
        this.fContentAssistant.setInformationControlCreator(creator);
        this.fContentAssistant.setRepeatedInvocationMode(true);
        this.fContentAssistant.setStatusLineVisible(true);
        this.fContentAssistant.setShowEmptyList(true);
        this.fContentAssistant.addCompletionListener((ICompletionListener)processor);
        return this.fContentAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NotifyingReconciler reconciler = new NotifyingReconciler(new XMLReconcilingStrategy(this.fEditor));
        reconciler.setDelay(500);
        reconciler.addReconcilingParticipant(this.fEditor);
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new XMLAnnotationHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null) {
            this.fTextHover = new XMLTextHover(this.fEditor);
        }
        return this.fTextHover;
    }

    protected void changeConfiguration(PropertyChangeEvent event) {
        String p = event.getProperty();
        if ("content_assist_autoactivation".equals(p)) {
            boolean enabled = this.fPreferenceStore.getBoolean("content_assist_autoactivation");
            this.fContentAssistant.enableAutoActivation(enabled);
        } else if ("content_assist_autoactivation_delay".equals(p) && this.fContentAssistant != null) {
            int delay = this.fPreferenceStore.getInt("content_assist_autoactivation_delay");
            this.fContentAssistant.setAutoActivationDelay(delay);
        } else if ("content_assist_autoinsert".equals(p) && this.fContentAssistant != null) {
            boolean enabled = this.fPreferenceStore.getBoolean("content_assist_autoinsert");
            this.fContentAssistant.enableAutoInsert(enabled);
        } else if ("content_assist_autoactivation_triggers_java".equals(p)) {
            this.changeContentAssistProcessor();
        }
    }

    private void changeContentAssistProcessor() {
        AntEditorCompletionProcessor cp;
        String triggers = this.fPreferenceStore.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null && (cp = (AntEditorCompletionProcessor)this.fContentAssistant.getContentAssistProcessor("__dftl_partition_content_type")) != null) {
            cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new XmlDocumentFormattingStrategy());
        formatter.setSlaveStrategy((IFormattingStrategy)new XmlElementFormattingStrategy(), "__xml_tag");
        return formatter;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(AntEditorSourceViewerConfiguration.getInformationPresenterControlCreator());
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        AntInformationProvider provider = new AntInformationProvider(new XMLTextHover(this.fEditor));
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__xml_cdata");
        presenter.setInformationProvider((IInformationProvider)provider, "__xml_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__xml_dtd");
        presenter.setInformationProvider((IInformationProvider)provider, "__xml_tag");
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public static IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        };
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        ArrayList<String> list = new ArrayList<String>();
        int tabWidth = this.getTabWidth(sourceViewer);
        boolean useSpaces = this.fEditor.isTabsToSpacesConversionEnabled();
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuilder prefix = new StringBuilder();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            list.add(prefix.toString());
            ++i;
        }
        list.add("");
        return list.toArray(new String[list.size()]);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__xml_comment".equals(contentType)) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.fAutoEditorStategies == null) {
            this.fAutoEditorStategies = new AntAutoEditStrategy[]{new AntAutoEditStrategy(this.fEditor.getAntModel())};
        }
        return this.fAutoEditorStategies;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.ant.ui.buildFiles", this.fEditor);
        return targets;
    }
}

