/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.repository.CreateRepositoryPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewRepositoryWizard
extends Wizard
implements INewWizard {
    private final CreateRepositoryPage myCreatePage;
    private Repository repository;
    private RepositoryGroup group;

    public NewRepositoryWizard() {
        this(false);
    }

    public NewRepositoryWizard(boolean hideBareOption) {
        this.myCreatePage = new CreateRepositoryPage(hideBareOption);
    }

    public void addPages() {
        this.setWindowTitle(UIText.NewRepositoryWizard_WizardTitle);
        this.setHelpAvailable(false);
        this.addPage((IWizardPage)this.myCreatePage);
    }

    public boolean performFinish() {
        block5: {
            IProject[] projects;
            block6: {
                boolean isBare = this.myCreatePage.getBare();
                File gitDir = Git.init().setDirectory(FileUtils.canonicalize((File)new File(this.myCreatePage.getDirectory()))).setBare(isBare).call().getRepository().getDirectory();
                this.repository = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(gitDir);
                if (this.group != null) {
                    RepositoryGroups.getInstance().addRepositoriesToGroup(this.group, Collections.singletonList(gitDir));
                }
                org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil().addConfiguredRepository(gitDir);
                if (isBare || !this.doAutoShare()) break block5;
                Path workTree = new Path(this.repository.getWorkTree().getAbsolutePath());
                projects = ProjectUtil.getProjectsUnderPath((IPath)workTree);
                if (projects.length != 0) break block6;
                return true;
            }
            try {
                this.autoShareProjects(this.repository, projects);
            }
            catch (GitAPIException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
        return true;
    }

    private boolean doAutoShare() {
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId());
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId());
        return p.getBoolean("core_autoShareProjects", d.getBoolean("core_autoShareProjects", true));
    }

    private void autoShareProjects(Repository repoToCreate, IProject[] projects) {
        HashMap<IProject, File> projectsMap = new HashMap<IProject, File>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectsMap.put(project, repoToCreate.getDirectory());
            ++n2;
        }
        ConnectProviderOperation op = new ConnectProviderOperation(projectsMap);
        JobUtil.scheduleUserJob((IEGitOperation)op, (String)CoreText.Activator_AutoShareJobName, (Object)JobFamilies.AUTO_SHARE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public Repository getCreatedRepository() {
        return this.repository;
    }

    public void setRepositoryGroup(RepositoryGroup group) {
        this.group = group;
    }
}

