/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.DeletePathsOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeletePathsOperationUI {
    private final Collection<IPath> paths;
    private final IShellProvider shellProvider;

    public DeletePathsOperationUI(Collection<IPath> paths, IShellProvider shellProvider) {
        this.paths = paths;
        this.shellProvider = shellProvider;
    }

    public void run() {
        List<IResource> resources = this.getSelectedResourcesIfAllExist();
        if (resources != null) {
            this.runNormalAction(resources);
        } else {
            this.runNonWorkspaceAction();
        }
    }

    private void runNormalAction(List<IResource> resources) {
        DeleteResourceAction action = new DeleteResourceAction(this.shellProvider);
        StructuredSelection selection = new StructuredSelection(resources);
        action.selectionChanged((IStructuredSelection)selection);
        action.run();
    }

    private void runNonWorkspaceAction() {
        String[] buttonLabels = new String[]{UIText.DeletePathsOperationUI_ButtonOK, IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = new MessageDialog(this.shellProvider.getShell(), UIText.DeletePathsOperationUI_confirmActionTitle, null, UIText.DeletePathsOperationUI_confirmActionMessage, 5, buttonLabels, 0);
        if (dialog.open() != 0) {
            return;
        }
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)new DeletePathsOperation(this.paths), (String)UIText.DeletePathsOperationUI_DeleteFilesJobName, (Object)JobFamilies.DELETE);
    }

    private List<IResource> getSelectedResourcesIfAllExist() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (IPath path : this.paths) {
            IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
            if (resource == null) {
                return null;
            }
            resources.add(resource);
        }
        return resources;
    }
}

