/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBundleClasspathResolver;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;

public class ClasspathHelper {
    private static final String DOT = ".";
    private static final String FRAGMENT_ANNOTATION = "@fragment@";

    public static String getDevEntriesProperties(String fileName, boolean checkExcluded) {
        Object model;
        IPluginModelBase[] models;
        File directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || directory.exists() && !directory.isFile())) {
            directory.mkdirs();
        }
        Properties properties = new Properties();
        TargetWeaver.weaveDevProperties(properties);
        IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getWorkspaceModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            String currentValue;
            String entry;
            model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            if (id != null && (entry = ClasspathHelper.writeEntry(ClasspathHelper.getDevPaths((IPluginModelBase)model, checkExcluded, null))).length() > 0 && !entry.equals(currentValue = (String)properties.get(id))) {
                if (currentValue != null) {
                    entry = currentValue.concat(",").concat(entry);
                }
                properties.put(id, entry);
            }
            ++n2;
        }
        properties.put("@ignoredot@", "true");
        try {
            model = null;
            Object var6_9 = null;
            try (FileOutputStream stream = new FileOutputStream(fileName);){
                properties.store(stream, "");
                stream.flush();
                return new URL("file:" + fileName).toString();
            }
            catch (Throwable throwable) {
                if (model == null) {
                    model = throwable;
                } else if (model != throwable) {
                    ((Throwable)model).addSuppressed(throwable);
                }
                throw model;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return ClasspathHelper.getDevEntries(checkExcluded);
        }
    }

    public static String getDevEntriesProperties(String fileName, Map<?, ?> map) {
        File directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || directory.exists() && !directory.isFile())) {
            directory.mkdirs();
        }
        Properties properties = new Properties();
        TargetWeaver.weaveDevProperties(properties);
        for (Object model : map.values()) {
            String id;
            String currentValue;
            String entry;
            if (model.getUnderlyingResource() == null || (entry = ClasspathHelper.writeEntry(ClasspathHelper.getDevPaths((IPluginModelBase)model, true, map))).length() <= 0 || entry.equals(currentValue = (String)properties.get(id = model.getPluginBase().getId()))) continue;
            if (currentValue != null) {
                entry = currentValue.concat(",").concat(entry);
            }
            properties.put(id, entry);
        }
        properties.put("@ignoredot@", "true");
        try {
            Object model;
            model = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(fileName);){
                properties.store(stream, "");
                stream.flush();
                return new URL("file:" + fileName).toString();
            }
            catch (Throwable throwable) {
                if (model == null) {
                    model = throwable;
                } else if (model != throwable) {
                    ((Throwable)model).addSuppressed(throwable);
                }
                throw model;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return ClasspathHelper.getDevEntries(true);
        }
    }

    private static String getDevEntries(boolean checkExcluded) {
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        ArrayList list = new ArrayList();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            if (id != null && id.trim().length() != 0) {
                IPath[] paths = ClasspathHelper.getDevPaths(model, checkExcluded, null);
                Collections.addAll(list, paths);
            }
            ++n2;
        }
        String entry = ClasspathHelper.writeEntry(list.toArray(new IPath[list.size()]));
        return entry.length() > 0 ? entry : "bin";
    }

    private static String writeEntry(IPath[] paths) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < paths.length) {
            buffer.append(paths[i].toString());
            if (i < paths.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static Dictionary<String, String> getDevDictionary(IPluginModelBase model) {
        if (model.getUnderlyingResource() == null) {
            return null;
        }
        String id = model.getPluginBase().getId();
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        IPath[] paths = ClasspathHelper.getDevPaths(model, false, null);
        String entry = ClasspathHelper.writeEntry(paths);
        Hashtable<String, String> map = new Hashtable<String, String>(2);
        map.put("@ignoredot@", "true");
        map.put(id, entry.length() > 0 ? entry : "bin");
        return map;
    }

    private static Map<IPath, ArrayList<IPath>> getClasspathMap(IProject project, boolean checkExcluded, boolean absolutePaths) throws JavaModelException {
        IBundleClasspathResolver[] resolvers;
        IClasspathEntry[] entries;
        List<Path> excluded = ClasspathHelper.getFoldersToExclude(project, checkExcluded);
        IJavaProject jProject = JavaCore.create((IProject)project);
        LinkedHashMap<IPath, ArrayList<IPath>> map = new LinkedHashMap<IPath, ArrayList<IPath>>();
        IClasspathEntry[] iClasspathEntryArray = entries = jProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IPath source;
                IPath output;
                block13: {
                    block11: {
                        IResource file;
                        block12: {
                            IClasspathEntry entry = iClasspathEntryArray[n2];
                            output = null;
                            source = null;
                            if (entry.getEntryKind() == 3) {
                                source = entry.getPath();
                                output = entry.getOutputLocation();
                                if (output == null) {
                                    output = jProject.getOutputLocation();
                                }
                            } else if (entry.getEntryKind() == 1) {
                                source = entry.getPath();
                                output = entry.getPath();
                                if (source.segmentCount() == 1) {
                                    source = new Path(DOT);
                                }
                            }
                            if (output == null || excluded.contains(output) || (file = project.findMember(output.removeFirstSegments(1))) == null) break block10;
                            boolean isLinked = file.isLinked(512);
                            if (!isLinked && !absolutePaths) break block11;
                            IPath location = file.getLocation();
                            if (location == null) break block12;
                            output = location.makeAbsolute();
                            break block13;
                        }
                        PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)PDECoreMessages.ClasspathHelper_BadFileLocation, (Object)file.getFullPath())));
                        break block10;
                    }
                    output = output.makeRelative();
                }
                ArrayList<IPath> list = (ArrayList<IPath>)((HashMap)map).get(source);
                if (list == null) {
                    list = new ArrayList<IPath>();
                }
                list.add(output);
                map.put(source, list);
            }
            ++n2;
        }
        IBundleClasspathResolver[] iBundleClasspathResolverArray = resolvers = PDECore.getDefault().getClasspathContainerResolverManager().getBundleClasspathResolvers(project);
        int n3 = resolvers.length;
        n = 0;
        while (n < n3) {
            IBundleClasspathResolver resolver = iBundleClasspathResolverArray[n];
            Map<IPath, Collection<IPath>> resolved = resolver.getAdditionalClasspathEntries(jProject);
            for (Map.Entry<IPath, Collection<IPath>> resolvedEntry : resolved.entrySet()) {
                IPath ceSource = resolvedEntry.getKey();
                ArrayList<IPath> list = (ArrayList<IPath>)((HashMap)map).get(ceSource);
                if (list == null) {
                    list = new ArrayList<IPath>();
                    map.put(ceSource, list);
                }
                list.addAll(resolvedEntry.getValue());
            }
            ++n;
        }
        return map;
    }

    private static IPath[] findLibrary(String libName, IProject project, Map<IPath, ArrayList<IPath>> classpathMap, IBuild build) {
        IResource res;
        IBuildEntry entry;
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IBuildEntry iBuildEntry = entry = build != null ? build.getEntry("source." + libName) : null;
        if (entry != null) {
            String[] resources;
            String[] stringArray = resources = entry.getTokens();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayList<IPath> list;
                String resource = stringArray[n2];
                IResource res2 = project.findMember(resource);
                if (res2 != null && (list = classpathMap.get(res2.getFullPath())) != null) {
                    Iterator<IPath> li = list.iterator();
                    while (li.hasNext()) {
                        paths.add(li.next());
                    }
                }
                ++n2;
            }
        }
        Object path = null;
        path = libName.equals(DOT) ? new Path(DOT) : ((res = project.findMember(libName)) != null ? res.getFullPath() : new Path(libName));
        List list = classpathMap.get(path);
        if (list != null) {
            Iterator li = list.iterator();
            while (li.hasNext()) {
                paths.add((IPath)li.next());
            }
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private static IPath[] getDevPaths(IPluginModelBase model, boolean checkExcluded, Map<?, ?> pluginsMap) {
        ArrayList<IPath> result;
        block16: {
            result = new ArrayList<IPath>();
            IProject project = model.getUnderlyingResource().getProject();
            IPluginBase base = model.getPluginBase();
            IPluginLibrary[] libraries = base.getLibraries();
            try {
                boolean searchBuild;
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) break block16;
                Map<IPath, ArrayList<IPath>> classpathMap = ClasspathHelper.getClasspathMap(project, checkExcluded, false);
                IFile file = PDEProject.getBuildProperties(project);
                IPath filePath = file.getLocation();
                boolean bl = searchBuild = filePath != null && filePath.toFile().exists();
                if (searchBuild) {
                    int n;
                    WorkspaceBuildModel bModel = new WorkspaceBuildModel(file);
                    IBuild build = bModel.getBuild();
                    IBuildEntry entry = build.getEntry("custom");
                    if (entry != null) {
                        searchBuild = false;
                    } else if (libraries.length == 0) {
                        IPath[] paths = ClasspathHelper.findLibrary(DOT, project, classpathMap, build);
                        if (paths.length == 0 && !classpathMap.isEmpty()) {
                            Iterator<ArrayList<IPath>> iterator = classpathMap.values().iterator();
                            ArrayList collect = new ArrayList();
                            while (iterator.hasNext()) {
                                collect.addAll(iterator.next());
                            }
                            paths = collect.toArray(new IPath[collect.size()]);
                        }
                        IPath[] iPathArray = paths;
                        n = paths.length;
                        int collect = 0;
                        while (collect < n) {
                            IPath path = iPathArray[collect];
                            ClasspathHelper.addPath(result, project, path);
                            ++collect;
                        }
                    } else {
                        int i = 0;
                        while (i < libraries.length) {
                            IPath[] paths = ClasspathHelper.findLibrary(libraries[i].getName(), project, classpathMap, build);
                            if (paths.length == 0 && !libraries[i].getName().equals(DOT)) {
                                paths = ClasspathHelper.findLibraryFromFragments(libraries[i].getName(), model, checkExcluded, pluginsMap);
                            }
                            IPath[] iPathArray = paths;
                            int n2 = paths.length;
                            n = 0;
                            while (n < n2) {
                                IPath path = iPathArray[n];
                                ClasspathHelper.addPath(result, project, path);
                                ++n;
                            }
                            ++i;
                        }
                    }
                }
                if (!searchBuild) {
                    for (Map.Entry<IPath, ArrayList<IPath>> entry : classpathMap.entrySet()) {
                        ArrayList<IPath> list = entry.getValue();
                        ListIterator<IPath> li = list.listIterator();
                        while (li.hasNext()) {
                            ClasspathHelper.addPath(result, project, li.next());
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return result.toArray(new IPath[result.size()]);
    }

    private static IPath[] findLibraryFromFragments(String libName, IPluginModelBase model, boolean checkExcluded, Map<?, ?> plugins) {
        IFragmentModel[] frags = PDEManager.findFragmentsFor(model);
        int i = 0;
        while (i < frags.length) {
            if (plugins == null || plugins.containsKey(frags[i].getBundleDescription().getSymbolicName())) {
                if (frags[i].getUnderlyingResource() != null) {
                    try {
                        IPath[] paths;
                        IProject project = frags[i].getUnderlyingResource().getProject();
                        Map<IPath, ArrayList<IPath>> classpathMap = ClasspathHelper.getClasspathMap(project, checkExcluded, true);
                        IFile file = PDEProject.getBuildProperties(project);
                        IBuild build = null;
                        if (file.exists()) {
                            WorkspaceBuildModel bModel = new WorkspaceBuildModel(file);
                            build = bModel.getBuild();
                        }
                        if ((paths = ClasspathHelper.findLibrary(libName, project, classpathMap, build)).length > 0) {
                            return ClasspathHelper.postfixFragmentAnnotation(paths);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    File file = new File(frags[i].getInstallLocation());
                    if (file.isDirectory() && (file = new File(file, libName)).exists()) {
                        return new IPath[]{new Path(String.valueOf(file.getPath()) + FRAGMENT_ANNOTATION)};
                    }
                }
            }
            ++i;
        }
        return new IPath[0];
    }

    private static IPath[] postfixFragmentAnnotation(IPath[] paths) {
        int i = 0;
        while (i < paths.length) {
            paths[i] = new Path(String.valueOf(paths[i].toString()) + FRAGMENT_ANNOTATION);
            ++i;
        }
        return paths;
    }

    private static void addPath(ArrayList<IPath> result, IProject project, IPath path) {
        IPath resultPath = null;
        if (path.isAbsolute()) {
            resultPath = path;
        } else if (path.segmentCount() > 0 && path.segment(0).equals(project.getName())) {
            IContainer bundleRoot = PDEProject.getBundleRoot(project);
            IPath rootPath = bundleRoot.getFullPath();
            if ((path = path.makeRelativeTo(rootPath)).segmentCount() == 0) {
                resultPath = new Path(DOT);
            } else {
                IResource resource = bundleRoot.findMember(path);
                if (resource != null) {
                    resultPath = path;
                }
            }
        }
        if (resultPath != null && !result.contains(resultPath)) {
            result.add(resultPath);
        }
    }

    private static List<Path> getFoldersToExclude(IProject project, boolean checkExcluded) {
        IEclipsePreferences pref;
        ArrayList<Path> list = new ArrayList<Path>();
        if (checkExcluded && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            String binExcludes = pref.get("selfhosting.binExcludes", "");
            StringTokenizer tokenizer = new StringTokenizer(binExcludes, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(new Path(tokenizer.nextToken().trim()));
            }
        }
        return list;
    }
}

