/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.base.MissingContentManager;
import org.eclipse.help.internal.base.remote.RemoteStatusData;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class StatusProducer
implements IHelpContentProducer {
    private static final String TAB = "  ";
    private static final String INDEX = "/index.jsp";
    private static final String BEGIN_HEAD_HTML = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n" + StatusProducer.tab(1) + "<head>\n" + StatusProducer.tab(2) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n";
    private static final String END_HEAD_HTML = String.valueOf(StatusProducer.tab(1)) + "</head>\n";
    private static final String END_BODY_HTML = String.valueOf(StatusProducer.tab(2)) + "</div>\n" + StatusProducer.tab(1) + "</body>\n</html>";

    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        boolean allFailed;
        String errorPage;
        if (href.equalsIgnoreCase("MissingBooks.html")) {
            return this.getMissingBooksPage(locale, false);
        }
        if (href.equalsIgnoreCase("MissingBooksHV.html")) {
            return this.getMissingBooksPage(locale, true);
        }
        if (href.startsWith("missingTopic/")) {
            String topicPath = href.substring("missingTopic/".length());
            return this.getMissingTopicPage(topicPath, locale);
        }
        if (!(href.equalsIgnoreCase("NetworkHelpStatus.html") || href.equalsIgnoreCase("MissingTopicStatus.html") || href.equalsIgnoreCase("NetworkHelpStatusHV.html"))) {
            return null;
        }
        StringBuilder pageBuffer = new StringBuilder();
        ArrayList remoteSites = RemoteStatusData.getRemoteSites();
        ArrayList badSites = RemoteStatusData.checkSitesConnectivity((ArrayList)remoteSites);
        RemoteStatusData.clearCache();
        if (remoteSites.isEmpty()) {
            if (href.equalsIgnoreCase("MissingTopicStatus.html")) {
                return null;
            }
            return this.getNetworkOKPage(locale);
        }
        if (href.equalsIgnoreCase("MissingTopicStatus.html") && (errorPage = Platform.getPreferencesService().getString("org.eclipse.help.base", "page_not_found", null, null)) != null && errorPage.length() > 0) {
            try {
                URL helpURL = new URL("help", null, -1, errorPage, HelpURLStreamHandler.getDefault());
                return ProxyUtil.getStream((URL)helpURL);
            }
            catch (MalformedURLException e) {
                HelpWebappPlugin.logError("Unable to locate error page: " + errorPage, e);
            }
            catch (IOException e) {
                HelpWebappPlugin.logError("Unable to open error page: " + errorPage, e);
            }
        }
        String title = WebappResources.getString("remoteStatusTitle", locale);
        pageBuffer.append(this.getHtmlHead(locale, title));
        pageBuffer.append(this.getBeginHtmlBody(true));
        if (remoteSites.size() == badSites.size()) {
            allFailed = true;
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + WebappResources.getString("allRemoteHelpUnavailable", locale) + "</h1>\n");
        } else {
            allFailed = false;
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + WebappResources.getString("someRemoteHelpUnavailable", locale) + "</h1>\n");
        }
        if (href.equalsIgnoreCase("NetworkHelpStatus.html")) {
            this.addCloseLink(locale, pageBuffer);
        }
        if (href.equalsIgnoreCase("MissingTopicStatus.html")) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>" + WebappResources.getString("topicUnavailable", locale) + "</p>\n");
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>" + WebappResources.getString("potentialCauses", locale) + "</p>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + WebappResources.getString("serversCouldBeDown", locale) + "</li>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + WebappResources.getString("mayNeedProxy", locale) + "</li>\n");
        if (allFailed) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + WebappResources.getString("networkCouldBeDown", locale) + "</li>\n");
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        if (remoteSites.size() > badSites.size()) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h2>" + WebappResources.getString("sitesWithConnectivity", locale) + "</h2>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
            int r = 0;
            while (r < remoteSites.size()) {
                if (!badSites.contains(remoteSites.get(r))) {
                    pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + this.makeAnchor(remoteSites.get(r) + INDEX, remoteSites.get(r) + INDEX, "", true) + "</li>\n");
                }
                ++r;
            }
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        } else {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + WebappResources.getString("noRemoteSitesAvailable", locale) + "</br>\n");
        }
        if (!badSites.isEmpty()) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h2>" + WebappResources.getString("sitesWithoutConnectivity", locale) + "</h2>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
            int b = 0;
            while (b < badSites.size()) {
                pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>" + badSites.get(b) + INDEX + "</li>\n");
                ++b;
            }
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        }
        String activeLink = MessageFormat.format(WebappResources.getString("remotePreferences", locale), this.getActiveLink(locale));
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + activeLink);
        if (href.equalsIgnoreCase("NetworkHelpStatusHV.html")) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h2>" + WebappResources.getString("RemoteHelpRetestTitle", locale) + "</h2>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<a href=helpview:checkremote>" + WebappResources.getString("RemoteHelpRetestLink", locale) + "</a>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</p>\n");
            pageBuffer.append(END_BODY_HTML);
        }
        return StatusProducer.getBytes(pageBuffer);
    }

    public void addCloseLink(Locale locale, StringBuilder pageBuffer) {
        WebappPreferences prefs = new WebappPreferences();
        String homepage = "/help/topic" + prefs.getHelpHome();
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<div style=\"position:absolute;right:4px;top:4px;\">\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<table>\n" + StatusProducer.tab(5) + "<tr>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(6)) + "<td style=\"background-color:white;border-width:1px;border-style:solid;border-color:grey;\">" + this.makeAnchor(homepage, WebappResources.getString("Close", locale), "style=\"font-size:.8em;\"", false) + "</td>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(5)) + "</tr>\n" + StatusProducer.tab(4) + "</table>\n" + StatusProducer.tab(3) + "</div>\n");
    }

    private InputStream getNetworkOKPage(Locale locale) {
        StringBuilder pageBuffer = new StringBuilder();
        String title = WebappResources.getString("networkHelpAvailable", locale);
        pageBuffer.append(this.getHtmlHead(locale, title));
        pageBuffer.append(this.getBeginHtmlBody(false));
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + title + "</h1>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>\n");
        pageBuffer.append(WebappResources.getString("networkHelpAvailableDetails", locale));
        pageBuffer.append("</p>\n");
        pageBuffer.append(END_BODY_HTML);
        return StatusProducer.getBytes(pageBuffer);
    }

    private InputStream getMissingTopicPage(String topicPath, Locale locale) {
        StringBuilder pageBuffer = new StringBuilder();
        String title = WebappResources.getString("someBooksUninstalled", locale);
        pageBuffer.append(this.getHtmlHead(locale, title));
        pageBuffer.append(this.getBeginHtmlBody(false));
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + title + "</h1>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>\n");
        pageBuffer.append(WebappResources.getString("linkToUninstalledDetails", locale));
        pageBuffer.append("</p>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>\n");
        String href = "PLUGINS_ROOT/" + MissingContentManager.getInstance().getPageNotFoundPage("help:" + topicPath, true);
        pageBuffer.append(StatusProducer.tab(4));
        pageBuffer.append("<a href=\"" + href + "\">");
        pageBuffer.append(WebappResources.getString("linkToUninstalledClick", locale));
        pageBuffer.append("</a>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</p>\n");
        pageBuffer.append(END_BODY_HTML);
        return StatusProducer.getBytes(pageBuffer);
    }

    private InputStream getMissingBooksPage(Locale locale, boolean isHelpView) {
        MissingContentManager.Placeholder[] unresolved = MissingContentManager.getInstance().getUnresolvedPlaceholders();
        if (unresolved.length == 0) {
            return this.getNoBooksMissingPage(locale, isHelpView);
        }
        StringBuilder pageBuffer = new StringBuilder();
        String title = WebappResources.getString("someBooksUninstalled", locale);
        pageBuffer.append(this.getHtmlHead(locale, title));
        pageBuffer.append(this.getBeginHtmlBody(!isHelpView));
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h1>" + title + "</h1>\n");
        if (!isHelpView) {
            this.addCloseLink(locale, pageBuffer);
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>");
        pageBuffer.append(WebappResources.getString("installInstructions", locale));
        pageBuffer.append("</p>\n");
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<ul>\n");
        MissingContentManager.Placeholder[] placeholderArray = unresolved;
        int n = unresolved.length;
        int n2 = 0;
        while (n2 < n) {
            MissingContentManager.Placeholder element = placeholderArray[n2];
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<li>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(5)) + "<a href = \"");
            String href = element.placeholderPage;
            pageBuffer.append(UrlUtil.getHelpURL(href, 2));
            pageBuffer.append("\">");
            pageBuffer.append(element.bundle);
            pageBuffer.append("</a>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "</li>\n");
            ++n2;
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</ul>\n");
        if (isHelpView) {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<br/><p>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(4)) + "<a href=helpview:ignoreMissingBooks>" + WebappResources.getString("ignoreMissingBooks", locale) + "</a>\n");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</p>\n");
        } else {
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<br/><p>\n");
            pageBuffer.append("<a class=\"command-link\" href='javascript:executeCommand(\"org.eclipse.help.ui.ignoreMissingPlaceholders\")'>" + WebappResources.getString("ignoreMissingBooks", locale) + "</a>");
            pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "</p>\n");
        }
        pageBuffer.append(END_BODY_HTML);
        return StatusProducer.getBytes(pageBuffer);
    }

    private InputStream getNoBooksMissingPage(Locale locale, boolean isHelpView) {
        StringBuilder pageBuffer = new StringBuilder();
        String title = WebappResources.getString("allBooksInstalledTitle", locale);
        pageBuffer.append(this.getHtmlHead(locale, title));
        pageBuffer.append(this.getBeginHtmlBody(!isHelpView));
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<h2>" + title + "</h2>\n");
        if (!isHelpView) {
            this.addCloseLink(locale, pageBuffer);
        }
        pageBuffer.append(String.valueOf(StatusProducer.tab(3)) + "<p>\n");
        pageBuffer.append(WebappResources.getString("allBooksInstalled", locale));
        pageBuffer.append("</p>\n");
        pageBuffer.append(END_BODY_HTML);
        return StatusProducer.getBytes(pageBuffer);
    }

    private String getHtmlHead(Locale locale, String title) {
        return String.valueOf(BEGIN_HEAD_HTML) + '\n' + StatusProducer.tab(2) + "<meta name=\"copyright\" content=\"Copyright (c) IBM Corporation and others 2000, 2009. This page is made available under license. For full details see the LEGAL in the documentation book that contains this page.\" >\n" + StatusProducer.tab(2) + "<title>" + title + "</title>\n" + StatusProducer.tab(2) + "<link rel=\"stylesheet\" href=\"PLUGINS_ROOT/org.eclipse.help.base/doc/book.css\" charset=\"utf-8\" type=\"text/css\">\n" + StatusProducer.tab(2) + "<script language=\"JavaScript\" src=\"PLUGINS_ROOT/org.eclipse.help/livehelp.js\"> </script>\n" + StatusProducer.tab(2) + "<script type=\"text/javascript\" src=\"../../../content/org.eclipse.help/livehelp.js\"></script>\n" + END_HEAD_HTML;
    }

    private String getBeginHtmlBody(boolean addBanner) {
        String body = StatusProducer.tab(1);
        body = ProductPreferences.isRTL() ? String.valueOf(body) + "<body dir=\"rtl\">" : String.valueOf(body) + "<body>";
        body = String.valueOf(body) + '\n';
        if (addBanner) {
            body = String.valueOf(body) + StatusProducer.tab(2) + "<div id=\"banner\"><img src=\"PLUGINS_ROOT/org.eclipse.help.base/doc/help_banner.jpg\" alt=\"Help banner\" width=\"1600\" height=\"36\"></div>\n";
        }
        return String.valueOf(body) + StatusProducer.tab(2) + "<div id=\"content\">\n";
    }

    private String getActiveLink(Locale locale) {
        return "<img src=\"PLUGINS_ROOT/org.eclipse.help/command_link.svg\"/><a class=\"command-link\" href='javascript:executeCommand(\"org.eclipse.ui.window.preferences(preferencePageId=org.eclipse.help.ui.contentPreferencePage)\")'>" + WebappResources.getString("remotePreferencesMenuSelect", locale) + "</a>";
    }

    private String makeAnchor(String url, String title, String style, boolean newWindow) {
        String target = "";
        if (newWindow) {
            target = "target=\"_blank\" ";
        }
        return "<a " + style + " " + target + "href=\"" + url + "\">" + title + "</a>";
    }

    private static String tab(int count) {
        String tabs = "";
        int i = 0;
        while (i < count) {
            tabs = String.valueOf(tabs) + TAB;
            ++i;
        }
        return tabs;
    }

    private static InputStream getBytes(StringBuilder pageBuffer) {
        return new ByteArrayInputStream(pageBuffer.toString().getBytes(StandardCharsets.UTF_8));
    }
}

