/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class RepositoryGroupsMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator locator) {
        this.serviceLocator = locator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        ISelection selection = ((ISelectionService)this.serviceLocator.getService(ISelectionService.class)).getSelection();
        List<RepositoryNode> selectedRepoNodes = this.getRepositoryNodes(selection);
        List<File> selectedRepoDirectories = selectedRepoNodes.stream().map(node -> node.getRepository().getDirectory()).collect(Collectors.toList());
        if (!selectedRepoDirectories.isEmpty()) {
            RepositoryGroups groupsUtil = RepositoryGroups.getInstance();
            this.addStaticItems(groupsUtil, selectedRepoDirectories, result);
            List<RepositoryGroup> groups = this.getMoveTargetGroups(groupsUtil, selectedRepoNodes);
            if (!groups.isEmpty()) {
                result.add((IContributionItem)new Separator());
                for (RepositoryGroup group : groups) {
                    result.add(this.getAssignGroupItem(groupsUtil, group, selectedRepoDirectories));
                }
            }
        }
        return result.toArray(new IContributionItem[0]);
    }

    private List<RepositoryGroup> getMoveTargetGroups(RepositoryGroups groupsUtil, List<RepositoryNode> selection) {
        RepositoryTreeNode uniqueParent;
        List<RepositoryGroup> groups = groupsUtil.getGroups();
        Set repoNodeParents = selection.stream().map(RepositoryTreeNode::getParent).collect(Collectors.toSet());
        if (repoNodeParents.size() == 1 && (uniqueParent = (RepositoryTreeNode)repoNodeParents.iterator().next()) != null && uniqueParent instanceof RepositoryGroupNode) {
            RepositoryGroup parentGroup = (RepositoryGroup)((RepositoryGroupNode)uniqueParent).getObject();
            groups.remove(parentGroup);
        }
        Collections.sort(groups, (g1, g2) -> CommonUtils.STRING_ASCENDING_COMPARATOR.compare(g1.getName(), g2.getName()));
        return groups;
    }

    private void addStaticItems(final RepositoryGroups groupsUtil, final List<File> selectedRepoDirectories, List<IContributionItem> menu) {
        CommandContributionItemParameter createCommandParameters = new CommandContributionItemParameter(this.serviceLocator, null, "org.eclipse.egit.ui.RepositoriesCreateGroup", 8);
        createCommandParameters.label = UIText.RepositoriesView_RepoGroup_Create_MenuItemLabel;
        menu.add((IContributionItem)new CommandContributionItem(createCommandParameters));
        for (File repoDir : selectedRepoDirectories) {
            if (!groupsUtil.belongsToGroup(repoDir)) continue;
            menu.add((IContributionItem)new ActionContributionItem((IAction)new Action(UIText.RepositoriesView_RepoGroup_Remove_Title, UIIcons.REMOVE_FROM_REPO_GROUP){

                public void runWithEvent(Event event) {
                    groupsUtil.removeFromGroups(selectedRepoDirectories);
                    RepositoryGroupsMenu.this.refreshRepositoriesView();
                }
            }));
            break;
        }
    }

    private IContributionItem getAssignGroupItem(final RepositoryGroups groupsUtil, final RepositoryGroup group, final List<File> selectedRepoDirectories) {
        String actionTitle = NLS.bind((String)UIText.RepositoriesView_RepoGroup_Assign, (Object)group.getName());
        return new ActionContributionItem((IAction)new Action(actionTitle){

            public void runWithEvent(Event event) {
                groupsUtil.addRepositoriesToGroup(group, selectedRepoDirectories);
                RepositoryGroupsMenu.this.refreshRepositoriesView();
            }
        });
    }

    private List<RepositoryNode> getRepositoryNodes(ISelection selection) {
        ArrayList<RepositoryNode> result = new ArrayList<RepositoryNode>();
        if (selection instanceof StructuredSelection) {
            Object[] elements;
            Object[] objectArray = elements = ((StructuredSelection)selection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof RepositoryNode) {
                    result.add((RepositoryNode)element);
                }
                ++n2;
            }
        }
        return result;
    }

    private void refreshRepositoriesView() {
        RepositoriesView view = (RepositoriesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        view.refresh();
    }
}

