/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.QuickFixPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class QuickFixWizard
extends Wizard {
    private IMarker[] selectedMarkers;
    private Map<IMarkerResolution, Collection<IMarker>> resolutionMap;
    private String description;
    private IWorkbenchPartSite partSite;

    public QuickFixWizard(String description, IMarker[] selectedMarkers, Map<IMarkerResolution, Collection<IMarker>> resolutions, IWorkbenchPartSite site) {
        this.selectedMarkers = selectedMarkers;
        this.resolutionMap = resolutions;
        this.description = description;
        this.partSite = site;
        this.setDefaultPageImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_QUICKFIX_DLG"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new QuickFixPage(this.description, this.selectedMarkers, this.resolutionMap, this.partSite));
    }

    public boolean performFinish() {
        IRunnableWithProgress finishRunnable = mon -> {
            IWizardPage[] pages = this.getPages();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (String)MarkerMessages.MarkerResolutionDialog_Fixing, (int)(10 * pages.length + 1));
            subMonitor.worked(1);
            IWizardPage[] iWizardPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                this.getShell().getDisplay().readAndDispatch();
                QuickFixPage wizardPage = (QuickFixPage)page;
                wizardPage.performFinish((IProgressMonitor)subMonitor.split(10));
                ++n2;
            }
        };
        try {
            this.getContainer().run(false, true, finishRunnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newError(e));
            return false;
        }
        return true;
    }
}

