/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbMessages;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.IBreadcrumbDropDownSite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

class BreadcrumbItemDropDown
implements IBreadcrumbDropDownSite {
    private static final boolean IS_MAC_WORKAROUND = "carbon".equals(SWT.getPlatform());
    private static final int DROP_DOWN_MIN_WIDTH = 500;
    private static final int DROP_DOWN_MAX_WIDTH = 501;
    private static final int DROP_DOWN_DEFAULT_MIN_HEIGHT = 100;
    private static final int DROP_DOWN_DEFAULT_MAX_HEIGHT = 500;
    private static final String DIALOG_SETTINGS = "BreadcrumbItemDropDown";
    private static final String DIALOG_HEIGHT = "height";
    private static final String DIALOG_WIDTH = "width";
    private final BreadcrumbItem fParent;
    private final Composite fParentComposite;
    private final ToolBar fToolBar;
    private boolean fMenuIsShown;
    private boolean fEnabled;
    private Shell fShell;
    private boolean fIsResizingProgrammatically;
    private int fCurrentWidth = -1;
    private int fCurrentHeight = -1;

    public BreadcrumbItemDropDown(BreadcrumbItem parent, Composite composite) {
        this.fParent = parent;
        this.fParentComposite = composite;
        this.fMenuIsShown = false;
        this.fEnabled = true;
        this.fToolBar = new ToolBar(composite, 0x800000);
        this.fToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_toolTip;
            }
        });
        ToolBarManager manager = new ToolBarManager(this.fToolBar);
        final Action showDropDownMenuAction = new Action(null, 0){

            public void run() {
                Shell shell = BreadcrumbItemDropDown.this.fParent.getDropDownShell();
                if (shell != null) {
                    return;
                }
                shell = BreadcrumbItemDropDown.this.fParent.getViewer().getDropDownShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.close();
                }
                BreadcrumbItemDropDown.this.showMenu();
                BreadcrumbItemDropDown.this.fShell.setFocus();
            }
        };
        showDropDownMenuAction.setImageDescriptor((ImageDescriptor)new AccessibleArrowImage(this.isLeft()));
        showDropDownMenuAction.setToolTipText(BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_toolTip);
        manager.add((IAction)showDropDownMenuAction);
        manager.update(true);
        if (IS_MAC_WORKAROUND) {
            manager.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    showDropDownMenuAction.run();
                }
            });
        }
        this.fToolBar.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemDropDownToolBar");
    }

    public int getWidth() {
        return this.fToolBar.computeSize((int)-1, (int)-1).x;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.fToolBar.setVisible(enabled);
    }

    public boolean isMenuShown() {
        return this.fMenuIsShown;
    }

    public Shell getDropDownShell() {
        if (!this.isMenuShown()) {
            return null;
        }
        return this.fShell;
    }

    public void showMenu() {
        if (DebugUIPlugin.DEBUG_BREADCRUMB) {
            DebugUIPlugin.trace("BreadcrumbItemDropDown.showMenu()");
        }
        if (!this.fEnabled || this.fMenuIsShown) {
            return;
        }
        this.fMenuIsShown = true;
        this.fShell = new Shell(this.fToolBar.getShell(), 16404);
        if (DebugUIPlugin.DEBUG_BREADCRUMB) {
            DebugUIPlugin.trace("\tcreating new shell");
        }
        this.fShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (BreadcrumbItemDropDown.this.fIsResizingProgrammatically) {
                    return;
                }
                Point size = BreadcrumbItemDropDown.this.fShell.getSize();
                BreadcrumbItemDropDown.this.fCurrentWidth = size.x;
                BreadcrumbItemDropDown.this.fCurrentHeight = size.y;
                BreadcrumbItemDropDown.this.getDialogSettings().put(BreadcrumbItemDropDown.DIALOG_WIDTH, size.x);
                BreadcrumbItemDropDown.this.getDialogSettings().put(BreadcrumbItemDropDown.DIALOG_HEIGHT, size.y);
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fShell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this.fShell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        TreePath path = this.fParent.getPath();
        Control control = this.fParent.getViewer().createDropDown(composite, this, path);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setShellBounds(this.fShell);
        this.fShell.setVisible(true);
        this.installCloser(this.fShell);
    }

    private void installCloser(final Shell shell) {
        final Listener focusListener = new Listener(){

            public void handleEvent(Event event) {
                Widget focusElement = event.widget;
                boolean isFocusBreadcrumbTreeFocusWidget = focusElement == shell || focusElement instanceof Control && ((Control)focusElement).getShell() == shell;
                boolean isFocusWidgetParentShell = focusElement instanceof Control && ((Control)focusElement).getShell().getParent() == shell;
                switch (event.type) {
                    case 15: {
                        if (DebugUIPlugin.DEBUG_BREADCRUMB) {
                            DebugUIPlugin.trace("focusIn - is breadcrumb tree: " + isFocusBreadcrumbTreeFocusWidget);
                        }
                        if (isFocusBreadcrumbTreeFocusWidget || isFocusWidgetParentShell) break;
                        if (DebugUIPlugin.DEBUG_BREADCRUMB) {
                            DebugUIPlugin.trace("==> closing shell since focus in other widget");
                        }
                        shell.close();
                        break;
                    }
                    case 16: {
                        if (DebugUIPlugin.DEBUG_BREADCRUMB) {
                            DebugUIPlugin.trace("focusOut - is breadcrumb tree: " + isFocusBreadcrumbTreeFocusWidget);
                        }
                        if (event.display.getActiveShell() != null) break;
                        if (DebugUIPlugin.DEBUG_BREADCRUMB) {
                            DebugUIPlugin.trace("==> closing shell since event.display.getActiveShell() != shell");
                        }
                        shell.close();
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
            }
        };
        final Display display = shell.getDisplay();
        display.addFilter(15, focusListener);
        display.addFilter(16, focusListener);
        final ControlListener controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!shell.isDisposed()) {
                    shell.close();
                }
            }

            public void controlResized(ControlEvent e) {
                if (!shell.isDisposed()) {
                    shell.close();
                }
            }
        };
        this.fToolBar.getShell().addControlListener(controlListener);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DebugUIPlugin.DEBUG_BREADCRUMB) {
                    DebugUIPlugin.trace("==> shell disposed");
                }
                display.removeFilter(15, focusListener);
                display.removeFilter(16, focusListener);
                if (!BreadcrumbItemDropDown.this.fToolBar.isDisposed()) {
                    BreadcrumbItemDropDown.this.fToolBar.getShell().removeControlListener(controlListener);
                }
            }
        });
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                if (DebugUIPlugin.DEBUG_BREADCRUMB) {
                    DebugUIPlugin.trace("==> shellClosed");
                }
                if (!BreadcrumbItemDropDown.this.fMenuIsShown) {
                    return;
                }
                BreadcrumbItemDropDown.this.fMenuIsShown = false;
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings javaSettings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = javaSettings.getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = javaSettings.addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    private int getMaxWidth() {
        try {
            return this.getDialogSettings().getInt(DIALOG_WIDTH);
        }
        catch (NumberFormatException numberFormatException) {
            return 501;
        }
    }

    private int getMaxHeight() {
        try {
            return this.getDialogSettings().getInt(DIALOG_HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {
            return 500;
        }
    }

    private void setShellBounds(Shell shell) {
        Rectangle rect = this.fParentComposite.getBounds();
        Rectangle toolbarBounds = this.fToolBar.getBounds();
        Point size = shell.computeSize(-1, -1, false);
        int height = Math.max(Math.min(size.y, this.getMaxHeight()), 100);
        int width = Math.max(this.getMaxWidth(), 500);
        int imageBoundsX = 0;
        if (this.fParent.getImage() != null) {
            imageBoundsX = this.fParent.getImage().getImageData().width;
        }
        Rectangle trim = this.fShell.computeTrim(0, 0, width, height);
        int x = toolbarBounds.x + toolbarBounds.width + 2 + trim.x - imageBoundsX;
        if (!this.isLeft()) {
            x += width;
        }
        int y = rect.y;
        y = this.isTop() ? (y += rect.height) : (y -= height);
        Point pt = new Point(x, y);
        pt = this.fParentComposite.toDisplay(pt);
        Rectangle monitor = Util.getClosestMonitor((Display)shell.getDisplay(), (Point)pt).getClientArea();
        int overlap = pt.x + width - (monitor.x + monitor.width);
        if (overlap > 0) {
            pt.x -= overlap;
        }
        if (pt.x < monitor.x) {
            pt.x = monitor.x;
        }
        shell.setLocation(pt);
        this.fIsResizingProgrammatically = true;
        try {
            shell.setSize(width, height);
            this.fCurrentWidth = width;
            this.fCurrentHeight = height;
        }
        finally {
            this.fIsResizingProgrammatically = false;
        }
    }

    private void resizeShell(Shell shell) {
        int maxHeight = this.getMaxHeight();
        int maxWidth = this.getMaxWidth();
        if (this.fCurrentHeight >= maxHeight && this.fCurrentWidth >= maxWidth) {
            return;
        }
        Point preferedSize = shell.computeSize(-1, -1, true);
        int newWidth = this.fCurrentWidth >= 501 ? this.fCurrentWidth : Math.min(Math.max(Math.max(preferedSize.x, this.fCurrentWidth), 500), maxWidth);
        int newHeight = this.fCurrentHeight >= maxHeight ? this.fCurrentHeight : Math.min(Math.max(preferedSize.y, this.fCurrentHeight), maxHeight);
        if (newHeight != this.fCurrentHeight || newWidth != this.fCurrentWidth) {
            shell.setRedraw(false);
            try {
                Point location;
                this.fIsResizingProgrammatically = true;
                shell.setSize(newWidth, newHeight);
                this.fCurrentWidth = newWidth;
                this.fCurrentHeight = newHeight;
                Point newLocation = location = shell.getLocation();
                if (!this.isLeft()) {
                    newLocation = new Point(newLocation.x - (newWidth - this.fCurrentWidth), newLocation.y);
                }
                if (!this.isTop()) {
                    newLocation = new Point(newLocation.x, newLocation.y - (newHeight - this.fCurrentHeight));
                }
                if (!location.equals((Object)newLocation)) {
                    shell.setLocation(newLocation.x, newLocation.y);
                }
            }
            finally {
                this.fIsResizingProgrammatically = false;
                shell.setRedraw(true);
            }
        }
    }

    private boolean isLeft() {
        return (this.fParentComposite.getStyle() & 0x4000000) == 0 && (this.fParent.getViewer().getStyle() & 0x20000) == 0;
    }

    private boolean isTop() {
        return (this.fParent.getViewer().getStyle() & 0x400) == 0;
    }

    @Override
    public void close() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.close();
        }
    }

    @Override
    public void notifySelection(ISelection selection) {
        this.fParent.getViewer().fireMenuSelection(selection);
    }

    @Override
    public void updateSize() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.resizeShell(this.fShell);
        }
    }

    private final class AccessibleArrowImage
    extends CompositeImageDescriptor {
        private static final int ARROW_SIZE = 5;
        private final boolean fLTR;

        public AccessibleArrowImage(boolean ltr) {
            this.fLTR = ltr;
        }

        protected void drawCompositeImage(int width, int height) {
            Display display = BreadcrumbItemDropDown.this.fParentComposite.getDisplay();
            ImageDataProvider imageProvider = zoom -> {
                Image image = new Image((Device)display, 5, 10);
                GC gc = new GC((Drawable)image, this.fLTR ? 0x2000000 : 0x4000000);
                gc.setAntialias(1);
                Color triangleColor = this.createColor(24, 25, 20, display);
                gc.setBackground(triangleColor);
                int[] nArray = new int[6];
                nArray[2] = 5;
                nArray[3] = 5;
                nArray[5] = 10;
                gc.fillPolygon(nArray);
                gc.dispose();
                triangleColor.dispose();
                ImageData imageData = image.getImageData(zoom);
                image.dispose();
                int zoomedArrowSize = 5 * zoom / 100;
                int y1 = 0;
                while (y1 < zoomedArrowSize) {
                    int x1 = 0;
                    while (x1 <= y1) {
                        imageData.setAlpha(this.fLTR ? x1 : zoomedArrowSize - x1 - 1, y1, 255);
                        ++x1;
                    }
                    ++y1;
                }
                int y2 = 0;
                while (y2 < zoomedArrowSize) {
                    int x2 = 0;
                    while (x2 <= y2) {
                        imageData.setAlpha(this.fLTR ? x2 : zoomedArrowSize - x2 - 1, zoomedArrowSize * 2 - y2 - 1, 255);
                        ++x2;
                    }
                    ++y2;
                }
                return imageData;
            };
            this.drawImage(imageProvider, width / 2 - 2, height / 2 - 5);
        }

        protected Point getSize() {
            return new Point(10, 16);
        }

        private Color createColor(int color1, int color2, int ratio, Display display) {
            RGB rgb1 = display.getSystemColor(color1).getRGB();
            RGB rgb2 = display.getSystemColor(color2).getRGB();
            RGB blend = BreadcrumbViewer.blend(rgb2, rgb1, ratio);
            return new Color((Device)display, blend);
        }
    }
}

