/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.StashDropOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class StashDropHandler
extends SelectionHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.StashDrop";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int stashIndex;
        RevCommit commit = this.getSelectedItem(RevCommit.class, event);
        if (commit == null) {
            return null;
        }
        Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        Shell parent = this.getPart(event).getSite().getShell();
        if (!this.confirmStashDrop(parent, stashIndex = this.getStashIndex(repo, commit.getId()), commit.getShortMessage())) {
            return null;
        }
        final StashDropOperation op = new StashDropOperation(repo, stashIndex);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.StashDropCommand_jobTitle, commit.name())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    Activator.logError(MessageFormat.format(UIText.StashDropCommand_dropFailed, "stash@{" + stashIndex + "}"), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        final IWorkbenchPart part = this.getPart(event);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && part instanceof CommitEditor) {
                    ((CommitEditor)part).close(false);
                }
            }
        });
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private int getStashIndex(Repository repo, ObjectId id) throws ExecutionException {
        int index = 0;
        try {
            for (RevCommit commit : Git.wrap((Repository)repo).stashList().call()) {
                if (commit.getId().equals((AnyObjectId)id)) {
                    return index;
                }
                ++index;
            }
            throw new IllegalStateException(MessageFormat.format(UIText.StashDropCommand_stashCommitNotFound, id.name()));
        }
        catch (Exception e) {
            String message = MessageFormat.format(UIText.StashDropCommand_dropFailed, id.name());
            Activator.showError(message, e);
            throw new ExecutionException(message, (Throwable)e);
        }
    }

    private boolean confirmStashDrop(final Shell shell, final int stashIndex, final String commitMessage) {
        final AtomicBoolean confirmed = new AtomicBoolean(false);
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String message = MessageFormat.format(UIText.StashDropCommand_confirmSingle, Integer.toString(stashIndex), commitMessage);
                String[] buttonLabels = new String[]{UIText.StashDropCommand_buttonDelete, IDialogConstants.CANCEL_LABEL};
                MessageDialog confirmDialog = new MessageDialog(shell, UIText.StashDropCommand_confirmTitle, null, message, 5, buttonLabels, 0);
                confirmed.set(confirmDialog.open() == 0);
            }
        });
        return confirmed.get();
    }
}

