/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.Q7ElementContainer;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.model.Finder;
import org.eclipse.rcptt.ui.editors.ecl.ECLEditorPlugin;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class MarkAllOccurencesJob
extends Job {
    private final ITextSelection selection;
    private boolean isCanceled = false;
    private final EclEditor eclEditor;

    public MarkAllOccurencesJob(ITextSelection selection, EclEditor eclEditor) {
        super("ECL_EDITOR_MARK_ALL_OCCURENCES_JOB");
        this.selection = selection;
        this.eclEditor = eclEditor;
    }

    void doCancel() {
        this.isCanceled = true;
        this.cancel();
    }

    private boolean isCanceled(IProgressMonitor progressMonitor) {
        return this.isCanceled || progressMonitor.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor progressMonitor) {
        if (this.isCanceled(progressMonitor)) {
            return Status.CANCEL_STATUS;
        }
        EclSourceViewer textViewer = this.eclEditor.getViewer();
        if (textViewer == null) {
            return Status.CANCEL_STATUS;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return Status.CANCEL_STATUS;
        }
        IDocumentProvider documentProvider = this.eclEditor.getDocumentProvider();
        if (documentProvider == null) {
            return Status.CANCEL_STATUS;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.eclEditor.getEditorInput());
        if (annotationModel == null) {
            return Status.CANCEL_STATUS;
        }
        int offset = this.selection.getOffset();
        Q7ElementContainer container = textViewer.getElementContainer();
        container.includeBuildins(true);
        container.setOffset(offset);
        Finder finder = new Finder(ECLEditorPlugin.getMarkSettings());
        Node[] locations = finder.find(container.script, container.offset, (IDeclContainer)container);
        int length = locations.length;
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
        int i = 0;
        while (i < length) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Position position = new Position(locations[i].begin, locations[i].length());
            annotationMap.put(new Annotation("org.eclipse.rcptt.ui.occurrences", false, ""), position);
            ++i;
        }
        if (this.isCanceled(progressMonitor)) {
            return Status.CANCEL_STATUS;
        }
        Object object = this.eclEditor.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                this.eclEditor.replaceOccurencesAnnotation(annotationModel, annotationMap);
            } else {
                this.eclEditor.removeOccurrenceAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.eclEditor.setOccurencesAnnotation(annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]));
        }
        return Status.OK_STATUS;
    }
}

