/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class FileImages {
    private Map<String, Image> cache = new HashMap<String, Image>();
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private Image defaultImage;

    public FileImages(Image defaultImage) {
        this.defaultImage = defaultImage;
    }

    public Image get(String filename) {
        Image image = this.cache.get(filename);
        if (image != null && !image.isDisposed()) {
            return image;
        }
        ImageDescriptor descriptor = this.registry.getImageDescriptor(filename);
        if (descriptor != null) {
            image = descriptor.createImage();
            this.cache.put(filename, image);
            return image;
        }
        return this.defaultImage;
    }

    public void dispose() {
        for (Image i : this.cache.values()) {
            i.dispose();
        }
    }
}

