/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.IndexBlobStorage;
import org.eclipse.egit.core.internal.storage.OpenWorkspaceVersionEnabled;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;

public class IndexFileRevision
extends GitFileRevision
implements OpenWorkspaceVersionEnabled {
    private static final int FIRST_AVAILABLE = -1;
    private final Repository db;
    private final String path;
    private final int stage;
    private ObjectId blobId;
    private DirCacheCheckout.CheckoutMetadata metadata;

    IndexFileRevision(Repository repo, String path) {
        this(repo, path, -1);
    }

    IndexFileRevision(Repository repo, String path, int stage) {
        super(path);
        this.db = repo;
        this.path = path;
        this.stage = stage;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            try {
                DirCache cache = this.db.readDirCache();
                this.blobId = this.locateBlobObjectId(cache);
                if (this.blobId != null) {
                    this.metadata = this.getMetadata(cache);
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.IndexFileRevision_errorLookingUpPath, (Object)this.path), e));
            }
        }
        return new IndexBlobStorage(this.db, this.path, this.blobId, this.metadata);
    }

    @Override
    public boolean isPropertyMissing() {
        return false;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return null;
    }

    public String getContentIdentifier() {
        return "Index";
    }

    private DirCacheCheckout.CheckoutMetadata getMetadata(DirCache cache) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TreeWalk walk = new TreeWalk(this.db);){
            walk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
            FileTreeIterator files = new FileTreeIterator(this.db);
            files.setDirCacheIterator(walk, 0);
            walk.addTree((AbstractTreeIterator)files);
            walk.setFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{this.path}), (TreeFilter)new NotIgnoredFilter(1)));
            walk.setRecursive(true);
            if (walk.next()) {
                return new DirCacheCheckout.CheckoutMetadata(walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP), walk.getFilterCommand("smudge"));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private ObjectId locateBlobObjectId(DirCache cache) {
        int firstIndex = cache.findEntry(this.path);
        if (firstIndex < 0) {
            return null;
        }
        DirCacheEntry firstEntry = cache.getEntry(firstIndex);
        if (this.stage == -1 || firstEntry.getStage() == this.stage) {
            return firstEntry.getObjectId();
        }
        int nextIndex = cache.nextEntry(firstIndex);
        int i = firstIndex;
        while (i < nextIndex) {
            DirCacheEntry entry = cache.getEntry(i);
            if (entry.getStage() == this.stage) {
                return entry.getObjectId();
            }
            ++i;
        }
        return null;
    }

    @Override
    public Repository getRepository() {
        return this.db;
    }

    @Override
    public String getGitPath() {
        return this.path;
    }
}

