/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.text.edits.TextEditGroup;

public class LambdaExpressionsFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static boolean fConversionRemovesAnnotations;

    public static LambdaExpressionsFixCore createConvertToLambdaFix(ClassInstanceCreation cic) {
        CompilationUnit root = (CompilationUnit)cic.getRoot();
        if (!JavaModelUtil.is18OrHigher(root.getJavaElement().getJavaProject())) {
            return null;
        }
        if (!LambdaExpressionsFixCore.isFunctionalAnonymous(cic)) {
            return null;
        }
        CreateLambdaOperation op = new CreateLambdaOperation(Collections.singletonList(cic));
        String message = fConversionRemovesAnnotations ? FixMessages.LambdaExpressionsFix_convert_to_lambda_expression_removes_annotations : FixMessages.LambdaExpressionsFix_convert_to_lambda_expression;
        return new LambdaExpressionsFixCore(message, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
    }

    public static IProposableFix createConvertToAnonymousClassCreationsFix(LambdaExpression lambda) {
        if (lambda.resolveTypeBinding() == null || lambda.resolveTypeBinding().getFunctionalInterfaceMethod() == null) {
            return null;
        }
        CreateAnonymousClassCreationOperation op = new CreateAnonymousClassCreationOperation(Collections.singletonList(lambda));
        CompilationUnit root = (CompilationUnit)lambda.getRoot();
        return new LambdaExpressionsFixCore(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
    }

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit, boolean useLambda, boolean useAnonymous) {
        if (!JavaModelUtil.is18OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        if (useLambda) {
            ArrayList<ClassInstanceCreation> convertibleNodes = FunctionalAnonymousClassesFinder.perform((ASTNode)compilationUnit);
            if (convertibleNodes.isEmpty()) {
                return null;
            }
            Collections.reverse(convertibleNodes);
            CreateLambdaOperation op = new CreateLambdaOperation(convertibleNodes);
            return new LambdaExpressionsFixCore(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
        }
        if (useAnonymous) {
            ArrayList<LambdaExpression> convertibleNodes = LambdaExpressionsFinder.perform((ASTNode)compilationUnit);
            if (convertibleNodes.isEmpty()) {
                return null;
            }
            Collections.reverse(convertibleNodes);
            CreateAnonymousClassCreationOperation op = new CreateAnonymousClassCreationOperation(convertibleNodes);
            return new LambdaExpressionsFixCore(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
        }
        return null;
    }

    public LambdaExpressionsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static boolean isFunctionalAnonymous(ClassInstanceCreation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding[] interfaces = typeBinding.getInterfaces();
        if (interfaces.length != 1) {
            return false;
        }
        if (interfaces[0].getFunctionalInterfaceMethod() == null) {
            return false;
        }
        AnonymousClassDeclaration anonymTypeDecl = node.getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return false;
        }
        List bodyDeclarations = anonymTypeDecl.bodyDeclarations();
        if (bodyDeclarations.size() != 1) {
            return false;
        }
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        if (!(bodyDeclaration instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)bodyDeclaration;
        IMethodBinding methodBinding = methodDecl.resolveBinding();
        if (methodBinding == null) {
            return false;
        }
        if (methodBinding.isGenericMethod()) {
            return false;
        }
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isSynchronized((int)modifiers) || Modifier.isStrictfp((int)modifiers)) {
            return false;
        }
        if (SuperThisReferenceFinder.hasReference(methodDecl)) {
            return false;
        }
        if (ASTNodes.getTargetType((Expression)node) == null) {
            return false;
        }
        LambdaExpressionsFixCore.checkAnnotationsRemoval(methodBinding);
        return true;
    }

    public static void checkAnnotationsRemoval(IMethodBinding methodBinding) {
        IAnnotationBinding[] declarationAnnotations;
        fConversionRemovesAnnotations = false;
        IAnnotationBinding[] iAnnotationBindingArray = declarationAnnotations = methodBinding.getAnnotations();
        int n = declarationAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifiedName;
            IAnnotationBinding declarationAnnotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = declarationAnnotation.getAnnotationType();
            if (annotationType != null && !"java.lang.Override".equals(qualifiedName = annotationType.getQualifiedName()) && !"java.lang.Deprecated".equals(qualifiedName)) {
                fConversionRemovesAnnotations = true;
                return;
            }
            ++n2;
        }
    }

    public static class AbortSearchException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static final class AnnotationsFinder
    extends ASTVisitor {
        public static boolean hasAnnotations(SingleVariableDeclaration methodParameter) {
            try {
                AnnotationsFinder finder = new AnnotationsFinder();
                methodParameter.accept((ASTVisitor)finder);
            }
            catch (AbortSearchException abortSearchException) {
                return true;
            }
            return false;
        }

        public boolean visit(MarkerAnnotation node) {
            throw new AbortSearchException();
        }

        public boolean visit(NormalAnnotation node) {
            throw new AbortSearchException();
        }

        public boolean visit(SingleMemberAnnotation node) {
            throw new AbortSearchException();
        }
    }

    public static class CreateAnonymousClassCreationOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation
    implements IAnonymousClassCreationOperation {
        private final List<LambdaExpression> fExpressions;

        public CreateAnonymousClassCreationOperation(List<LambdaExpression> changedNodes) {
            this.fExpressions = changedNodes;
        }

        @Override
        public MethodDeclaration getMethodDeclaration(ICompilationUnit cu, ASTRewrite rewrite, ImportRewrite rewrites, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String[] parameterNames, ITypeBinding targetType, boolean inInterface, ASTNode astNode) throws CoreException {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
            MethodDeclaration methodDeclaration = StubUtility2Core.createImplementationStubCore(cu, rewrite, rewrites, context, binding, parameterNames, targetType, settings, inInterface, astNode, false);
            return methodDeclaration;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            this.rewriteAST(this, cuRewrite, model);
        }

        public void rewriteAST(IAnonymousClassCreationOperation op, CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = rewrite.getAST();
            for (LambdaExpression lambdaExpression : this.fExpressions) {
                Block block;
                ASTNode lambdaBody;
                TextEditGroup group = this.createTextEditGroup(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, cuRewrite);
                ITypeBinding lambdaTypeBinding = lambdaExpression.resolveTypeBinding();
                IMethodBinding methodBinding = lambdaTypeBinding.getFunctionalInterfaceMethod();
                List parameters = lambdaExpression.parameters();
                String[] parameterNames = new String[parameters.size()];
                int i = 0;
                while (i < parameterNames.length) {
                    parameterNames[i] = ((VariableDeclaration)parameters.get(i)).getName().getIdentifier();
                    ++i;
                }
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext((ASTNode)lambdaExpression, importRewrite);
                MethodDeclaration methodDeclaration = op.getMethodDeclaration(cuRewrite.getCu(), rewrite, importRewrite, importContext, methodBinding, parameterNames, lambdaTypeBinding, false, (ASTNode)lambdaExpression);
                ASTNode parentType = ASTResolving.findParentType((ASTNode)lambdaExpression);
                ITypeBinding parentTypeBinding = null;
                if (parentType instanceof AbstractTypeDeclaration) {
                    parentTypeBinding = ((AbstractTypeDeclaration)parentType).resolveBinding();
                } else if (parentType instanceof AnonymousClassDeclaration) {
                    parentTypeBinding = ((AnonymousClassDeclaration)parentType).resolveBinding();
                }
                if (parentTypeBinding != null && (parentTypeBinding = Bindings.normalizeTypeBinding(parentTypeBinding)) != null) {
                    SuperThisQualifier.perform(lambdaExpression, parentTypeBinding.getTypeDeclaration(), cuRewrite, group);
                }
                if ((lambdaBody = lambdaExpression.getBody()) instanceof Block) {
                    block = (Block)ASTNodes.getCopyOrReplacement(rewrite, lambdaBody, group);
                } else {
                    block = ast.newBlock();
                    List statements = block.statements();
                    ITypeBinding returnType = methodBinding.getReturnType();
                    Expression copyTarget = (Expression)ASTNodes.getCopyOrReplacement(rewrite, lambdaBody, group);
                    if (Bindings.isVoidType(returnType)) {
                        ExpressionStatement newExpressionStatement = ast.newExpressionStatement(copyTarget);
                        statements.add(newExpressionStatement);
                    } else {
                        ReturnStatement returnStatement = ast.newReturnStatement();
                        returnStatement.setExpression(copyTarget);
                        statements.add(returnStatement);
                    }
                }
                methodDeclaration.setBody(block);
                AnonymousClassDeclaration anonymousClassDeclaration = ast.newAnonymousClassDeclaration();
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                bodyDeclarations.add(methodDeclaration);
                Type creationType = ASTNodeFactory.newCreationType(ast, lambdaTypeBinding, importRewrite, importContext);
                ClassInstanceCreation classInstanceCreation = ast.newClassInstanceCreation();
                classInstanceCreation.setType(creationType);
                classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
                LambdaExpression toReplace = lambdaExpression;
                if (lambdaExpression.getLocationInParent() == CastExpression.EXPRESSION_PROPERTY && lambdaTypeBinding.isEqualTo((IBinding)((CastExpression)lambdaExpression.getParent()).resolveTypeBinding())) {
                    toReplace = lambdaExpression.getParent();
                }
                rewrite.replace((ASTNode)toReplace, (ASTNode)classInstanceCreation, group);
            }
        }
    }

    public static class CreateLambdaOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<ClassInstanceCreation> fExpressions;

        public CreateLambdaOperation(List<ClassInstanceCreation> expressions) {
            this.fExpressions = expressions;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover importRemover = cuRewrite.getImportRemover();
            AST ast = rewrite.getAST();
            HashMap<ClassInstanceCreation, HashSet<String>> cicToNewNames = new HashMap<ClassInstanceCreation, HashSet<String>>();
            int i = 0;
            while (i < this.fExpressions.size()) {
                ClassInstanceCreation classInstanceCreation = this.fExpressions.get(i);
                TextEditGroup group = this.createTextEditGroup(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, cuRewrite);
                AnonymousClassDeclaration anonymTypeDecl = classInstanceCreation.getAnonymousClassDeclaration();
                List bodyDeclarations = anonymTypeDecl.bodyDeclarations();
                Object object = bodyDeclarations.get(0);
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)object;
                    HashSet<String> excludedNames = new HashSet<String>();
                    if (i != 0) {
                        for (ClassInstanceCreation convertedCic : this.fExpressions.subList(0, i)) {
                            if (!ASTNodes.isParent((ASTNode)convertedCic, (ASTNode)classInstanceCreation)) continue;
                            excludedNames.addAll((Collection)cicToNewNames.get(convertedCic));
                        }
                    }
                    HashSet<String> newNames = this.makeNamesUnique(excludedNames, methodDeclaration, rewrite, group);
                    cicToNewNames.put(classInstanceCreation, new HashSet<String>(newNames));
                    List methodParameters = methodDeclaration.parameters();
                    boolean createExplicitlyTypedParameters = false;
                    for (SingleVariableDeclaration methodParameter : methodParameters) {
                        if (!AnnotationsFinder.hasAnnotations(methodParameter)) continue;
                        createExplicitlyTypedParameters = true;
                        break;
                    }
                    LambdaExpression lambdaExpression = ast.newLambdaExpression();
                    List lambdaParameters = lambdaExpression.parameters();
                    lambdaExpression.setParentheses(createExplicitlyTypedParameters || methodParameters.size() != 1);
                    for (SingleVariableDeclaration methodParameter : methodParameters) {
                        if (createExplicitlyTypedParameters) {
                            lambdaParameters.add((SingleVariableDeclaration)rewrite.createCopyTarget((ASTNode)methodParameter));
                            importRemover.registerRetainedNode((ASTNode)methodParameter);
                            continue;
                        }
                        VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
                        lambdaParameter.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodParameter.getName()));
                        lambdaParameters.add(lambdaParameter);
                    }
                    Block body = methodDeclaration.getBody();
                    List statements = body.statements();
                    Block lambdaBody = body;
                    if (statements.size() == 1) {
                        Expression returnExpression;
                        Statement statement = (Statement)statements.get(0);
                        if (statement instanceof ExpressionStatement) {
                            lambdaBody = ((ExpressionStatement)statement).getExpression();
                        } else if (statement instanceof ReturnStatement && (returnExpression = ((ReturnStatement)statement).getExpression()) != null) {
                            lambdaBody = returnExpression;
                        }
                    }
                    lambdaExpression.setBody(ASTNodes.getCopyOrReplacement(rewrite, (ASTNode)lambdaBody, group));
                    LambdaExpression replacement = lambdaExpression;
                    ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)classInstanceCreation);
                    if (ASTNodes.isTargetAmbiguous((Expression)classInstanceCreation, ASTNodes.isExplicitlyTypedLambda((Expression)lambdaExpression)) || targetTypeBinding.getFunctionalInterfaceMethod() == null) {
                        CastExpression cast = ast.newCastExpression();
                        cast.setExpression((Expression)lambdaExpression);
                        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)classInstanceCreation, importRewrite);
                        Type castType = importRewrite.addImport(classInstanceCreation.getType().resolveBinding(), ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.CAST);
                        cast.setType(castType);
                        importRemover.registerAddedImports(castType);
                        replacement = cast;
                    }
                    rewrite.replace((ASTNode)classInstanceCreation, (ASTNode)replacement, group);
                    importRemover.registerRemovedNode((ASTNode)classInstanceCreation);
                    importRemover.registerRetainedNode((ASTNode)lambdaBody);
                }
                ++i;
            }
        }

        private HashSet<String> makeNamesUnique(HashSet<String> excludedNames, MethodDeclaration methodDeclaration, ASTRewrite rewrite, TextEditGroup group) {
            HashSet<String> newNames = new HashSet<String>();
            excludedNames.addAll(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodDeclaration));
            List<SimpleName> simpleNamesInMethod = this.getNamesInMethod(methodDeclaration);
            ArrayList<String> namesInMethod = new ArrayList<String>();
            for (SimpleName name : simpleNamesInMethod) {
                namesInMethod.add(name.getIdentifier());
            }
            int i = 0;
            while (i < simpleNamesInMethod.size()) {
                SimpleName name = simpleNamesInMethod.get(i);
                String identifier = (String)namesInMethod.get(i);
                HashSet<String> allNamesToExclude = this.getNamesToExclude(excludedNames, namesInMethod, i);
                if (allNamesToExclude.contains(identifier)) {
                    SimpleName[] references;
                    String newIdentifier = this.createName(identifier, allNamesToExclude);
                    excludedNames.add(newIdentifier);
                    newNames.add(newIdentifier);
                    SimpleName[] simpleNameArray = references = LinkedNodeFinder.findByNode(name.getRoot(), name);
                    int n = references.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SimpleName ref = simpleNameArray[n2];
                        rewrite.set((ASTNode)ref, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)newIdentifier, group);
                        ++n2;
                    }
                }
                ++i;
            }
            return newNames;
        }

        private HashSet<String> getNamesToExclude(HashSet<String> excludedNames, List<String> namesInMethod, int i) {
            HashSet<String> allNamesToExclude = new HashSet<String>(excludedNames);
            allNamesToExclude.addAll(namesInMethod.subList(0, i));
            allNamesToExclude.addAll(namesInMethod.subList(i + 1, namesInMethod.size()));
            return allNamesToExclude;
        }

        private List<SimpleName> getNamesInMethod(MethodDeclaration methodDeclaration) {
            class NamesCollector
            extends HierarchicalASTVisitor {
                private int fTypeCounter;
                private List<SimpleName> fNames = new ArrayList<SimpleName>();

                NamesCollector() {
                }

                @Override
                public boolean visit(AbstractTypeDeclaration node) {
                    if (this.fTypeCounter++ == 0) {
                        this.fNames.add(node.getName());
                    }
                    return true;
                }

                @Override
                public void endVisit(AbstractTypeDeclaration node) {
                    --this.fTypeCounter;
                }

                @Override
                public boolean visit(AnonymousClassDeclaration node) {
                    ++this.fTypeCounter;
                    return true;
                }

                @Override
                public void endVisit(AnonymousClassDeclaration node) {
                    --this.fTypeCounter;
                }

                @Override
                public boolean visit(VariableDeclaration node) {
                    if (this.fTypeCounter == 0) {
                        this.fNames.add(node.getName());
                    }
                    return true;
                }
            }
            NamesCollector namesCollector = new NamesCollector();
            methodDeclaration.accept((ASTVisitor)namesCollector);
            return namesCollector.fNames;
        }

        private String createName(String candidate, HashSet<String> excludedNames) {
            int i = 1;
            String result = candidate;
            while (excludedNames.contains(result)) {
                result = String.valueOf(candidate) + i++;
            }
            return result;
        }
    }

    public static final class FunctionalAnonymousClassesFinder
    extends ASTVisitor {
        private final ArrayList<ClassInstanceCreation> fNodes = new ArrayList();

        public static ArrayList<ClassInstanceCreation> perform(ASTNode node) {
            FunctionalAnonymousClassesFinder finder = new FunctionalAnonymousClassesFinder();
            node.accept((ASTVisitor)finder);
            return finder.fNodes;
        }

        public boolean visit(ClassInstanceCreation node) {
            if (LambdaExpressionsFixCore.isFunctionalAnonymous(node) && !fConversionRemovesAnnotations) {
                this.fNodes.add(node);
            }
            return true;
        }
    }

    public static interface IAnonymousClassCreationOperation {
        public MethodDeclaration getMethodDeclaration(ICompilationUnit var1, ASTRewrite var2, ImportRewrite var3, ImportRewrite.ImportRewriteContext var4, IMethodBinding var5, String[] var6, ITypeBinding var7, boolean var8, ASTNode var9) throws CoreException;
    }

    public static final class LambdaExpressionsFinder
    extends ASTVisitor {
        private final ArrayList<LambdaExpression> fNodes = new ArrayList();

        public static ArrayList<LambdaExpression> perform(ASTNode node) {
            LambdaExpressionsFinder finder = new LambdaExpressionsFinder();
            node.accept((ASTVisitor)finder);
            return finder.fNodes;
        }

        public boolean visit(LambdaExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.getFunctionalInterfaceMethod() != null) {
                this.fNodes.add(node);
            }
            return true;
        }
    }

    public static final class SuperThisQualifier
    extends HierarchicalASTVisitor {
        private ITypeBinding fQualifierTypeBinding;
        private ImportRewrite fImportRewrite;
        private ASTRewrite fASTRewrite;
        private TextEditGroup fGroup;

        public static void perform(LambdaExpression lambdaExpression, ITypeBinding parentTypeBinding, CompilationUnitRewrite cuRewrite, TextEditGroup group) {
            SuperThisQualifier qualifier = new SuperThisQualifier();
            qualifier.fQualifierTypeBinding = parentTypeBinding;
            qualifier.fImportRewrite = cuRewrite.getImportRewrite();
            qualifier.fASTRewrite = cuRewrite.getASTRewrite();
            qualifier.fGroup = group;
            lambdaExpression.accept((ASTVisitor)qualifier);
        }

        public Name getQualifierTypeName() {
            String typeName = this.fImportRewrite.addImport(this.fQualifierTypeBinding);
            return this.fASTRewrite.getAST().newName(typeName);
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(BodyDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(SuperFieldAccess node) {
            if (node.getQualifier() == null) {
                this.fASTRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)SuperFieldAccess.QUALIFIER_PROPERTY, (Object)this.getQualifierTypeName(), this.fGroup);
            }
            return true;
        }

        @Override
        public boolean visit(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                this.fASTRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)SuperMethodInvocation.QUALIFIER_PROPERTY, (Object)this.getQualifierTypeName(), this.fGroup);
            }
            return true;
        }

        @Override
        public boolean visit(ThisExpression node) {
            if (node.getQualifier() == null) {
                this.fASTRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)ThisExpression.QUALIFIER_PROPERTY, (Object)this.getQualifierTypeName(), this.fGroup);
            }
            return true;
        }
    }

    public static final class SuperThisReferenceFinder
    extends HierarchicalASTVisitor {
        private ITypeBinding fFunctionalInterface;
        private MethodDeclaration fMethodDeclaration;

        static boolean hasReference(MethodDeclaration node) {
            try {
                SuperThisReferenceFinder finder = new SuperThisReferenceFinder();
                ClassInstanceCreation cic = (ClassInstanceCreation)node.getParent().getParent();
                finder.fFunctionalInterface = cic.getType().resolveBinding();
                finder.fMethodDeclaration = node;
                node.accept((ASTVisitor)finder);
            }
            catch (AbortSearchException abortSearchException) {
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(BodyDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(MethodDeclaration node) {
            return node == this.fMethodDeclaration;
        }

        @Override
        public boolean visit(ThisExpression node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            return true;
        }

        @Override
        public boolean visit(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            IBinding qualifierType = node.getQualifier().resolveBinding();
            if (qualifierType instanceof ITypeBinding && ((ITypeBinding)qualifierType).isInterface()) {
                throw new AbortSearchException();
            }
            return true;
        }

        @Override
        public boolean visit(SuperFieldAccess node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            return true;
        }

        @Override
        public boolean visit(MethodInvocation node) {
            IMethodBinding binding = node.resolveMethodBinding();
            if (binding != null && !JdtFlags.isStatic(binding) && node.getExpression() == null && Bindings.isSuperType(binding.getDeclaringClass(), this.fFunctionalInterface, false)) {
                throw new AbortSearchException();
            }
            return true;
        }
    }
}

