/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.urischeme.internal.registration.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PlistFileWriter {
    private static final String XPATH_PLIST_DICT_CF_BUNDLE_URL_TYPES_KEY = "/plist/dict/key[text()=\"CFBundleURLTypes\"]";
    private static final String XPATH_PLIST_DICT_CF_BUNDLE_URL_TYPES_ARRAY = "/plist/dict/key[text()=\"CFBundleURLTypes\"]/following-sibling::array";
    private static final String ELEMENT_NAME_KEY = "key";
    private static final String ELEMENT_NAME_ARRAY = "array";
    private static final String ELEMENT_NAME_STRING = "string";
    private static final String ELEMENT_NAME_DICT = "dict";
    private static final String KEY_VALUE_CF_BUNDLE_URL_TYPES = "CFBundleURLTypes";
    private static final String KEY_VALUE_CF_BUNDLE_URL_NAME = "CFBundleURLName";
    private static final String KEY_VALUE_CF_BUNDLE_URL_SCHEMES = "CFBundleURLSchemes";
    private Document document;
    private Element array;

    public PlistFileWriter(Reader reader) {
        this.document = this.getDom(reader);
        this.array = this.getOrCreateBundleUrlTypesAndArray();
    }

    public List<String> getRegisteredSchemes(Collection<String> schemes) {
        Predicate<String> matchingSchemes = scheme -> {
            Util.assertUriSchemeIsLegal(scheme);
            return this.getExistingElementFor((String)scheme) != null;
        };
        return schemes.stream().filter(matchingSchemes).collect(Collectors.toList());
    }

    public void addScheme(String scheme, String schemeDescription) {
        Util.assertUriSchemeIsLegal(scheme);
        if (this.getExistingElementFor(scheme) != null) {
            return;
        }
        this.addIndent(this.array, 3);
        Element dictInArray = this.addChildNode(this.array, ELEMENT_NAME_DICT, null);
        this.addIndent(dictInArray, 4);
        this.addChildNode(dictInArray, ELEMENT_NAME_KEY, KEY_VALUE_CF_BUNDLE_URL_NAME);
        this.addIndent(dictInArray, 5);
        this.addChildNode(dictInArray, ELEMENT_NAME_STRING, schemeDescription);
        this.addIndent(dictInArray, 4);
        this.addChildNode(dictInArray, ELEMENT_NAME_KEY, KEY_VALUE_CF_BUNDLE_URL_SCHEMES);
        this.addIndent(dictInArray, 5);
        Element schemeArray = this.addChildNode(dictInArray, ELEMENT_NAME_ARRAY, null);
        this.addIndent(schemeArray, 6);
        this.addChildNode(schemeArray, ELEMENT_NAME_STRING, scheme);
        this.addIndent(schemeArray, 5);
        this.addIndent(dictInArray, 3);
    }

    public void removeScheme(String scheme) {
        Util.assertUriSchemeIsLegal(scheme);
        Element dict = this.getExistingElementFor(scheme);
        if (dict == null) {
            return;
        }
        Node arrayNode = dict.getParentNode();
        this.removeTextNode(arrayNode, dict.getPreviousSibling());
        arrayNode.removeChild(dict);
    }

    public void writeTo(Writer writer) {
        boolean hasDict = false;
        int i = 0;
        while (i < this.array.getChildNodes().getLength()) {
            Node child = this.array.getChildNodes().item(i);
            if (ELEMENT_NAME_DICT.equals(child.getNodeName())) {
                hasDict = true;
                break;
            }
            ++i;
        }
        if (!hasDict) {
            Element keyNode = this.evaluateXpathOnElement(this.document, XPATH_PLIST_DICT_CF_BUNDLE_URL_TYPES_KEY);
            if (keyNode != null) {
                keyNode.getParentNode().removeChild(keyNode);
                this.array.getParentNode().removeChild(this.array);
            }
        } else {
            this.addIndent(this.array, 2);
        }
        this.transformDocument(writer);
    }

    private void transformDocument(Writer writer) {
        try {
            try {
                DOMSource source = new DOMSource(this.document);
                TransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(writer));
            }
            catch (TransformerException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.close(writer);
        }
    }

    private Document getDom(Reader reader) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Document doc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = doc = builder.parse(new InputSource(reader));
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this.close(reader);
        }
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Element getOrCreateBundleUrlTypesAndArray() {
        Element arrayNode = this.evaluateXpathOnElement(this.document, XPATH_PLIST_DICT_CF_BUNDLE_URL_TYPES_ARRAY);
        if (arrayNode != null) {
            if (this.removeTextNode(arrayNode, arrayNode.getLastChild())) {
                this.addLineBreak(arrayNode);
            }
        } else {
            Element plistElement = this.document.getDocumentElement();
            NodeList dictElements = plistElement.getElementsByTagName(ELEMENT_NAME_DICT);
            if (dictElements.getLength() == 0) {
                throw new IllegalStateException("Top level 'DICT' element could not be found");
            }
            Node dictElement = dictElements.item(0);
            this.addIndent(dictElement, 1);
            this.addChildNode(dictElement, ELEMENT_NAME_KEY, KEY_VALUE_CF_BUNDLE_URL_TYPES);
            this.addIndent(dictElement, 2);
            arrayNode = this.addChildNode(dictElement, ELEMENT_NAME_ARRAY, null);
        }
        return arrayNode;
    }

    private boolean removeTextNode(Node parent, Node textNode) {
        if (textNode instanceof Text) {
            parent.removeChild(textNode);
            return true;
        }
        return false;
    }

    private Element addChildNode(Node parent, String name, String value) {
        Element newElement = this.document.createElement(name);
        if (value != null) {
            newElement.appendChild(this.document.createTextNode(value));
        } else {
            this.addLineBreak(newElement);
        }
        parent.appendChild(newElement);
        this.addLineBreak(parent);
        return newElement;
    }

    private void addLineBreak(Node node) {
        node.appendChild(this.document.createTextNode("\n"));
    }

    private void addIndent(Node node, int indent) {
        String text = "";
        int i = 0;
        while (i < indent) {
            text = String.valueOf(text) + "\t";
            ++i;
        }
        node.appendChild(this.document.createTextNode(text));
    }

    private Element getExistingElementFor(String scheme) {
        String xpathToSchemeDictElement = "/plist/dict/key[text()=\"CFBundleURLTypes\"]/following-sibling::array/dict/key[text()=\"CFBundleURLSchemes\"]/following-sibling::array/string[text()=\"" + scheme + "\"]/../..";
        return this.evaluateXpathOnElement(this.document, xpathToSchemeDictElement);
    }

    private Element evaluateXpathOnElement(Node node, String xpath) {
        try {
            XPathExpression xpathExpression = XPathFactory.newInstance().newXPath().compile(xpath);
            NodeList nodeList = (NodeList)xpathExpression.evaluate(node, XPathConstants.NODESET);
            return nodeList.getLength() == 0 ? null : (Element)nodeList.item(0);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }
}

