/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.internal.base.MissingContentManager;
import org.eclipse.help.internal.base.remote.RemoteStatusData;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class MissingContentPart
extends AbstractFormPart
implements IHelpPart {
    private Composite container;
    private String id;
    private ReusableHelpPart helpPart;
    private ImageHyperlink statusLink;
    private boolean wasRemoteHelpUnavailable = false;
    private boolean wasUnresolvedPlaceholders = false;

    public MissingContentPart(Composite parent, FormToolkit toolkit) {
        this.container = toolkit.createComposite(parent, 0);
        this.container.setBackgroundMode(1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginTop = 2;
        this.container.setLayout((Layout)layout);
        this.updateStatus();
    }

    public void updateStatus() {
        boolean isRemoteHelpUnavailable = RemoteStatusData.isAnyRemoteHelpUnavailable();
        if (isRemoteHelpUnavailable && this.wasRemoteHelpUnavailable) {
            return;
        }
        boolean isUnresolvedPlaceholders = MissingContentManager.getInstance().isUnresolvedPlaceholders();
        if (isRemoteHelpUnavailable == this.wasRemoteHelpUnavailable && isUnresolvedPlaceholders == this.wasUnresolvedPlaceholders) {
            return;
        }
        this.disposeLink();
        this.wasRemoteHelpUnavailable = isRemoteHelpUnavailable;
        this.wasUnresolvedPlaceholders = isUnresolvedPlaceholders;
        FormToolkit toolkit = new FormToolkit(this.container.getDisplay());
        if (isRemoteHelpUnavailable) {
            this.createHelpMissingLink(this.container, toolkit, "dialog_messasge_warning_image", Messages.remoteHelpUnavailable, MissingContentManager.getInstance().getRemoteHelpUnavailablePage(true), true);
        } else if (isUnresolvedPlaceholders) {
            this.createHelpMissingLink(this.container, toolkit, "dialog_messasge_info_image", Messages.ReusableHelpPart_missingContent, MissingContentManager.getInstance().getHelpMissingPage(true), false);
        }
        toolkit.dispose();
    }

    private void createHelpMissingLink(Composite container, FormToolkit toolkit, String imageKey, String linkText, String linkTarget, boolean isRemoteUnavailableLink) {
        final String target = linkTarget;
        final boolean isRemote = isRemoteUnavailableLink;
        Composite padding = new Composite(container, 0);
        GridData paddingData = new GridData();
        paddingData.heightHint = 2;
        padding.setLayoutData((Object)paddingData);
        toolkit.adapt(padding);
        Image warningImage = JFaceResources.getImage((String)imageKey);
        this.statusLink = toolkit.createImageHyperlink(container, 0);
        this.statusLink.setText(linkText);
        this.statusLink.setImage(warningImage);
        this.statusLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MissingContentPart.this.helpPart.showURL(target);
                if (isRemote) {
                    MissingContentPart.this.helpPart.checkRemoteStatus();
                } else {
                    MissingContentPart.this.helpPart.checkPlaceholderStatus();
                }
            }
        });
        GridData statusData = new GridData(1, 2, false, false);
        this.statusLink.setLayoutData((Object)statusData);
    }

    private void disposeLink() {
        if (this.statusLink != null) {
            this.statusLink.dispose();
        }
        this.statusLink = null;
    }

    public void setSubsequentPage(String subsequentPage) {
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.id = id;
        this.helpPart = parent;
    }

    @Override
    public void saveState(IMemento memento) {
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.container != null) {
            this.container.setVisible(visible);
        }
    }

    @Override
    public boolean hasFocusControl(Control control) {
        return false;
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    @Override
    public IAction getGlobalAction(String id) {
        return null;
    }

    @Override
    public void stop() {
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
    }

    public void dispose() {
        this.disposeLink();
    }
}

