/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.rename.Q7RenameProcessor;
import org.eclipse.rcptt.ui.refactoring.rename.RenameNamedElementInputPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Q7RenameResourceWizard
extends RefactoringWizard {
    public Q7RenameResourceWizard(IResource resource) {
        super((Refactoring)new RenameRefactoring((RenameProcessor)new Q7RenameProcessor(resource)), 4);
        this.setDefaultPageTitle(Messages.Q7RenameResourceWizard_PageTitle);
        this.setWindowTitle(Messages.Q7RenameResourceWizard_WindowTitle);
    }

    protected void addUserInputPages() {
        Q7RenameProcessor processor = (Q7RenameProcessor)((Object)this.getRefactoring().getAdapter(Q7RenameProcessor.class));
        if (processor.getNamedElement() != null) {
            this.addPage((IWizardPage)new RenameNamedElementInputPage(processor));
        } else {
            this.addPage((IWizardPage)new RenameResourceInputPage(processor));
        }
    }

    private static class RenameResourceInputPage
    extends UserInputWizardPage {
        private final Q7RenameProcessor fRefactoringProcessor;
        private Text fNameField;

        public RenameResourceInputPage(Q7RenameProcessor processor) {
            super("RenameResourceRefactoringInputPage");
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(Messages.Q7RenameResourceWizard_NewNameLabel);
            label.setLayoutData((Object)new GridData());
            this.fNameField = new Text(composite, 2048);
            this.fNameField.setText(this.fRefactoringProcessor.getNewResourceName());
            this.fNameField.setFont(composite.getFont());
            this.fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RenameResourceInputPage.this.validatePage();
                }
            });
            this.fNameField.selectAll();
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.fNameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text = this.fNameField.getText();
            RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(text, text);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            this.fRefactoringProcessor.setNewResourceName(this.fNameField.getText());
        }
    }
}

