/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;

@API(status=API.Status.INTERNAL, since="1.1")
public class LogRecordListener {
    private final List<LogRecord> logRecords = new ArrayList<LogRecord>();

    public void logRecordSubmitted(LogRecord logRecord) {
        this.logRecords.add(logRecord);
    }

    public Stream<LogRecord> stream() {
        return this.logRecords.stream();
    }

    public Stream<LogRecord> stream(Class<?> clazz) {
        if (clazz == null) {
            throw new JUnitException("Class must not be null");
        }
        return this.stream().filter(logRecord -> logRecord.getLoggerName().equals(clazz.getName()));
    }

    public Stream<LogRecord> stream(Class<?> clazz, Level level) {
        if (level == null) {
            throw new JUnitException("Level must not be null");
        }
        return this.stream(clazz).filter(logRecord -> logRecord.getLevel() == level);
    }

    public void clear() {
        this.logRecords.clear();
    }
}

