/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.TitleAndImageDialog;
import org.eclipse.egit.ui.internal.gerrit.GerritDialogSettings;
import org.eclipse.egit.ui.internal.push.RefSpecDialog;
import org.eclipse.egit.ui.internal.push.RefSpecWizard;
import org.eclipse.egit.ui.internal.repository.SelectUriWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractConfigureRemoteDialog
extends TitleAndImageDialog {
    protected static final int DRY_RUN = 98;
    protected static final int SAVE_ONLY = 97;
    protected static final int REVERT = 96;
    private final boolean isPush;
    private final Repository repository;
    private RemoteConfig config;
    private final boolean showBranchInfo;
    protected Text commonUriText;
    protected TableViewer specViewer;
    protected IAction changeCommonUriAction;
    protected IAction deleteCommonUriAction;
    protected IAction addRefSpecAction;
    protected IAction changeRefSpecAction;
    protected IAction addRefSpecAdvancedAction;

    protected AbstractConfigureRemoteDialog(Shell parent, Repository repository, RemoteConfig config, boolean showBranchInfo, boolean isPush) {
        super(parent, isPush ? UIIcons.WIZBAN_PUSH : UIIcons.WIZBAN_FETCH);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.config = config;
        this.showBranchInfo = showBranchInfo;
        this.isPush = isPush;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected RemoteConfig getConfig() {
        return this.config;
    }

    protected abstract void dryRun(IProgressMonitor var1);

    protected abstract void performOperation();

    protected abstract void createOkButton(Composite var1);

    protected abstract RefSpec getNewRefSpec();

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, -1).applyTo((Control)main);
        if (this.showBranchInfo) {
            String branch;
            Composite branchArea = new Composite(main, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(branchArea);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)branchArea);
            Label branchLabel = new Label(branchArea, 0);
            branchLabel.setText(UIText.AbstractConfigureRemoteDialog_BranchLabel);
            try {
                branch = this.getRepository().getBranch();
            }
            catch (IOException e) {
                branch = null;
            }
            if (branch == null || ObjectId.isId((String)branch)) {
                branch = UIText.AbstractConfigureRemoteDialog_DetachedHeadMessage;
            }
            Text branchText = new Text(branchArea, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)branchText);
            branchText.setText(branch);
            this.addDefaultOriginWarning(main);
        }
        Composite sameUriDetails = new Composite(main, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(false).applyTo(sameUriDetails);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sameUriDetails);
        Label commonUriLabel = new Label(sameUriDetails, 0);
        commonUriLabel.setText(UIText.AbstractConfigureRemoteDialog_UriLabel);
        this.commonUriText = new Text(sameUriDetails, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commonUriText);
        this.changeCommonUriAction = new Action(UIText.AbstractConfigureRemoteDialog_ChangeUriLabel){

            public void run() {
                SelectUriWizard wiz = !AbstractConfigureRemoteDialog.this.commonUriText.getText().isEmpty() ? new SelectUriWizard(true, AbstractConfigureRemoteDialog.this.commonUriText.getText()) : new SelectUriWizard(true);
                if (new WizardDialog(AbstractConfigureRemoteDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    if (!AbstractConfigureRemoteDialog.this.commonUriText.getText().isEmpty()) {
                        try {
                            AbstractConfigureRemoteDialog.this.getConfig().removeURI(new URIish(AbstractConfigureRemoteDialog.this.commonUriText.getText()));
                        }
                        catch (URISyntaxException ex) {
                            Activator.handleError(ex.getMessage(), ex, true);
                        }
                    }
                    AbstractConfigureRemoteDialog.this.getConfig().addURI(wiz.getUri());
                    AbstractConfigureRemoteDialog.this.updateControls();
                }
            }
        };
        this.deleteCommonUriAction = new Action(UIText.AbstractConfigureRemoteDialog_DeleteUriLabel){

            public void run() {
                AbstractConfigureRemoteDialog.this.getConfig().removeURI((URIish)AbstractConfigureRemoteDialog.this.getConfig().getURIs().get(0));
                AbstractConfigureRemoteDialog.this.updateControls();
            }
        };
        this.createActionButton(sameUriDetails, 8, this.changeCommonUriAction);
        this.createActionButton(sameUriDetails, 8, this.deleteCommonUriAction).setEnabled(false);
        this.commonUriText.addModifyListener(event -> this.deleteCommonUriAction.setEnabled(!this.commonUriText.getText().isEmpty()));
        this.createAdditionalUriArea(main);
        Group refSpecGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, -1).applyTo((Control)refSpecGroup);
        refSpecGroup.setText(UIText.AbstractConfigureRemoteDialog_RefMappingGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)refSpecGroup);
        this.specViewer = new TableViewer((Composite)refSpecGroup, 2050);
        this.specViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().hint(-1, 150).minSize(-1, 30).grab(true, true).applyTo((Control)this.specViewer.getTable());
        this.addRefSpecAction = new Action(UIText.AbstractConfigureRemoteDialog_AddRefSpecLabel){

            public void run() {
                AbstractConfigureRemoteDialog.this.doAddRefSpec();
            }
        };
        this.changeRefSpecAction = new Action(UIText.AbstractConfigureRemoteDialog_ChangeRefSpecLabel){

            public void run() {
                AbstractConfigureRemoteDialog.this.doChangeRefSpec();
            }
        };
        this.addRefSpecAdvancedAction = new Action(UIText.AbstractConfigureRemoteDialog_EditAdvancedLabel){

            public void run() {
                AbstractConfigureRemoteDialog.this.doAdvanced();
            }
        };
        final IAction deleteRefSpecAction = ActionUtils.createGlobalAction(ActionFactory.DELETE, () -> this.doDeleteRefSpecs());
        final IAction copyRefSpecAction = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> this.doCopy());
        IAction pasteRefSpecAction = ActionUtils.createGlobalAction(ActionFactory.PASTE, () -> this.doPaste());
        final IAction selectAllRefSpecsAction = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, () -> {
            this.specViewer.getTable().selectAll();
            this.specViewer.setSelection(this.specViewer.getSelection());
        });
        Composite buttonArea = new Composite((Composite)refSpecGroup, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonArea);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, -1).applyTo((Control)buttonArea);
        this.createActionButton(buttonArea, 8, this.addRefSpecAction);
        this.createActionButton(buttonArea, 8, this.changeRefSpecAction);
        this.createActionButton(buttonArea, 8, deleteRefSpecAction);
        this.createActionButton(buttonArea, 8, copyRefSpecAction);
        this.createActionButton(buttonArea, 8, pasteRefSpecAction);
        this.createActionButton(buttonArea, 8, this.addRefSpecAdvancedAction);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(manager -> {
            this.specViewer.getTable().setFocus();
            if (this.addRefSpecAction.isEnabled()) {
                manager.add(this.addRefSpecAction);
            }
            if (this.changeRefSpecAction.isEnabled()) {
                manager.add(this.changeRefSpecAction);
            }
            if (deleteRefSpecAction.isEnabled()) {
                manager.add(deleteRefSpecAction);
            }
            manager.add((IContributionItem)new Separator());
            manager.add(copyRefSpecAction);
            manager.add(pasteRefSpecAction);
            manager.add(selectAllRefSpecsAction);
        });
        this.specViewer.getTable().setMenu(contextMenu.createContextMenu((Control)this.specViewer.getTable()));
        ActionUtils.setGlobalActions((Control)this.specViewer.getTable(), deleteRefSpecAction, copyRefSpecAction, pasteRefSpecAction, selectAllRefSpecsAction);
        this.specViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AbstractConfigureRemoteDialog.this.specViewer.getSelection();
                copyRefSpecAction.setEnabled(sel.size() == 1);
                AbstractConfigureRemoteDialog.this.changeRefSpecAction.setEnabled(sel.size() == 1);
                deleteRefSpecAction.setEnabled(!sel.isEmpty());
                selectAllRefSpecsAction.setEnabled(AbstractConfigureRemoteDialog.this.specViewer.getTable().getItemCount() > 0 && sel.size() != AbstractConfigureRemoteDialog.this.specViewer.getTable().getItemCount());
            }
        });
        this.specViewer.addDoubleClickListener(event -> this.doChangeRefSpec());
        copyRefSpecAction.setEnabled(false);
        this.changeRefSpecAction.setEnabled(false);
        deleteRefSpecAction.setEnabled(false);
        AbstractConfigureRemoteDialog.applyDialogFont((Control)main);
        return main;
    }

    private void addDefaultOriginWarning(Composite parent) {
        String currentBranch;
        ArrayList<String> otherBranches = new ArrayList<String>();
        try {
            currentBranch = this.getRepository().getBranch();
        }
        catch (IOException e) {
            return;
        }
        String currentRemote = this.getConfig().getName();
        StoredConfig repositoryConfig = this.getRepository().getConfig();
        Set branches = repositoryConfig.getSubsections("branch");
        for (String branch : branches) {
            String remote;
            if (branch.equals(currentBranch) || ((remote = repositoryConfig.getString("branch", branch, "remote")) != null || !currentRemote.equals("origin")) && (remote == null || !remote.equals(currentRemote))) continue;
            otherBranches.add(branch);
        }
        if (otherBranches.isEmpty()) {
            return;
        }
        Composite warningAboutOrigin = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(warningAboutOrigin);
        Label warningLabel = new Label(warningAboutOrigin, 0);
        warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        Text warningText = new Text(warningAboutOrigin, 8);
        warningText.setText(NLS.bind((String)UIText.AbstractConfigureRemoteDialog_ReusedRemoteWarning, (Object)this.getConfig().getName(), (Object)otherBranches.size()));
        warningText.setToolTipText(((Object)otherBranches).toString());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)warningLabel);
    }

    private void addRefSpec(RefSpec spec) {
        if (this.isPush) {
            this.getConfig().addPushRefSpec(spec);
        } else {
            this.getConfig().addFetchRefSpec(spec);
        }
    }

    private void removeRefSpec(RefSpec spec) {
        if (this.isPush) {
            this.getConfig().removePushRefSpec(spec);
        } else {
            this.getConfig().removeFetchRefSpec(spec);
        }
    }

    protected Control createAdditionalUriArea(Composite parent) {
        return null;
    }

    protected abstract void updateControls();

    protected final void createButtonsForButtonBar(Composite parent) {
        this.createOkButton(parent);
        this.createButton(parent, 97, UIText.AbstractConfigureRemoteDialog_SaveButton, false);
        this.createButton(parent, 98, UIText.AbstractConfigureRemoteDialog_DryRunButton, false);
        this.createButton(parent, 96, UIText.AbstractConfigureRemoteDialog_RevertButton, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected final void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 98: {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, monitor -> this.dryRun(monitor));
                }
                catch (InvocationTargetException e) {
                    Activator.showError(e.getMessage(), e);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
            }
            case 96: {
                try {
                    this.config = new RemoteConfig((Config)this.repository.getConfig(), this.config.getName());
                    this.updateControls();
                }
                catch (URISyntaxException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
                return;
            }
            case 0: 
            case 97: {
                StoredConfig repoConfig = this.getRepository().getConfig();
                boolean saved = false;
                try {
                    this.config.update((Config)repoConfig);
                    repoConfig.save();
                    saved = true;
                }
                catch (IOException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
                if (saved) {
                    GerritDialogSettings.updateRemoteConfig(this.repository, this.config);
                }
                if (buttonId == 0) {
                    this.performOperation();
                }
                this.okPressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    private void doPaste() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            String content = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (content == null) {
                MessageDialog.openConfirm((Shell)this.getShell(), (String)UIText.AbstractConfigureRemoteDialog_EmptyClipboardDialogTitle, (String)UIText.AbstractConfigureRemoteDialog_EmptyClipboardDialogMessage);
            }
            try {
                Ref source;
                RefSpec spec = new RefSpec(content);
                try {
                    source = this.getRepository().findRef(this.isPush ? spec.getSource() : spec.getDestination());
                }
                catch (IOException e) {
                    source = null;
                }
                if (source != null || MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.AbstractConfigureRemoteDialog_InvalidRefDialogTitle, (String)NLS.bind((String)UIText.AbstractConfigureRemoteDialog_InvalidRefDialogMessage, (Object)spec.toString()))) {
                    this.addRefSpec(spec);
                }
                this.updateControls();
            }
            catch (IllegalArgumentException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)UIText.AbstractConfigureRemoteDialog_NoRefSpecDialogTitle, (String)UIText.AbstractConfigureRemoteDialog_NoRefSpecDialogMessage);
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private void doCopy() {
        String toCopy = ((IStructuredSelection)this.specViewer.getSelection()).getFirstElement().toString();
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            clipboard.setContents((Object[])new String[]{toCopy}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    private void doAddRefSpec() {
        RefSpec spec = this.getNewRefSpec();
        if (spec != null) {
            this.addRefSpec(spec);
            this.updateControls();
        }
    }

    private void doChangeRefSpec() {
        RefSpec oldSpec = (RefSpec)((IStructuredSelection)this.specViewer.getSelection()).getFirstElement();
        RefSpecDialog dlg = new RefSpecDialog(this.getShell(), this.getRepository(), this.getConfig(), oldSpec, this.isPush);
        if (dlg.open() == 0) {
            this.removeRefSpec(oldSpec);
            this.addRefSpec(dlg.getSpec());
        }
        this.updateControls();
    }

    private void doDeleteRefSpecs() {
        Object[] objectArray = ((IStructuredSelection)this.specViewer.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object spec = objectArray[n2];
            this.removeRefSpec((RefSpec)spec);
            ++n2;
        }
        this.updateControls();
    }

    private void doAdvanced() {
        RefSpecWizard wizard = new RefSpecWizard(this.getRepository(), this.getConfig(), this.isPush);
        if (new WizardDialog(this.getShell(), (IWizard)wizard).open() == 0) {
            this.updateControls();
        }
    }

    private Button createActionButton(Composite parent, int style, final IAction action) {
        Button button = new Button(parent, style);
        button.setText(action.getText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        IPropertyChangeListener listener = event -> {
            if ("enabled".equals(event.getProperty()) && !button.isDisposed()) {
                if (Display.getCurrent() == null) {
                    button.getShell().getDisplay().syncExec(() -> {
                        if (!button.isDisposed()) {
                            button.setEnabled(action.isEnabled());
                        }
                    });
                } else {
                    button.setEnabled(action.isEnabled());
                }
            }
        };
        button.addDisposeListener(event -> action.removePropertyChangeListener(listener));
        action.addPropertyChangeListener(listener);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        return button;
    }
}

