/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.properties.custom.CSSPropertyMruVisibleSWTHandler;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.BasicPartList;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.w3c.dom.css.CSSValue;

public class StackRenderer
extends LazyStackRenderer
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String THE_PART_KEY = "thePart";
    public static final String MRU_KEY_DEFAULT = "enableMRUDefault";
    public static final String MRU_KEY = "enableMRU";
    public static final String MRU_CONTROLLED_BY_CSS_KEY = "MRUControlledByCSS";
    public static final boolean MRU_DEFAULT = true;
    private static final boolean MRU_CONTROLLED_BY_CSS_DEFAULT = false;
    private static final String TAB_FONT_KEY = "org.eclipse.ui.workbench.TAB_TEXT_FONT";
    @Inject
    @Preference(nodePath="org.eclipse.e4.ui.workbench.renderers.swt")
    private IEclipsePreferences preferences;
    @Inject
    @Named(value="org.eclipse.e4.ui.workbench.renderers.swt.SHARED_ELEMENTS_STORE")
    Map<MUIElement, Set<MPlaceholder>> renderedMap;
    public static final String TAG_VIEW_MENU = "ViewMenu";
    private static final String SHELL_CLOSE_EDITORS_MENU = "shell_close_editors_menu";
    private static final String STACK_SELECTED_PART = "stack_selected_part";
    private static final String INHIBIT_FOCUS = "InhibitFocus";
    private static int MIN_VIEW_CHARS = 1;
    private static int MIN_EDITOR_CHARS = 15;
    private Image viewMenuImage;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IPresentationEngine renderer;
    private boolean ignoreTabSelChanges;
    private TabStateHandler tabStateHandler;
    boolean adjusting = false;

    List<CTabItem> getItemsToSet(MPart part) {
        ArrayList<CTabItem> itemsToSet = new ArrayList<CTabItem>();
        MElementContainer partParent = part.getParent();
        if (partParent instanceof MPartStack) {
            CTabItem item = this.findItemForPart(part);
            if (item != null) {
                itemsToSet.add(this.findItemForPart(part));
            }
        } else if (part.getCurSharedRef() != null) {
            MWindow topWin = this.modelService.getTopLevelWindowFor((MUIElement)part);
            List partRefs = this.modelService.findElements((MUIElement)topWin, part.getElementId(), MPlaceholder.class, null);
            for (MPlaceholder ref : partRefs) {
                CTabItem item = this.findItemForPart((MUIElement)ref, null);
                if (item == null) continue;
                itemsToSet.add(item);
            }
        }
        return itemsToSet;
    }

    @Inject
    @Optional
    private void subscribeTopicTransientDataChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") Event event) {
        Object changedElement = event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPart)) {
            return;
        }
        String key = UIEvents.isREMOVE((Event)event) ? (String)((Map.Entry)event.getProperty("OldValue")).getKey() : (String)((Map.Entry)event.getProperty("NewValue")).getKey();
        if (!"e4_override_icon_image_key".equals(key) && !"e4_override_title_tool_tip_key".equals(key)) {
            return;
        }
        MPart part = (MPart)changedElement;
        List<CTabItem> itemsToSet = this.getItemsToSet(part);
        for (CTabItem item : itemsToSet) {
            if (key.equals("e4_override_icon_image_key")) {
                item.setImage(this.getImage((MUILabel)part));
                continue;
            }
            if (!key.equals("e4_override_title_tool_tip_key")) continue;
            String newTip = this.getToolTip((MUILabel)part);
            item.setToolTipText(this.getToolTip(newTip));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        if (this.tabStateHandler == null) {
            this.tabStateHandler = new TabStateHandler();
        }
        this.tabStateHandler.handleEvent(event);
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPart)) {
            return;
        }
        MPart part = (MPart)changedObj;
        CTabItem item = this.findItemForPart(part);
        if (item == null || item.isDisposed()) {
            return;
        }
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"Pin Adornment")) {
                item.setImage(this.getImage((MUILabel)part));
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"Pin Adornment")) {
            item.setImage(this.getImage((MUILabel)part));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicChildrenChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        Object widget;
        MElementContainer parent;
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolBar)) {
            return;
        }
        MUIElement container = this.modelService.getContainer((MUIElement)changedObj);
        if (container instanceof MPart && (parent = ((MPart)container).getParent()) instanceof MPartStack && parent.getSelectedElement() == container && parent.getRenderer() == this && (widget = parent.getWidget()) instanceof CTabFolder) {
            this.adjustTopRight((CTabFolder)widget);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicUILabelChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UILabel/*") Event event) {
        MUIElement element = (MUIElement)event.getProperty("ChangedElement");
        if (!(element instanceof MPart)) {
            return;
        }
        MPart part = (MPart)element;
        String attName = (String)event.getProperty("AttName");
        Object newValue = event.getProperty("NewValue");
        if (element.getParent() != null && element.getParent().getRenderer() == this) {
            CTabItem cti = this.findItemForPart(part);
            if (cti != null) {
                this.updateTab(cti, part, attName, newValue);
            }
            return;
        }
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)part);
        List refs = this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, null);
        if (refs != null) {
            for (MPlaceholder ref : refs) {
                CTabItem cti;
                MElementContainer refParent;
                if (ref.getRef() != part || (refParent = ref.getParent()) == null || !(refParent.getRenderer() instanceof StackRenderer) || (cti = this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                this.updateTab(cti, part, attName, newValue);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicDirtyChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*") Event event) {
        Object objElement = event.getProperty("ChangedElement");
        if (!(objElement instanceof MPart)) {
            return;
        }
        MPart part = (MPart)objElement;
        this.updatePartTab(event, part);
    }

    @Inject
    @Optional
    private void subscribeTopicClosablePartChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/basic/Part/closeable/*") Event event) {
        this.updateClosableTab(event);
    }

    @Inject
    @Optional
    private void subscribeTopicClosablePlaceholderChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/advanced/Placeholder/closeable/*") Event event) {
        this.updateClosableTab(event);
    }

    private void updateClosableTab(Event event) {
        MUIElement ref;
        Object element = event.getProperty("ChangedElement");
        MPart part = null;
        if (element instanceof MPart) {
            part = (MPart)element;
        } else if (element instanceof MPlaceholder && (ref = ((MPlaceholder)element).getRef()) instanceof MPart) {
            part = (MPart)ref;
        }
        if (part == null) {
            return;
        }
        this.updatePartTab(event, part);
    }

    private void updatePartTab(Event event, MPart part) {
        String attName = (String)event.getProperty("AttName");
        Object newValue = event.getProperty("NewValue");
        MElementContainer parent = part.getParent();
        if (parent != null && parent.getRenderer() == this) {
            CTabItem cti = this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)parent);
            if (cti != null) {
                this.updateTab(cti, part, attName, newValue);
            }
            return;
        }
        Set<MPlaceholder> refs = this.renderedMap.get(part);
        if (refs != null) {
            for (MPlaceholder ref : refs) {
                CTabItem cti;
                MElementContainer refParent = ref.getParent();
                if (!(refParent.getRenderer() instanceof StackRenderer) || (cti = this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                this.updateTab(cti, part, attName, newValue);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicVisibleChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/visible/*") Event event) {
        this.shouldViewMenuBeRendered(event);
    }

    @Inject
    @Optional
    private void subscribeTopicToBeRenderedChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*") Event event) {
        this.shouldViewMenuBeRendered(event);
    }

    private void shouldViewMenuBeRendered(Event event) {
        Object widget;
        Object objElement = event.getProperty("ChangedElement");
        if (!(objElement instanceof MMenuElement)) {
            return;
        }
        MMenuElement menuModel = (MMenuElement)objElement;
        MUIElement menuParent = this.modelService.getContainer((MUIElement)menuModel);
        if (!(menuParent instanceof MPart)) {
            return;
        }
        MPart element = (MPart)menuParent;
        MElementContainer parentElement = element.getParent();
        if (parentElement == null) {
            MPlaceholder placeholder = element.getCurSharedRef();
            if (placeholder == null) {
                return;
            }
            parentElement = placeholder.getParent();
            if (parentElement == null) {
                return;
            }
        }
        if ((widget = parentElement.getWidget()) instanceof CTabFolder) {
            this.adjustTopRight((CTabFolder)widget);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicActivateChanged(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        MUIElement changed = (MUIElement)event.getProperty("ChangedElement");
        if (!(changed instanceof MPart)) {
            return;
        }
        MPart newActivePart = (MPart)changed;
        MElementContainer partParent = newActivePart.getParent();
        if (partParent == null && newActivePart.getCurSharedRef() != null) {
            partParent = newActivePart.getCurSharedRef().getParent();
        }
        while (partParent != null && partParent instanceof MPartSashContainer) {
            partParent = partParent.getParent();
        }
        if (partParent instanceof MCompositePart) {
            partParent = partParent.getParent();
        }
        MPartStack pStack = (MPartStack)(partParent instanceof MPartStack ? partParent : null);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("active");
        List activeElements = this.modelService.findElements((MUIElement)this.modelService.getTopLevelWindowFor((MUIElement)newActivePart), null, MUIElement.class, tags);
        for (MUIElement element : activeElements) {
            if (element instanceof MPartStack && element != pStack) {
                this.styleElement(element, false);
                continue;
            }
            if (!(element instanceof MPart) || element == newActivePart) continue;
            this.styleElement(element, false);
        }
        if (pStack != null) {
            this.styleElement((MUIElement)pStack, true);
        }
        this.styleElement((MUIElement)newActivePart, true);
    }

    @Inject
    @Optional
    private void subscribeTopicSelectedelementChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        if (this.tabStateHandler == null) {
            this.tabStateHandler = new TabStateHandler();
        }
        this.tabStateHandler.handleEvent(event);
    }

    @Override
    protected boolean requiresFocus(MPart element) {
        MPart inStack;
        Object object = inStack = element.getCurSharedRef() != null ? element.getCurSharedRef() : element;
        if (inStack.getParent() != null && inStack.getParent().getTransientData().containsKey(INHIBIT_FOCUS)) {
            inStack.getParent().getTransientData().remove(INHIBIT_FOCUS);
            return false;
        }
        return super.requiresFocus(element);
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.preferenceChange(null);
    }

    protected void updateTab(CTabItem cti, MPart part, String attName, Object newValue) {
        switch (attName) {
            case "label": 
            case "localizedLabel": {
                String newName = (String)newValue;
                cti.setText(this.getLabel((MUILabel)part, newName));
                break;
            }
            case "dirty": {
                cti.setText(this.getLabel((MUILabel)part, part.getLocalizedLabel()));
                break;
            }
            case "iconURI": {
                cti.setImage(this.getImage((MUILabel)part));
                break;
            }
            case "tooltip": 
            case "localizedTooltip": {
                String newTTip = (String)newValue;
                cti.setToolTipText(this.getToolTip(newTTip));
                break;
            }
            case "closeable": {
                Boolean closeableState = (Boolean)newValue;
                cti.setShowClose(closeableState.booleanValue());
                break;
            }
        }
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
    }

    private String getLabel(MUILabel itemPart, String newName) {
        newName = newName == null ? "" : LegacyActionTools.escapeMnemonics((String)newName);
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    private String getToolTip(String newToolTip) {
        return newToolTip == null || newToolTip.length() == 0 ? null : LegacyActionTools.escapeMnemonics((String)newToolTip);
    }

    public Object createWidget(MUIElement element, Object parent) {
        int styleOverride;
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        MPartStack pStack = (MPartStack)element;
        Composite parentComposite = (Composite)parent;
        if (element.getElementId() == null || element.getElementId().length() == 0) {
            String generatedId = "PartStack@" + Integer.toHexString(element.hashCode());
            element.setElementId(generatedId);
        }
        int style = (styleOverride = this.getStyleOverride((MUIElement)pStack)) == -1 ? 2048 : styleOverride;
        CTabFolder tabFolder = new CTabFolder(parentComposite, style);
        tabFolder.setMRUVisible(this.getMRUValue((Control)tabFolder));
        int location = this.modelService.getElementLocation(element);
        if ((location & 8) != 0) {
            tabFolder.setMinimumCharacters(MIN_EDITOR_CHARS);
            tabFolder.setUnselectedCloseVisible(true);
        } else {
            tabFolder.setMinimumCharacters(MIN_VIEW_CHARS);
            tabFolder.setUnselectedCloseVisible(false);
        }
        this.bindWidget(element, tabFolder);
        this.addTopRight(tabFolder);
        return tabFolder;
    }

    private boolean getInitialMRUValue(Control control) {
        CSSRenderingUtils util = (CSSRenderingUtils)this.context.get(CSSRenderingUtils.class);
        if (util == null) {
            return this.getMRUValueFromPreferences();
        }
        CSSValue value = util.getCSSValue(control, "MPartStack", "swt-mru-visible");
        if (value == null) {
            value = util.getCSSValue(control, "MPartStack", "mru-visible");
        }
        if (value == null) {
            return this.getMRUValueFromPreferences();
        }
        return Boolean.parseBoolean(value.getCssText());
    }

    private boolean getMRUValue(Control control) {
        if (CSSPropertyMruVisibleSWTHandler.isMRUControlledByCSS()) {
            return this.getInitialMRUValue(control);
        }
        return this.getMRUValueFromPreferences();
    }

    private boolean getMRUValueFromPreferences() {
        boolean initialMRUValue = this.preferences.getBoolean(MRU_KEY_DEFAULT, true);
        boolean actualValue = this.preferences.getBoolean(MRU_KEY, initialMRUValue);
        return actualValue;
    }

    private void updateMRUValue(CTabFolder tabFolder) {
        boolean actualMRUValue = this.getMRUValue((Control)tabFolder);
        tabFolder.setMRUVisible(actualMRUValue);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        boolean mruControlledByCSS = this.preferences.getBoolean(MRU_CONTROLLED_BY_CSS_KEY, false);
        CSSPropertyMruVisibleSWTHandler.setMRUControlledByCSS((boolean)mruControlledByCSS);
    }

    private void addTopRight(CTabFolder tabFolder) {
        Composite trComp = new Composite((Composite)tabFolder, 0);
        trComp.setBackground(Display.getCurrent().getSystemColor(14));
        RowLayout rl = new RowLayout();
        trComp.setLayout((Layout)rl);
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        rl.marginBottom = 0;
        tabFolder.setTopRight((Control)trComp, 131136);
        trComp.setVisible(false);
        ToolBar menuTB = new ToolBar(trComp, 0x820000);
        menuTB.setData((Object)TAG_VIEW_MENU);
        RowData rd = new RowData();
        menuTB.setLayoutData((Object)rd);
        ToolItem ti = new ToolItem(menuTB, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText(SWTRenderersMessages.viewMenu);
        rd.exclude = true;
        menuTB.setVisible(false);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
        menuTB.getAccessible().addAccessibleListener(AccessibleListener.getNameAdapter(e -> {
            if (e.childID != -1) {
                ToolItem item;
                Accessible accessible = (Accessible)e.getSource();
                ToolBar toolBar = (ToolBar)accessible.getControl();
                if (e.childID >= 0 && e.childID < toolBar.getItemCount() && (item = toolBar.getItem(e.childID)) != null) {
                    e.result = item.getToolTipText();
                }
            }
        }));
        trComp.pack();
    }

    public void adjustTopRight(CTabFolder tabFolder) {
        if (this.adjusting) {
            return;
        }
        this.adjusting = true;
        try {
            MPartStack stack = (MPartStack)tabFolder.getData("modelElement");
            MUIElement element = stack.getSelectedElement();
            MPart curPart = (MPart)tabFolder.getTopRight().getData(THE_PART_KEY);
            MPart part = null;
            if (element != null) {
                part = (MPart)(element instanceof MPart ? element : ((MPlaceholder)element).getRef());
            }
            if (part != curPart && curPart != null && curPart.getToolbar() != null) {
                curPart.getToolbar().setVisible(false);
            }
            Composite trComp = (Composite)tabFolder.getTopRight();
            Control[] kids = trComp.getChildren();
            boolean needsTB = part != null && part.getToolbar() != null && part.getToolbar().isToBeRendered();
            MMenu viewMenu = StackRenderer.getViewMenu(part);
            boolean needsMenu = viewMenu != null && this.hasVisibleMenuItems(viewMenu, part);
            ToolBar menuTB = (ToolBar)kids[kids.length - 1];
            RowData rd = (RowData)menuTB.getLayoutData();
            if (needsMenu) {
                menuTB.getItem(0).setData(THE_PART_KEY, (Object)part);
                menuTB.moveBelow(null);
                menuTB.pack();
                rd.exclude = false;
                menuTB.setVisible(true);
            } else {
                menuTB.getItem(0).setData(THE_PART_KEY, null);
                rd.exclude = true;
                menuTB.setVisible(false);
            }
            ToolBar newViewTB = null;
            if (needsTB && part != null && part.getObject() != null) {
                part.getToolbar().setVisible(true);
                newViewTB = (ToolBar)this.renderer.createGui((MUIElement)part.getToolbar(), (Object)tabFolder.getTopRight(), part.getContext());
                if (newViewTB == null) {
                    this.adjusting = false;
                    return;
                }
                newViewTB.moveAbove(null);
                newViewTB.pack();
            }
            if (needsMenu || needsTB) {
                tabFolder.getTopRight().setData(THE_PART_KEY, (Object)part);
                tabFolder.getTopRight().pack(true);
                tabFolder.getTopRight().setVisible(true);
            } else {
                tabFolder.getTopRight().setData(THE_PART_KEY, null);
                tabFolder.getTopRight().setVisible(false);
            }
            trComp.pack();
        }
        finally {
            this.adjusting = false;
        }
        this.updateMRUValue(tabFolder);
    }

    @Override
    protected void createTab(MElementContainer<MUIElement> stack, MUIElement element) {
        Control control;
        if (!element.isVisible()) {
            return;
        }
        MPart part = null;
        if (element instanceof MPart) {
            part = (MPart)element;
        } else if (element instanceof MPlaceholder && (part = (MPart)((MPlaceholder)element).getRef()) != null) {
            part.setCurSharedRef((MPlaceholder)element);
        }
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        CTabItem tabItem = this.findItemForPart(element, stack);
        if (tabItem != null) {
            if (element.getWidget() != null && tabItem.getControl() != element.getWidget()) {
                tabItem.setControl((Control)element.getWidget());
            }
            return;
        }
        this.updateMRUValue(tabFolder);
        int createFlags = 0;
        if (part != null && this.isClosable(part)) {
            createFlags |= 0x40;
        }
        int index = Math.min(this.calcIndexFor(stack, element), tabFolder.getItemCount());
        tabItem = new CTabItem(tabFolder, createFlags, index);
        tabItem.setData("modelElement", (Object)element);
        tabItem.setText(this.getLabel((MUILabel)part, part.getLocalizedLabel()));
        tabItem.setImage(this.getImage((MUILabel)part));
        String toolTip = this.getToolTip((MUILabel)part);
        if (toolTip == null) {
            toolTip = part.getLocalizedTooltip();
        }
        tabItem.setToolTipText(this.getToolTip(toolTip));
        if (element.getWidget() != null && (control = (Control)element.getWidget()).getParent() == tabFolder) {
            tabItem.setControl((Control)element.getWidget());
        }
    }

    private int calcIndexFor(MElementContainer<MUIElement> stack, MUIElement part) {
        int index = 0;
        for (MUIElement mPart : stack.getChildren()) {
            if (mPart == part) {
                return index;
            }
            if (!mPart.isToBeRendered() || !mPart.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MStackElement)) {
            return;
        }
        this.createTab(parentElement, element);
    }

    private CTabItem findItemForPart(MUIElement element, MElementContainer<MUIElement> stack) {
        CTabItem[] items;
        if (stack == null) {
            stack = element.getParent();
        }
        if (!(stack.getWidget() instanceof CTabFolder)) {
            return null;
        }
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        if (tabFolder == null || tabFolder.isDisposed()) {
            return null;
        }
        CTabItem[] cTabItemArray = items = tabFolder.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData("modelElement") == element) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public CTabItem findItemForPart(MPart part) {
        CTabItem cti;
        if (!part.isToBeRendered()) {
            return null;
        }
        if (part.getParent() != null && part.getParent().getRenderer() == this && (cti = this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)part.getParent())) != null) {
            return cti;
        }
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)part);
        if (win == null) {
            return null;
        }
        List refs = this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, null);
        if (refs != null) {
            for (MPlaceholder ref : refs) {
                CTabItem cti2;
                MElementContainer refParent;
                if (ref.getRef() != part || (refParent = ref.getParent()) == null || !(refParent.getRenderer() instanceof StackRenderer) || (cti2 = this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                return cti2;
            }
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        CTabFolder tabFolder = (CTabFolder)parentElement.getWidget();
        if (tabFolder == null) {
            return;
        }
        CTabItem tabItem = this.findItemForPart(child, parentElement);
        if (tabItem == tabFolder.getSelection() && tabFolder.getItemCount() == 1) {
            this.adjustTopRight(tabFolder);
        }
        if (tabItem != null && !tabItem.isDisposed()) {
            tabItem.setControl(null);
            tabItem.dispose();
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MElementContainer)) {
            return;
        }
        final MElementContainer stack = (MElementContainer)me;
        final CTabFolder tabFolder = (CTabFolder)me.getWidget();
        tabFolder.addTraverseListener(e -> {
            if (e.detail == 64 || e.detail == 32) {
                me.getTransientData().put(INHIBIT_FOCUS, true);
            } else if (e.detail == 4) {
                me.getTransientData().remove(INHIBIT_FOCUS);
                CTabItem cti = tabFolder.getSelection();
                if (cti != null) {
                    MUIElement stackElement = (MUIElement)cti.getData("modelElement");
                    if (stackElement instanceof MPlaceholder) {
                        stackElement = ((MPlaceholder)stackElement).getRef();
                    }
                    if (stackElement instanceof MPart && tabFolder.isFocusControl()) {
                        MPart thePart = (MPart)stackElement;
                        this.renderer.focusGui((MUIElement)thePart);
                    }
                }
            }
        });
        tabFolder.addListener(26, event -> {
            if (event.detail == 3) {
                CTabFolder tabFolder1 = (CTabFolder)event.widget;
                if (tabFolder1.getSelection() == null) {
                    return;
                }
                Point cp = event.display.getCursorLocation();
                CTabItem overItem = tabFolder1.getItem(cp = event.display.map(null, (Control)tabFolder1, cp));
                if (overItem == null || overItem == tabFolder1.getSelection()) {
                    MUIElement uiElement = (MUIElement)tabFolder1.getSelection().getData("modelElement");
                    if (uiElement instanceof MPlaceholder) {
                        uiElement = ((MPlaceholder)uiElement).getRef();
                    }
                    if (uiElement instanceof MPart) {
                        this.activate((MPart)uiElement);
                    }
                }
            }
        });
        tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.ignoreTabSelChanges) {
                return;
            }
            MUIElement ele = (MUIElement)e.item.getData("modelElement");
            ele.getParent().setSelectedElement(ele);
            if (ele instanceof MPlaceholder) {
                ele = ((MPlaceholder)ele).getRef();
            }
            if (ele instanceof MPart) {
                this.activate((MPart)ele);
            }
        }));
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Control ctrl;
                MUIElement ele;
                CTabItem item = tabFolder.getSelection();
                if (item != null && (ele = (MUIElement)item.getData("modelElement")).getParent().getSelectedElement() == ele && (ctrl = (Control)ele.getWidget()) != null) {
                    ctrl.setFocus();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (tabFolder.isDisposed()) {
                    return;
                }
                CTabItem item = tabFolder.getItem(new Point(e.x, e.y));
                if (item != null && e.button == 2) {
                    StackRenderer.this.closePart((Widget)item, false);
                }
                if (e.button == 1) {
                    Control ctrl;
                    MUIElement ele;
                    Rectangle clientArea;
                    if (item == null && !(clientArea = tabFolder.getClientArea()).contains(e.x, e.y)) {
                        item = tabFolder.getSelection();
                    }
                    if (item != null && tabFolder.isFocusControl() && (ele = (MUIElement)item.getData("modelElement")).getParent().getSelectedElement() == ele && (ctrl = (Control)ele.getWidget()) != null) {
                        ctrl.setFocus();
                    }
                }
            }
        };
        tabFolder.addMouseListener((MouseListener)mouseListener);
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = StackRenderer.this.closePart(event.item, true);
            }

            public void showList(CTabFolderEvent event) {
                event.doit = false;
                StackRenderer.this.showAvailableItems(stack, tabFolder);
            }
        };
        tabFolder.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        tabFolder.addMenuDetectListener(e -> {
            Rectangle clientArea;
            Point absolutePoint = new Point(e.x, e.y);
            Point relativePoint = tabFolder.getDisplay().map(null, (Control)tabFolder, absolutePoint);
            CTabItem eventTabItem = tabFolder.getItem(relativePoint);
            if (eventTabItem == null && !(clientArea = tabFolder.getClientArea()).contains(relativePoint)) {
                eventTabItem = tabFolder.getSelection();
            }
            if (eventTabItem != null) {
                MUIElement uiElement = (MUIElement)eventTabItem.getData("modelElement");
                MPart tabPart = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
                this.openMenuFor(tabPart, tabFolder, absolutePoint);
            }
        });
        tabFolder.addControlListener(ControlListener.controlResizedAdapter(e -> this.updateMRUValue(tabFolder)));
    }

    public void showAvailableItems(MElementContainer<?> stack, CTabFolder tabFolder) {
        this.showAvailableItems(stack, tabFolder, false);
    }

    public void showAvailableItems(MElementContainer<?> stack, CTabFolder tabFolder, boolean forceCenter) {
        IEclipseContext ctxt = this.getContext((MUIElement)stack);
        BasicPartList editorList = new BasicPartList(tabFolder.getShell(), 16384, 768, (EPartService)ctxt.get(EPartService.class), stack, this, this.getMRUValueFromPreferences());
        editorList.setInput();
        Point size = editorList.computeSizeHint();
        editorList.setSize(size.x, size.y);
        Point location = null;
        if (forceCenter) {
            Rectangle ca = tabFolder.getClientArea();
            location = tabFolder.toDisplay(ca.x, ca.y);
            location.x = Math.max(0, location.x + (ca.width - size.x) / 2);
            location.y = Math.max(0, location.y + (ca.height - size.y) / 3);
        } else {
            location = tabFolder.toDisplay(this.getChevronLocation(tabFolder));
            Monitor mon = tabFolder.getMonitor();
            Rectangle bounds = mon.getClientArea();
            if (location.x + size.x > bounds.x + bounds.width) {
                location.x = bounds.x + bounds.width - size.x;
            }
            if (location.y + size.y > bounds.y + bounds.height) {
                location.y = bounds.y + bounds.height - size.y;
            }
        }
        editorList.setLocation(location);
        editorList.setVisible(true);
        editorList.setFocus();
        editorList.getShell().addListener(27, event -> editorList.getShell().getDisplay().asyncExec(() -> editorList.dispose()));
    }

    private Point getChevronLocation(CTabFolder tabFolder) {
        int numItems = tabFolder.getItemCount();
        CTabItem item = null;
        int i = 0;
        while (i < numItems) {
            CTabItem tempItem = tabFolder.getItem(i);
            if (tempItem.isShowing()) {
                item = tempItem;
            }
            ++i;
        }
        if (item == null) {
            return new Point(0, 0);
        }
        Rectangle itemBounds = item.getBounds();
        int x = itemBounds.x + itemBounds.width;
        int y = itemBounds.y + itemBounds.height;
        return new Point(x, y);
    }

    private boolean closePart(Widget widget, boolean check) {
        MUIElement uiElement = (MUIElement)widget.getData("modelElement");
        MPart part = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
        if (!check && !this.isClosable(part)) {
            return false;
        }
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = this.getContextForParent((MUIElement)part);
        IEclipseContext context = partContext == null ? parentContext : partContext;
        EPartService partService = (EPartService)context.get(EPartService.class);
        if (partService.savePart(part, true)) {
            partService.hidePart(part);
            return true;
        }
        return false;
    }

    @Override
    protected void showTab(MUIElement element) {
        Control ctrl;
        super.showTab(element);
        if (!element.isVisible()) {
            return;
        }
        CTabFolder tabFolder = (CTabFolder)this.getParentWidget(element);
        CTabItem tabItem = this.findItemForPart(element, null);
        if (tabItem == null) {
            this.createTab((MElementContainer<MUIElement>)element.getParent(), element);
            tabItem = this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
        }
        if ((ctrl = (Control)element.getWidget()) != null && ctrl.getParent() != tabFolder) {
            ctrl.setParent((Composite)tabFolder);
            tabItem.setControl(ctrl);
        } else if (element.getWidget() == null) {
            Control tabCtrl = (Control)this.renderer.createGui(element);
            tabItem.setControl(tabCtrl);
        }
        this.ignoreTabSelChanges = true;
        if (tabItem.getControl() instanceof Composite) {
            Composite ctiComp = (Composite)tabItem.getControl();
            ctiComp.requestLayout();
        }
        tabFolder.setSelection(tabItem);
        this.ignoreTabSelChanges = false;
        this.adjustTopRight(tabFolder);
    }

    protected void showMenu(ToolItem item) {
        MPart part = (MPart)item.getData(THE_PART_KEY);
        if (part == null) {
            return;
        }
        Control ctrl = (Control)part.getWidget();
        MMenu menuModel = StackRenderer.getViewMenu(part);
        if (menuModel == null || !menuModel.isToBeRendered()) {
            return;
        }
        Menu swtMenu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
        if (swtMenu == null) {
            return;
        }
        ctrl.addDisposeListener(e -> {
            if (!swtMenu.isDisposed()) {
                swtMenu.dispose();
            }
        });
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        swtMenu.setLocation(displayAt);
        swtMenu.setVisible(true);
        Display display = swtMenu.getDisplay();
        while (!swtMenu.isDisposed() && swtMenu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!swtMenu.isDisposed() && !(swtMenu.getData() instanceof MenuManager)) {
            swtMenu.dispose();
        }
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 3, 15, 3, 11, 7, 10, 7};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private void openMenuFor(MPart part, CTabFolder folder, Point point) {
        Menu tabMenu = this.createTabMenu(folder, part);
        tabMenu.setData(STACK_SELECTED_PART, (Object)part);
        tabMenu.setLocation(point.x, point.y);
        tabMenu.setVisible(true);
    }

    protected boolean isClosable(MPart part) {
        if (part.getCurSharedRef() != null) {
            return !part.getCurSharedRef().getTags().contains("NoClose");
        }
        return part.isCloseable();
    }

    private Menu createTabMenu(CTabFolder folder, MPart part) {
        Shell shell = folder.getShell();
        Menu cachedMenu = (Menu)shell.getData(SHELL_CLOSE_EDITORS_MENU);
        if (cachedMenu == null) {
            cachedMenu = new Menu((Control)folder);
            shell.setData(SHELL_CLOSE_EDITORS_MENU, (Object)cachedMenu);
        } else {
            MenuItem[] menuItemArray = cachedMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
        Menu menu = cachedMenu;
        this.populateTabMenu(menu, part);
        return menu;
    }

    protected void populateTabMenu(Menu menu, MPart part) {
        MElementContainer<MUIElement> parent;
        this.createMenuItem(menu, SWTRenderersMessages.menuDetach, e -> this.detachActivePart(menu));
        boolean needSeparatorAfterDetach = true;
        int closeableElements = 0;
        if (this.isClosable(part)) {
            needSeparatorAfterDetach = this.createSeparator(menu, needSeparatorAfterDetach);
            this.createMenuItem(menu, SWTRenderersMessages.menuClose, e -> this.closePart(menu));
            ++closeableElements;
        }
        if ((parent = this.getParent(part)) != null && (closeableElements += this.getCloseableSiblingParts(part).size()) >= 2) {
            this.createSeparator(menu, needSeparatorAfterDetach);
            this.createMenuItem(menu, SWTRenderersMessages.menuCloseOthers, e -> this.closeSiblingParts(menu, true));
            if (!this.getCloseableSideParts(part, true).isEmpty()) {
                this.createMenuItem(menu, SWTRenderersMessages.menuCloseLeft, e -> this.closeSideParts(menu, true));
            }
            if (!this.getCloseableSideParts(part, false).isEmpty()) {
                this.createMenuItem(menu, SWTRenderersMessages.menuCloseRight, e -> this.closeSideParts(menu, false));
            }
            new MenuItem(menu, 2);
            this.createMenuItem(menu, SWTRenderersMessages.menuCloseAll, e -> this.closeSiblingParts(menu, false));
        }
    }

    private boolean createSeparator(Menu menu, boolean needSeparator) {
        if (needSeparator) {
            new MenuItem(menu, 2);
            return false;
        }
        return true;
    }

    private void detachActivePart(Menu menu) {
        MPart selectedPart = (MPart)menu.getData(STACK_SELECTED_PART);
        CTabItem cti = this.findItemForPart(selectedPart);
        if (cti == null || cti.getParent() == null) {
            return;
        }
        CTabFolder parent = cti.getParent();
        EModelService modelService = (EModelService)this.getContextForParent((MUIElement)selectedPart).get(EModelService.class);
        Rectangle bounds = parent.getBounds();
        Point display = parent.toDisplay(bounds.x, bounds.y);
        modelService.detach((MPartSashContainerElement)selectedPart, display.x, display.y, bounds.width, bounds.height);
    }

    private void closePart(Menu menu) {
        MPart selectedPart = (MPart)menu.getData(STACK_SELECTED_PART);
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)selectedPart).get(EPartService.class);
        if (partService.savePart(selectedPart, true)) {
            partService.hidePart(selectedPart);
        }
    }

    private MenuItem createMenuItem(Menu menu, String menuItemText, Consumer<SelectionEvent> c) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(menuItemText);
        menuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(c));
        return menuItem;
    }

    private MElementContainer<MUIElement> getParent(MPart part) {
        MElementContainer parent = part.getParent();
        if (parent == null) {
            MPlaceholder placeholder = part.getCurSharedRef();
            return placeholder == null ? null : placeholder.getParent();
        }
        return parent;
    }

    private List<MPart> getCloseableSideParts(MPart part, boolean left) {
        MElementContainer<MUIElement> container = this.getParent(part);
        if (container == null) {
            return new ArrayList<MPart>();
        }
        int thisPartIdx = this.getPartIndex(part, container);
        if (thisPartIdx == -1) {
            return new ArrayList<MPart>();
        }
        List children = container.getChildren();
        int start = left ? 0 : thisPartIdx + 1;
        int end = left ? thisPartIdx : children.size();
        return this.getCloseableSiblingParts(part, children, start, end);
    }

    private int getPartIndex(MPart part, MElementContainer<MUIElement> container) {
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            MUIElement otherItem;
            MUIElement child = (MUIElement)children.get(i);
            MPart otherPart = null;
            if (child instanceof MPart) {
                otherPart = (MPart)child;
            } else if (child instanceof MPlaceholder && (otherItem = ((MPlaceholder)child).getRef()) instanceof MPart) {
                otherPart = (MPart)otherItem;
            }
            if (otherPart == part) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<MPart> getCloseableSiblingParts(MPart part) {
        MElementContainer<MUIElement> container = this.getParent(part);
        if (container == null) {
            return new ArrayList<MPart>();
        }
        List children = container.getChildren();
        return this.getCloseableSiblingParts(part, children, 0, children.size());
    }

    private List<MPart> getCloseableSiblingParts(MPart part, List<MUIElement> children, int start, int end) {
        ArrayList<MPart> closeableSiblings = new ArrayList<MPart>();
        int i = start;
        while (i < end) {
            MUIElement child = children.get(i);
            if (child.isToBeRendered()) {
                MUIElement otherItem;
                MPart otherPart = null;
                if (child instanceof MPart) {
                    otherPart = (MPart)child;
                } else if (child instanceof MPlaceholder && (otherItem = ((MPlaceholder)child).getRef()) instanceof MPart) {
                    otherPart = (MPart)otherItem;
                }
                if (otherPart != null && !part.equals(otherPart) && otherPart.isToBeRendered() && this.isClosable(otherPart)) {
                    closeableSiblings.add(otherPart);
                }
            }
            ++i;
        }
        return closeableSiblings;
    }

    private void closeSideParts(Menu menu, boolean left) {
        MPart selectedPart = (MPart)menu.getData(STACK_SELECTED_PART);
        MElementContainer<MUIElement> container = this.getParent(selectedPart);
        if (container == null) {
            return;
        }
        List<MPart> others = this.getCloseableSideParts(selectedPart, left);
        this.closeSiblingParts(selectedPart, others, true);
    }

    private void closeSiblingParts(Menu menu, boolean skipThisPart) {
        MPart part = (MPart)menu.getData(STACK_SELECTED_PART);
        MElementContainer<MUIElement> container = this.getParent(part);
        if (container == null) {
            return;
        }
        List<MPart> others = this.getCloseableSiblingParts(part);
        this.closeSiblingParts(part, others, skipThisPart);
    }

    private void closeSiblingParts(MPart part, List<MPart> others, boolean skipThisPart) {
        MUIElement selectedElement;
        MElementContainer<MUIElement> container = this.getParent(part);
        if (!skipThisPart && part.isToBeRendered() && this.isClosable(part)) {
            others.add(part);
        }
        if (others.remove(selectedElement = container.getSelectedElement())) {
            others.add((MPart)selectedElement);
        } else if (selectedElement instanceof MPlaceholder && others.remove(selectedElement = ((MPlaceholder)selectedElement).getRef())) {
            others.add((MPart)selectedElement);
        }
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)part).get(EPartService.class);
        ISaveHandler saveHandler = (ISaveHandler)this.getContextForParent((MUIElement)part).get(ISaveHandler.class);
        if (saveHandler != null) {
            ArrayList<MPart> toPrompt = new ArrayList<MPart>(others);
            toPrompt.retainAll(partService.getDirtyParts());
            boolean cancel = false;
            if (toPrompt.size() > 1) {
                cancel = !saveHandler.saveParts(toPrompt, true);
            } else if (toPrompt.size() == 1) {
                boolean bl = cancel = !saveHandler.save((MPart)toPrompt.get(0), true);
            }
            if (cancel) {
                return;
            }
            for (MPart other : others) {
                partService.hidePart(other);
            }
            return;
        }
        for (MPart otherPart : others) {
            if (!partService.savePart(otherPart, true)) continue;
            partService.hidePart(otherPart);
        }
    }

    public static MMenu getViewMenu(MPart part) {
        if (part == null || part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU)) continue;
            return menu;
        }
        return null;
    }

    private boolean hasVisibleMenuItems(MMenu viewMenu, MPart part) {
        Menu menu;
        MenuManager manager;
        if (!viewMenu.isToBeRendered() || !viewMenu.isVisible()) {
            return false;
        }
        for (MMenuElement menuElement : viewMenu.getChildren()) {
            if (!menuElement.isToBeRendered() || !menuElement.isVisible()) continue;
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)menuElement) || OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)menuElement)) {
                IContributionItem item = (IContributionItem)OpaqueElementUtil.getOpaqueItem((MUIElement)menuElement);
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            return true;
        }
        Object menuRenderer = viewMenu.getRenderer();
        if (menuRenderer instanceof MenuManagerRenderer && (manager = ((MenuManagerRenderer)((Object)menuRenderer)).getManager(viewMenu)) != null && manager.isVisible()) {
            return true;
        }
        Control control = (Control)part.getWidget();
        if (control != null && (menu = (Menu)this.renderer.createGui((MUIElement)viewMenu, (Object)control.getShell(), part.getContext())) != null) {
            MenuManagerRenderer menuManagerRenderer;
            MenuManager manager2;
            menuRenderer = viewMenu.getRenderer();
            if (menuRenderer instanceof MenuManagerRenderer && (manager2 = (menuManagerRenderer = (MenuManagerRenderer)((Object)menuRenderer)).getManager(viewMenu)) != null) {
                manager2.markDirty();
            }
            return menu.getItemCount() != 0;
        }
        return false;
    }

    static boolean isCssEngineActive(CTabItem cti) {
        return WidgetElement.getEngine((Widget)cti.getParent()) != null;
    }

    static void removeHighlight(MPart part, CTabItem cti, boolean cssEngineActive) {
        part.getTags().remove("highlighted");
        if (!cssEngineActive) {
            cti.setFont(JFaceResources.getFontRegistry().get(TAB_FONT_KEY));
        }
    }

    static void addHighlight(MPart part, CTabItem cti, boolean cssEngineActive) {
        part.getTags().add("highlighted");
        if (!cssEngineActive) {
            cti.setFont(JFaceResources.getFontRegistry().getBold(TAB_FONT_KEY));
        }
    }

    static void updateBusyStateNoCss(CTabItem cti, Object newValue, Object oldValue) {
        Font updatedFont = null;
        if ("busy".equals(newValue)) {
            updatedFont = JFaceResources.getFontRegistry().getItalic(TAB_FONT_KEY);
        } else if ("busy".equals(oldValue)) {
            updatedFont = JFaceResources.getFontRegistry().get(TAB_FONT_KEY);
        }
        if (updatedFont != null) {
            cti.setFont(updatedFont);
        }
    }

    public class TabStateHandler
    implements EventHandler {
        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            Object newValue = event.getProperty("NewValue");
            Object oldValue = event.getProperty("OldValue");
            if (!this.validateElement(element) || !this.validateValues(oldValue, newValue)) {
                return;
            }
            MPart part = newValue instanceof MPlaceholder ? (MPart)((MPlaceholder)newValue).getRef() : (MPart)element;
            CTabItem cti = StackRenderer.this.findItemForPart(part);
            if (cti == null) {
                return;
            }
            boolean isCssEngineActive = StackRenderer.isCssEngineActive(cti);
            boolean isSelectedTab = cti == cti.getParent().getSelection();
            boolean partActivatedEvent = newValue instanceof MPlaceholder;
            if ("contentChange".equals(newValue)) {
                part.getTags().remove("contentChange");
                if (!isSelectedTab) {
                    StackRenderer.addHighlight(part, cti, isCssEngineActive);
                }
            } else if (partActivatedEvent && part.getTags().contains("highlighted")) {
                StackRenderer.removeHighlight(part, cti, isCssEngineActive);
            }
            String prevCssCls = WidgetElement.getCSSClass((Widget)cti);
            StackRenderer.this.setCSSInfo((MUIElement)part, cti);
            if (prevCssCls == null || !prevCssCls.equals(WidgetElement.getCSSClass((Widget)cti))) {
                StackRenderer.this.reapplyStyles((Widget)cti.getParent());
            }
            if (isCssEngineActive || partActivatedEvent) {
                return;
            }
            StackRenderer.updateBusyStateNoCss(cti, newValue, oldValue);
        }

        public boolean validateElement(Object element) {
            return element instanceof MPart || element instanceof MPartStack;
        }

        public boolean validateValues(Object oldValue, Object newValue) {
            return newValue instanceof MPlaceholder || this.isTagAdded("busy", oldValue, newValue) || this.isTagRemoved("busy", oldValue, newValue) || this.isTagAdded("contentChange", oldValue, newValue);
        }

        private boolean isTagAdded(String tagName, Object oldValue, Object newValue) {
            return oldValue == null && tagName.equals(newValue);
        }

        private boolean isTagRemoved(String tagName, Object oldValue, Object newValue) {
            return newValue == null && tagName.equals(oldValue);
        }
    }
}

