/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.registry;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.osgi.framework.Bundle;

public class CheatSheetItemExtensionElement
extends WorkbenchAdapter
implements IAdaptable {
    private String className;
    private String itemAttribute;
    private IConfigurationElement configurationElement;
    private final Class<?>[] stringArray = new Class[]{String.class};

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast((Object)this);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getClassName() {
        return this.className;
    }

    public String getItemAttribute() {
        return this.itemAttribute;
    }

    public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
        this.configurationElement = newConfigurationElement;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public void setItemAttribute(String value) {
        this.itemAttribute = value;
    }

    public AbstractItemExtensionElement createInstance() {
        Status status;
        String message;
        Class extClass = null;
        AbstractItemExtensionElement extElement = null;
        String pluginId = this.configurationElement.getContributor().getName();
        try {
            Bundle bundle = Platform.getBundle((String)pluginId);
            extClass = bundle.loadClass(this.className);
        }
        catch (Exception e) {
            message = NLS.bind((String)Messages.ERROR_LOADING_CLASS, (Object[])new Object[]{this.className});
            status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        }
        try {
            if (extClass != null) {
                Constructor c = extClass.getConstructor(this.stringArray);
                extElement = (AbstractItemExtensionElement)c.newInstance(this.itemAttribute);
            }
        }
        catch (Exception e) {
            message = NLS.bind((String)Messages.ERROR_CREATING_CLASS, (Object[])new Object[]{this.className});
            status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        }
        if (extElement != null) {
            return extElement;
        }
        return null;
    }
}

