/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.workingset;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.util.FastStack;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.w3c.dom.Element;

public class AdaptableTopic
extends AdaptableHelpResource {
    private Map<String, IHelpResource> topicMap;

    public AdaptableTopic(ITopic element) {
        super((IHelpResource)element);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ITopic.class) {
            return (T)this.element;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public AdaptableHelpResource[] getChildren() {
        ITopic[] topics = this.getSubtopics();
        AdaptableHelpResource[] adaptableTopic = new AdaptableTopic[topics.length];
        int i = 0;
        while (i < topics.length) {
            adaptableTopic[i] = new AdaptableTopic(topics[i]);
            ++i;
        }
        return adaptableTopic;
    }

    public ITopic[] getSubtopics() {
        return ((ITopic)this.element).getSubtopics();
    }

    @Override
    public ITopic getTopic(String href) {
        if (href == null) {
            return null;
        }
        if (this.topicMap == null) {
            this.topicMap = new HashMap<String, IHelpResource>();
            this.topicMap.put(this.getHref(), this.element);
            FastStack stack = new FastStack();
            ITopic[] topics = this.getSubtopics();
            int i = 0;
            while (i < topics.length) {
                stack.push((Object)topics[i]);
                ++i;
            }
            while (!stack.isEmpty()) {
                ITopic topic = (ITopic)stack.pop();
                if (topic == null) continue;
                String topicHref = topic.getHref();
                if (topicHref != null) {
                    this.topicMap.put(topicHref, (IHelpResource)topic);
                }
                ITopic[] subtopics = topic.getSubtopics();
                int i2 = 0;
                while (i2 < subtopics.length) {
                    stack.push((Object)subtopics[i2]);
                    ++i2;
                }
            }
        }
        return (ITopic)this.topicMap.get(href);
    }

    @Override
    public void saveState(Element element) {
        AdaptableToc toc = (AdaptableToc)this.getParent();
        toc.saveState(element);
        AdaptableHelpResource[] topics = toc.getChildren();
        int i = 0;
        while (i < topics.length) {
            if (topics[i] == this) {
                element.setAttribute("topic", String.valueOf(i));
            }
            ++i;
        }
    }
}

