/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;

public class IndexDiffData {
    private static final String NEW_LINE = "\n";
    private final Set<String> added;
    private final Set<String> assumeUnchanged;
    private final Set<String> changed;
    private final Set<String> removed;
    private final Set<String> missing;
    private final Set<String> modified;
    private final Set<String> untracked;
    private final Set<String> untrackedFolders;
    private final Set<String> conflicts;
    private final Set<String> ignored;
    private final Set<String> symlinks;
    private final Set<String> submodules;
    private final Collection<IResource> changedResources;

    public IndexDiffData() {
        this.added = Collections.emptySet();
        this.assumeUnchanged = Collections.emptySet();
        this.changed = Collections.emptySet();
        this.removed = Collections.emptySet();
        this.missing = Collections.emptySet();
        this.modified = Collections.emptySet();
        this.untracked = Collections.emptySet();
        this.untrackedFolders = Collections.emptySet();
        this.conflicts = Collections.emptySet();
        this.ignored = Collections.emptySet();
        this.symlinks = Collections.emptySet();
        this.submodules = Collections.emptySet();
        this.changedResources = Collections.emptySet();
    }

    public IndexDiffData(IndexDiff indexDiff) {
        this.added = Collections.unmodifiableSet(new HashSet(indexDiff.getAdded()));
        this.assumeUnchanged = Collections.unmodifiableSet(new HashSet(indexDiff.getAssumeUnchanged()));
        this.changed = Collections.unmodifiableSet(new HashSet(indexDiff.getChanged()));
        this.removed = Collections.unmodifiableSet(new HashSet(indexDiff.getRemoved()));
        this.missing = Collections.unmodifiableSet(new HashSet(indexDiff.getMissing()));
        this.modified = Collections.unmodifiableSet(new HashSet(indexDiff.getModified()));
        this.untracked = Collections.unmodifiableSet(new HashSet(indexDiff.getUntracked()));
        this.untrackedFolders = Collections.unmodifiableSet(this.getUntrackedFolders(indexDiff));
        this.conflicts = Collections.unmodifiableSet(new HashSet(indexDiff.getConflicting()));
        this.ignored = Collections.unmodifiableSet(new HashSet(indexDiff.getIgnoredNotInIndex()));
        this.symlinks = Collections.unmodifiableSet(new HashSet(indexDiff.getPathsWithIndexMode(FileMode.SYMLINK)));
        this.submodules = Collections.unmodifiableSet(new HashSet(indexDiff.getPathsWithIndexMode(FileMode.GITLINK)));
        this.changedResources = Collections.emptySet();
    }

    private Set<String> getUntrackedFolders(IndexDiff indexDiff) {
        HashSet<String> result = new HashSet<String>();
        for (String folder : indexDiff.getUntrackedFolders()) {
            result.add(String.valueOf(folder) + "/");
        }
        return result;
    }

    public IndexDiffData(IndexDiffData baseDiff, Collection<String> changedFiles, Collection<IResource> changedResources, IndexDiff diffForChangedFiles) {
        this.changedResources = Collections.unmodifiableCollection(new HashSet<IResource>(changedResources));
        HashSet<String> added2 = new HashSet<String>(baseDiff.getAdded());
        HashSet<String> assumeUnchanged2 = new HashSet<String>(baseDiff.getAssumeUnchanged());
        HashSet<String> changed2 = new HashSet<String>(baseDiff.getChanged());
        HashSet<String> removed2 = new HashSet<String>(baseDiff.getRemoved());
        HashSet<String> missing2 = new HashSet<String>(baseDiff.getMissing());
        HashSet<String> modified2 = new HashSet<String>(baseDiff.getModified());
        HashSet<String> untracked2 = new HashSet<String>(baseDiff.getUntracked());
        HashSet<String> conflicts2 = new HashSet<String>(baseDiff.getConflicting());
        HashSet<String> symlinks2 = new HashSet<String>(baseDiff.getSymlinks());
        HashSet<String> submodules2 = new HashSet<String>(baseDiff.getSubmodules());
        this.mergeList(added2, changedFiles, diffForChangedFiles.getAdded());
        this.mergeList(assumeUnchanged2, changedFiles, diffForChangedFiles.getAssumeUnchanged());
        this.mergeList(changed2, changedFiles, diffForChangedFiles.getChanged());
        this.mergeList(removed2, changedFiles, diffForChangedFiles.getRemoved());
        this.mergeList(missing2, changedFiles, diffForChangedFiles.getMissing());
        this.mergeList(modified2, changedFiles, diffForChangedFiles.getModified());
        this.mergeList(untracked2, changedFiles, diffForChangedFiles.getUntracked());
        this.mergeList(symlinks2, changedFiles, diffForChangedFiles.getPathsWithIndexMode(FileMode.SYMLINK));
        this.mergeList(submodules2, changedFiles, diffForChangedFiles.getPathsWithIndexMode(FileMode.GITLINK));
        Set<String> untrackedFolders2 = IndexDiffData.mergeUntrackedFolders(baseDiff.getUntrackedFolders(), changedFiles, this.getUntrackedFolders(diffForChangedFiles));
        this.mergeList(conflicts2, changedFiles, diffForChangedFiles.getConflicting());
        Set<String> ignored2 = IndexDiffData.mergeIgnored(baseDiff.getIgnoredNotInIndex(), changedFiles, diffForChangedFiles.getIgnoredNotInIndex());
        this.added = Collections.unmodifiableSet(added2);
        this.assumeUnchanged = Collections.unmodifiableSet(assumeUnchanged2);
        this.changed = Collections.unmodifiableSet(changed2);
        this.removed = Collections.unmodifiableSet(removed2);
        this.missing = Collections.unmodifiableSet(missing2);
        this.modified = Collections.unmodifiableSet(modified2);
        this.untracked = Collections.unmodifiableSet(untracked2);
        this.untrackedFolders = Collections.unmodifiableSet(untrackedFolders2);
        this.conflicts = Collections.unmodifiableSet(conflicts2);
        this.ignored = Collections.unmodifiableSet(ignored2);
        this.symlinks = Collections.unmodifiableSet(symlinks2);
        this.submodules = Collections.unmodifiableSet(submodules2);
    }

    private void mergeList(Set<String> baseList, Collection<String> changedFiles, Set<String> listForChangedFiles) {
        for (String file : changedFiles) {
            if (baseList.contains(file)) {
                if (listForChangedFiles.contains(file)) continue;
                baseList.remove(file);
                continue;
            }
            if (!listForChangedFiles.contains(file)) continue;
            baseList.add(file);
        }
    }

    private static Set<String> mergeUntrackedFolders(Set<String> oldUntrackedFolders, Collection<String> changedFiles, Set<String> newUntrackedFolders) {
        HashSet<String> merged = new HashSet<String>();
        for (String oldUntrackedFolder : oldUntrackedFolders) {
            boolean changeInUntrackedFolder = IndexDiffData.isAnyFileContainedInFolder(oldUntrackedFolder, changedFiles);
            if (changeInUntrackedFolder) continue;
            merged.add(oldUntrackedFolder);
        }
        merged.addAll(newUntrackedFolders);
        return merged;
    }

    private static boolean isAnyFileContainedInFolder(String folder, Collection<String> files) {
        for (String file : files) {
            if (!file.startsWith(folder)) continue;
            return true;
        }
        return false;
    }

    protected static Set<String> mergeIgnored(Set<String> oldIgnoredPaths, Collection<String> changedPaths, Set<String> newIgnoredPaths) {
        HashSet<String> merged = new HashSet<String>();
        for (String oldIgnoredPath : oldIgnoredPaths) {
            boolean changed = IndexDiffData.isAnyPrefixOf(oldIgnoredPath, changedPaths);
            if (changed) continue;
            merged.add(oldIgnoredPath);
        }
        merged.addAll(newIgnoredPaths);
        return merged;
    }

    protected static boolean isAnyPrefixOf(String pathToCheck, Collection<String> possiblePrefixes) {
        for (String possiblePrefix : possiblePrefixes) {
            if (pathToCheck.startsWith(possiblePrefix)) {
                return true;
            }
            if (possiblePrefix.length() != pathToCheck.length() + 1 || possiblePrefix.charAt(possiblePrefix.length() - 1) != '/' || !possiblePrefix.startsWith(pathToCheck)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public Set<String> getAdded() {
        return Collections.unmodifiableSet(this.added);
    }

    @NonNull
    public Set<String> getAssumeUnchanged() {
        return Collections.unmodifiableSet(this.assumeUnchanged);
    }

    @NonNull
    public Set<String> getChanged() {
        return this.changed;
    }

    @NonNull
    public Set<String> getRemoved() {
        return this.removed;
    }

    @NonNull
    public Set<String> getMissing() {
        return this.missing;
    }

    @NonNull
    public Set<String> getModified() {
        return this.modified;
    }

    @NonNull
    public Set<String> getUntracked() {
        return this.untracked;
    }

    @NonNull
    public Set<String> getUntrackedFolders() {
        return this.untrackedFolders;
    }

    @NonNull
    public Set<String> getConflicting() {
        return this.conflicts;
    }

    @NonNull
    public Set<String> getIgnoredNotInIndex() {
        return this.ignored;
    }

    @NonNull
    public Set<String> getSymlinks() {
        return this.symlinks;
    }

    @NonNull
    public Set<String> getSubmodules() {
        return this.submodules;
    }

    public boolean hasChanges() {
        return !this.getAdded().isEmpty() || !this.getChanged().isEmpty() || !this.getRemoved().isEmpty() || !this.getUntracked().isEmpty() || !this.getModified().isEmpty() || !this.getMissing().isEmpty();
    }

    @NonNull
    public Collection<IResource> getChangedResources() {
        return this.changedResources;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.dumpList(builder, "added", this.added);
        this.dumpList(builder, "assumeUnchanged", this.assumeUnchanged);
        this.dumpList(builder, "changed", this.changed);
        this.dumpList(builder, "removed", this.removed);
        this.dumpList(builder, "missing", this.missing);
        this.dumpList(builder, "modified", this.modified);
        this.dumpList(builder, "untracked", this.untracked);
        this.dumpList(builder, "untrackedFolders", this.untrackedFolders);
        this.dumpList(builder, "conflicts", this.conflicts);
        this.dumpList(builder, "ignored", this.ignored);
        this.dumpList(builder, "symlinks", this.symlinks);
        this.dumpList(builder, "submodules", this.submodules);
        this.dumpResourceList(builder, "changedResources", this.changedResources);
        return builder.toString();
    }

    private void dumpList(StringBuilder builder, String listName, Set<String> list) {
        builder.append(listName);
        builder.append(NEW_LINE);
        for (String entry : list) {
            builder.append(entry);
            builder.append(NEW_LINE);
        }
        builder.append(NEW_LINE);
    }

    private void dumpResourceList(StringBuilder builder, String listName, Collection<IResource> list) {
        if (list == null) {
            return;
        }
        builder.append(listName);
        builder.append(NEW_LINE);
        for (IResource file : list) {
            builder.append(file.getFullPath().toOSString());
            builder.append(NEW_LINE);
        }
        builder.append(NEW_LINE);
    }
}

