/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;

public class StagingEntry
extends PlatformObject
implements IProblemDecoratable,
IDecoratableResource {
    private final Repository repository;
    private final State state;
    private final String path;
    private boolean fileLoaded;
    private IFile file;
    private String name;
    private StagingFolderEntry parent;
    private boolean submodule;
    private boolean symlink;

    public StagingEntry(Repository repository, State state, String path) {
        this.repository = repository;
        this.state = state;
        this.path = path;
    }

    public void setSubmodule(boolean submodule) {
        this.submodule = submodule;
    }

    public boolean isSubmodule() {
        return this.submodule;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    public boolean isSymlink() {
        return this.symlink;
    }

    public String getPath() {
        return this.path;
    }

    public IPath getParentPath() {
        return new Path(this.path).removeLastSegments(1);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public State getState() {
        return this.state;
    }

    Set<Action> getAvailableActions() {
        return this.state.getAvailableActions();
    }

    public IFile getFile() {
        if (!this.fileLoaded) {
            this.fileLoaded = true;
            this.file = ResourceUtil.getFileForLocation((Repository)this.repository, (String)this.path, (boolean)false);
        }
        return this.file;
    }

    @NonNull
    public IPath getLocation() {
        IPath absolutePath = new Path(this.repository.getWorkTree().getAbsolutePath()).append(this.path);
        return absolutePath;
    }

    public StagingFolderEntry getParent() {
        return this.parent;
    }

    public void setParent(StagingFolderEntry parent) {
        this.parent = parent;
    }

    @Override
    public int getProblemSeverity() {
        IFile f = this.getFile();
        if (f == null) {
            return -1;
        }
        try {
            return f.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0);
        }
        catch (CoreException e) {
            return -1;
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            IPath parsed = Path.fromOSString((String)this.getPath());
            this.name = parsed.lastSegment();
        }
        return this.name;
    }

    @Override
    public String getRepositoryName() {
        return null;
    }

    @Override
    public String getBranch() {
        return null;
    }

    @Override
    public String getBranchStatus() {
        return null;
    }

    @Override
    public String getCommitMessage() {
        return null;
    }

    @Override
    public boolean isTracked() {
        return this.state != State.UNTRACKED;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.state == State.MODIFIED || this.state == State.MODIFIED_AND_CHANGED || this.state == State.MODIFIED_AND_ADDED;
    }

    @Override
    public boolean isMissing() {
        return this.state == State.MISSING || this.state == State.MISSING_AND_CHANGED;
    }

    @Override
    public boolean hasUnstagedChanges() {
        return !this.isTracked() || this.isDirty() || this.isMissing() || this.hasConflicts();
    }

    @Override
    public IResourceState.StagingState getStagingState() {
        switch (this.state) {
            case ADDED: {
                return IResourceState.StagingState.ADDED;
            }
            case CHANGED: {
                return IResourceState.StagingState.MODIFIED;
            }
            case REMOVED: {
                return IResourceState.StagingState.REMOVED;
            }
            case MISSING: 
            case MISSING_AND_CHANGED: {
                return IResourceState.StagingState.REMOVED;
            }
        }
        return IResourceState.StagingState.NOT_STAGED;
    }

    @Override
    public boolean isStaged() {
        return this.getStagingState() != IResourceState.StagingState.NOT_STAGED;
    }

    @Override
    public boolean hasConflicts() {
        return this.state == State.CONFLICTING;
    }

    @Override
    public boolean isAssumeUnchanged() {
        return false;
    }

    public String toString() {
        return "StagingEntry[" + (Object)((Object)this.state) + ' ' + this.path + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StagingEntry other = (StagingEntry)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.state == other.state;
    }

    @Override
    public boolean isRepositoryContainer() {
        return false;
    }

    static enum Action {
        REPLACE_WITH_FILE_IN_GIT_INDEX,
        REPLACE_WITH_HEAD_REVISION,
        STAGE,
        UNSTAGE,
        DELETE,
        IGNORE,
        LAUNCH_MERGE_TOOL,
        REPLACE_WITH_OURS_THEIRS_MENU,
        ASSUME_UNCHANGED,
        UNTRACK;

    }

    public static enum State {
        ADDED(EnumSet.of(Action.UNSTAGE)),
        CHANGED(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.UNSTAGE)),
        REMOVED(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.UNSTAGE)),
        MISSING(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MISSING_AND_CHANGED(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MODIFIED(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE, Action.ASSUME_UNCHANGED, Action.UNTRACK)),
        MODIFIED_AND_CHANGED(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MODIFIED_AND_ADDED(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.STAGE)),
        UNTRACKED(EnumSet.of(Action.STAGE, Action.DELETE, Action.IGNORE)),
        CONFLICTING(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE, Action.LAUNCH_MERGE_TOOL, Action.REPLACE_WITH_OURS_THEIRS_MENU));

        private final Set<Action> availableActions;

        private State(Set<Action> availableActions) {
            this.availableActions = availableActions;
        }

        public Set<Action> getAvailableActions() {
            return this.availableActions;
        }
    }
}

