/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

public class Utility {
    public static final char[] STRING_CHAR_ARRAY = "\u672a##\u4e32".toCharArray();
    public static final char[] NUMBER_CHAR_ARRAY = "\u672a##\u6570".toCharArray();
    public static final char[] START_CHAR_ARRAY = "\u59cb##\u59cb".toCharArray();
    public static final char[] END_CHAR_ARRAY = "\u672b##\u672b".toCharArray();
    public static final char[] COMMON_DELIMITER = new char[]{','};
    public static final String SPACES = " \u3000\t\r\n";
    public static final int MAX_FREQUENCE = 2159997;

    public static int compareArray(char[] larray, int lstartIndex, char[] rarray, int rstartIndex) {
        int ri;
        if (larray == null) {
            if (rarray == null || rstartIndex >= rarray.length) {
                return 0;
            }
            return -1;
        }
        if (rarray == null) {
            if (lstartIndex >= larray.length) {
                return 0;
            }
            return 1;
        }
        int li = lstartIndex;
        for (ri = rstartIndex; li < larray.length && ri < rarray.length && larray[li] == rarray[ri]; ++li, ++ri) {
        }
        if (li == larray.length) {
            if (ri == rarray.length) {
                return 0;
            }
            return -1;
        }
        if (ri == rarray.length) {
            return 1;
        }
        if (larray[li] > rarray[ri]) {
            return 1;
        }
        return -1;
    }

    public static int compareArrayByPrefix(char[] shortArray, int shortIndex, char[] longArray, int longIndex) {
        int li;
        if (shortArray == null) {
            return 0;
        }
        if (longArray == null) {
            return shortIndex < shortArray.length ? 1 : 0;
        }
        int si = shortIndex;
        for (li = longIndex; si < shortArray.length && li < longArray.length && shortArray[si] == longArray[li]; ++si, ++li) {
        }
        if (si == shortArray.length) {
            return 0;
        }
        if (li == longArray.length) {
            return 1;
        }
        return shortArray[si] > longArray[li] ? 1 : -1;
    }

    public static int getCharType(char ch) {
        if (ch >= '\u4e00' && ch <= '\u9fa5') {
            return 3;
        }
        if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
            return 1;
        }
        if (ch >= '0' && ch <= '9') {
            return 2;
        }
        if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n' || ch == '\u3000') {
            return 4;
        }
        if (ch >= '!' && ch <= '\u00bb' || ch >= '\u2010' && ch <= '\u2642' || ch >= '\u3001' && ch <= '\u301e') {
            return 0;
        }
        if (ch >= '\uff21' && ch <= '\uff3a' || ch >= '\uff41' && ch <= '\uff5a') {
            return 5;
        }
        if (ch >= '\uff10' && ch <= '\uff19') {
            return 6;
        }
        if (ch >= '\ufe30' && ch <= '\uff63') {
            return 0;
        }
        return 7;
    }
}

